/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Label;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TryCatchRecorder {
    private static final Logger log = LoggerFactory.getLogger(TryCatchRecorder.class);
    private final TryCatchBlocksFinishedListener tryCatchBlocksFinishedListener;
    private final Map<Label, Map<Label, RawTryCatchBlock>> blocksByEndByStart = new HashMap<Label, Map<Label, RawTryCatchBlock>>();
    private final Multimap<Label, RawTryCatchBlock> activeBlocksByEnd = HashMultimap.create();
    private final Set<Label> handlers = new HashSet<Label>();
    private Label lastEncounteredLabelWithoutLineNumber = null;
    private boolean active = false;

    TryCatchRecorder(TryCatchBlocksFinishedListener tryCatchBlocksFinishedListener) {
        this.tryCatchBlocksFinishedListener = tryCatchBlocksFinishedListener;
    }

    void onEncounteredLabel(Label label, int lineNumber) {
        if (!this.active) {
            return;
        }
        this.processStartingBlocks(label, lineNumber);
        this.processEndingBlocks(label);
        this.lastEncounteredLabelWithoutLineNumber = null;
    }

    void onEncounteredLabel(Label label) {
        if (!this.active) {
            return;
        }
        if (this.lastEncounteredLabelWithoutLineNumber != null) {
            this.processLabelWithoutLineNumber(this.lastEncounteredLabelWithoutLineNumber);
        }
        this.lastEncounteredLabelWithoutLineNumber = label;
    }

    private void processLabelWithoutLineNumber(Label label) {
        this.blocksByEndByStart.remove(label);
        this.processEndingBlocks(label);
    }

    private void processStartingBlocks(Label start, int lineNumber) {
        Map<Label, RawTryCatchBlock> blocksByEnd = this.blocksByEndByStart.remove(start);
        if (blocksByEnd == null) {
            return;
        }
        for (Map.Entry<Label, RawTryCatchBlock> endToBlock : blocksByEnd.entrySet()) {
            endToBlock.getValue().setLineNumber(lineNumber);
            this.activeBlocksByEnd.put(endToBlock.getKey(), endToBlock.getValue());
        }
    }

    private void processEndingBlocks(Label end) {
        Collection<RawTryCatchBlock> finishedBlocks = this.activeBlocksByEnd.removeAll(end);
        Set finishedBuilders = finishedBlocks.stream().map(block -> new DomainBuilders.TryCatchBlockBuilder().withCaughtThrowables(((RawTryCatchBlock)block).caughtThrowables).withLineNumber(((RawTryCatchBlock)block).lineNumber).withRawAccessesInTryBlock(((RawTryCatchBlock)block).accessesInTryBlock)).collect(ImmutableSet.toImmutableSet());
        this.tryCatchBlocksFinishedListener.onTryCatchBlocksFinished(finishedBuilders);
        if (this.blocksByEndByStart.isEmpty() && this.activeBlocksByEnd.isEmpty()) {
            this.active = false;
        }
    }

    void registerTryCatchBlock(Label start, Label end, Label handler, JavaClassDescriptor throwableType) {
        this.getOrCreateTryCatchBlock(start, end).addThrowable(throwableType);
        this.active = true;
        this.handlers.add(handler);
    }

    void registerTryFinallyBlock(Label start, Label end, Label handler) {
        if (!this.handlers.contains(start)) {
            this.getOrCreateTryCatchBlock(start, end);
            this.active = true;
        }
        this.handlers.add(handler);
    }

    void registerAccess(RawAccessRecord accessRecord) {
        if (!this.active) {
            return;
        }
        this.activeBlocksByEnd.values().forEach(block -> block.addAccess(accessRecord));
    }

    void onEncounteredMethodEnd() {
        if (this.lastEncounteredLabelWithoutLineNumber != null) {
            this.processLabelWithoutLineNumber(this.lastEncounteredLabelWithoutLineNumber);
            this.lastEncounteredLabelWithoutLineNumber = null;
        }
        this.handlers.clear();
        if (!this.blocksByEndByStart.isEmpty()) {
            log.warn("Failed to process some try-catch-blocks");
            this.blocksByEndByStart.clear();
        }
        if (!this.activeBlocksByEnd.isEmpty()) {
            log.warn("Failed to finish processing of some active try-catch-blocks");
            this.activeBlocksByEnd.clear();
        }
    }

    private RawTryCatchBlock getOrCreateTryCatchBlock(Label start, Label end) {
        Map blocksByEnd = this.blocksByEndByStart.computeIfAbsent(start, __ -> new HashMap());
        return blocksByEnd.computeIfAbsent(end, __ -> new RawTryCatchBlock());
    }

    static interface TryCatchBlocksFinishedListener {
        public void onTryCatchBlocksFinished(Set<DomainBuilders.TryCatchBlockBuilder> var1);
    }

    private static class RawTryCatchBlock {
        private final Set<JavaClassDescriptor> caughtThrowables = new HashSet<JavaClassDescriptor>();
        private int lineNumber;
        private final Set<RawAccessRecord> accessesInTryBlock = new HashSet<RawAccessRecord>();

        private RawTryCatchBlock() {
        }

        void addThrowable(JavaClassDescriptor throwableType) {
            this.caughtThrowables.add(throwableType);
        }

        void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        void addAccess(RawAccessRecord accessRecord) {
            this.accessesInTryBlock.add(accessRecord);
        }
    }
}

