/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.core.InitialConfiguration;
import com.tngtech.archunit.core.importer.ClassFileSource;
import com.tngtech.archunit.core.importer.ImportOptions;
import com.tngtech.archunit.core.importer.ImportPlugin;
import com.tngtech.archunit.core.importer.NormalizedResourceName;
import com.tngtech.archunit.core.importer.NormalizedUri;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.cache.Cache;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public abstract class Location {
    private static final InitialConfiguration<Set<Factory>> factories = new InitialConfiguration();
    private static final Cache<NormalizedUri, Collection<NormalizedResourceName>> ENTRY_CACHE;
    final NormalizedUri uri;

    Location(NormalizedUri uri) {
        this.uri = Preconditions.checkNotNull(uri);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public URI asURI() {
        return this.uri.toURI();
    }

    abstract ClassFileSource asClassFileSource(ImportOptions var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean contains(String part) {
        return this.uri.toString().contains(part);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean matches(Pattern pattern) {
        return pattern.matcher(this.uri.toString()).matches();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract boolean isJar();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract boolean isArchive();

    Location append(String relativeURI) {
        relativeURI = this.encodeIllegalCharacters(relativeURI);
        if (this.uri.toString().endsWith("/") && relativeURI.startsWith("/")) {
            relativeURI = relativeURI.substring(1);
        }
        if (!this.uri.toString().endsWith("/") && !relativeURI.startsWith("/")) {
            relativeURI = "/" + relativeURI;
        }
        return Location.of(URI.create(this.uri + relativeURI));
    }

    private String encodeIllegalCharacters(String relativeURI) {
        try {
            return new URI(null, null, relativeURI, null).toString();
        }
        catch (URISyntaxException e) {
            throw new ArchUnitException.LocationException(e);
        }
    }

    void checkScheme(String scheme, NormalizedUri uri) {
        String actualScheme = uri.getScheme();
        Preconditions.checkArgument(scheme.equals(actualScheme), "URI %s of Location must have scheme %s, but has %s", (Object)uri, (Object)scheme, (Object)actualScheme);
    }

    final Stream<NormalizedResourceName> streamEntries() {
        try {
            return ENTRY_CACHE.get(this.uri, this::readResourceEntries).stream();
        }
        catch (ExecutionException e) {
            throw new ArchUnitException.LocationException(e);
        }
    }

    abstract Collection<NormalizedResourceName> readResourceEntries();

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.uri, other.uri);
    }

    public String toString() {
        return "Location{uri=" + this.uri + '}';
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Location of(URL url) {
        return Location.of(Location.toURI(url));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Location of(URI uri) {
        uri = JarFileLocation.ensureJarProtocol(uri);
        for (Factory factory : factories.get()) {
            if (!factory.supports(uri.getScheme())) continue;
            return factory.create(uri);
        }
        throw new ArchUnitException.UnsupportedUriSchemeException(uri);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Location of(JarFile jar) {
        return JarFileLocation.from(jar);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Location of(Path path) {
        return FilePathLocation.from(path.toUri());
    }

    static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ArchUnitException.LocationException(e);
        }
    }

    static {
        ImportPlugin.Loader.loadForCurrentPlatform().plugInLocationFactories(factories);
        ENTRY_CACHE = CacheBuilder.newBuilder().build();
    }

    private static class JarFileLocation
    extends Location {
        private static final String SCHEME = "jar";

        private JarFileLocation(NormalizedUri uri) {
            super(uri);
            this.checkScheme(SCHEME, uri);
        }

        static URI ensureJarProtocol(URI uri) {
            return !SCHEME.equals(uri.getScheme()) && uri.getPath().endsWith(".jar") ? JarFileLocation.newJarUri(uri) : uri;
        }

        static JarFileLocation from(URI uri) {
            Preconditions.checkArgument(uri.toString().contains("!/"), "JAR URI must contain '!/'");
            return new JarFileLocation(NormalizedUri.from(uri));
        }

        static JarFileLocation from(JarFile jar) {
            return JarFileLocation.from(JarFileLocation.newJarUri(FilePathLocation.newFileUri(jar.getName())));
        }

        private static URI newJarUri(URI uri) {
            return URI.create(String.format("%s:%s!/", SCHEME, uri));
        }

        @Override
        ClassFileSource asClassFileSource(ImportOptions importOptions) {
            try {
                String[] parts = this.uri.toString().split("!/", 2);
                return new ClassFileSource.FromJar(new URL(parts[0] + "!/"), parts[1], importOptions);
            }
            catch (IOException e) {
                throw new ArchUnitException.LocationException(e);
            }
        }

        @Override
        public boolean isJar() {
            return true;
        }

        @Override
        public boolean isArchive() {
            return true;
        }

        @Override
        Collection<NormalizedResourceName> readResourceEntries() {
            File file = this.getFileOfJar();
            if (!file.exists()) {
                return Collections.emptySet();
            }
            return this.readJarFileContent(file);
        }

        private File getFileOfJar() {
            return new File(URI.create(this.uri.toString().replaceAll("^jar:", "").replaceAll("!/.*", "")));
        }

        private Collection<NormalizedResourceName> readJarFileContent(File fileOfJar) {
            ImmutableList.Builder result = ImmutableList.builder();
            String prefix = this.uri.toString().replaceAll(".*!/", "");
            try (JarFile jarFile = new JarFile(fileOfJar);){
                result.addAll(this.readEntries(prefix, jarFile));
            }
            catch (IOException e) {
                throw new ArchUnitException.LocationException(e);
            }
            return result.build();
        }

        private List<NormalizedResourceName> readEntries(String prefix, JarFile jarFile) {
            ArrayList<NormalizedResourceName> result = new ArrayList<NormalizedResourceName>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(prefix) || !entry.getName().endsWith(".class")) continue;
                result.add(NormalizedResourceName.from(entry.getName()));
            }
            return result;
        }
    }

    static interface Factory {
        public boolean supports(String var1);

        public Location create(URI var1);
    }

    private static class FilePathLocation
    extends Location {
        private static final String SCHEME = "file";

        private FilePathLocation(NormalizedUri uri) {
            super(uri);
            this.checkScheme(SCHEME, uri);
        }

        static URI newFileUri(String fileName) {
            return new File(fileName).toURI();
        }

        static FilePathLocation from(URI uri) {
            return new FilePathLocation(NormalizedUri.from(uri));
        }

        @Override
        ClassFileSource asClassFileSource(ImportOptions importOptions) {
            return new ClassFileSource.FromFilePath(Paths.get(this.uri.toURI()), importOptions);
        }

        @Override
        public boolean isJar() {
            return false;
        }

        @Override
        public boolean isArchive() {
            return false;
        }

        @Override
        Collection<NormalizedResourceName> readResourceEntries() {
            try {
                return this.getAllFilesBeneath(this.uri);
            }
            catch (IOException e) {
                throw new ArchUnitException.LocationException(e);
            }
        }

        private List<NormalizedResourceName> getAllFilesBeneath(NormalizedUri uri) throws IOException {
            File rootFile = new File(uri.toURI());
            if (!rootFile.exists()) {
                return Collections.emptyList();
            }
            return this.getAllFilesBeneath(rootFile.toPath());
        }

        private List<NormalizedResourceName> getAllFilesBeneath(final Path root) throws IOException {
            final ImmutableList.Builder result = ImmutableList.builder();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.toString().endsWith(".class")) {
                        result.add(NormalizedResourceName.from(root.relativize(file).toString()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return result.build();
        }
    }

    static class FilePathLocationFactory
    implements Factory {
        FilePathLocationFactory() {
        }

        @Override
        public boolean supports(String scheme) {
            return "file".equals(scheme);
        }

        @Override
        public Location create(URI uri) {
            return FilePathLocation.from(uri);
        }
    }

    static class JarFileLocationFactory
    implements Factory {
        JarFileLocationFactory() {
        }

        @Override
        public boolean supports(String scheme) {
            return "jar".equals(scheme);
        }

        @Override
        public Location create(URI uri) {
            return JarFileLocation.from(uri);
        }
    }
}

