/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaConstructorReference;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaMethodReference;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.importer.AccessRecord;
import com.tngtech.archunit.core.importer.ClassFileImportRecord;
import com.tngtech.archunit.core.importer.DependencyResolutionProcess;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

class ClassGraphCreator
implements ImportContext {
    private final ImportedClasses classes;
    private final ClassFileImportRecord importRecord;
    private final DependencyResolutionProcess dependencyResolutionProcess;
    private final SetMultimap<JavaCodeUnit, AccessRecord.FieldAccessRecord> processedFieldAccessRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.MethodCallTarget>> processedMethodCallRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.ConstructorCallTarget>> processedConstructorCallRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.MethodReferenceTarget>> processedMethodReferenceRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.ConstructorReferenceTarget>> processedConstructorReferenceRecords = HashMultimap.create();

    ClassGraphCreator(ClassFileImportRecord importRecord, DependencyResolutionProcess dependencyResolutionProcess, ClassResolver classResolver) {
        this.importRecord = importRecord;
        this.dependencyResolutionProcess = dependencyResolutionProcess;
        this.classes = new ImportedClasses(importRecord.getClasses(), classResolver, this::getMethodReturnType);
    }

    JavaClasses complete() {
        this.dependencyResolutionProcess.resolve(this.classes);
        this.completeClasses();
        this.completeAccesses();
        return DomainObjectCreationContext.createJavaClasses(this.classes.getDirectlyImported(), this.classes.getAllWithOuterClassesSortedBeforeInnerClasses(), this);
    }

    private void completeClasses() {
        for (JavaClass javaClass : this.classes.getAllWithOuterClassesSortedBeforeInnerClasses()) {
            DomainObjectCreationContext.completeClassHierarchy(javaClass, this);
            DomainObjectCreationContext.completeEnclosingDeclaration(javaClass, this);
            DomainObjectCreationContext.completeTypeParameters(javaClass, this);
            DomainObjectCreationContext.completeGenericSuperclass(javaClass, this);
            DomainObjectCreationContext.completeGenericInterfaces(javaClass, this);
            DomainObjectCreationContext.completeMembers(javaClass, this);
            DomainObjectCreationContext.completeAnnotations(javaClass, this);
        }
    }

    private void completeAccesses() {
        this.importRecord.forEachRawFieldAccessRecord(record -> this.tryProcess((RawAccessRecord)record, (AccessRecord.Factory)AccessRecord.Factory.forFieldAccessRecord(), (Multimap)this.processedFieldAccessRecords));
        this.importRecord.forEachRawMethodCallRecord(record -> this.tryProcess((RawAccessRecord)record, (AccessRecord.Factory)AccessRecord.Factory.forMethodCallRecord(), (Multimap)this.processedMethodCallRecords));
        this.importRecord.forEachRawConstructorCallRecord(record -> this.tryProcess((RawAccessRecord)record, (AccessRecord.Factory)AccessRecord.Factory.forConstructorCallRecord(), (Multimap)this.processedConstructorCallRecords));
        this.importRecord.forEachRawMethodReferenceRecord(record -> this.tryProcess((RawAccessRecord)record, (AccessRecord.Factory)AccessRecord.Factory.forMethodReferenceRecord(), (Multimap)this.processedMethodReferenceRecords));
        this.importRecord.forEachRawConstructorReferenceRecord(record -> this.tryProcess((RawAccessRecord)record, (AccessRecord.Factory)AccessRecord.Factory.forConstructorReferenceRecord(), (Multimap)this.processedConstructorReferenceRecords));
    }

    private <T extends AccessRecord<?>, B extends RawAccessRecord> void tryProcess(B rawRecord, AccessRecord.Factory<B, T> factory, Multimap<JavaCodeUnit, T> processedAccessRecords) {
        AccessRecord processed = (AccessRecord)factory.create(rawRecord, this.classes);
        processedAccessRecords.put(processed.getOrigin(), processed);
    }

    @Override
    public Set<JavaFieldAccess> createFieldAccessesFor(JavaCodeUnit codeUnit, Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlockBuilders) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord.FieldAccessRecord record : this.processedFieldAccessRecords.get((Object)codeUnit)) {
            JavaFieldAccess access = this.accessBuilderFrom(new DomainBuilders.JavaFieldAccessBuilder(), record).withAccessType(record.getAccessType()).build();
            result.add(access);
            this.handlePossibleTryBlockAccess(tryCatchBlockBuilders, record, access);
        }
        return result.build();
    }

    @Override
    public Set<JavaMethodCall> createMethodCallsFor(JavaCodeUnit codeUnit, Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlockBuilders) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord record : this.processedMethodCallRecords.get((Object)codeUnit)) {
            JavaMethodCall call = this.accessBuilderFrom(new DomainBuilders.JavaMethodCallBuilder(), record).build();
            result.add(call);
            this.handlePossibleTryBlockAccess(tryCatchBlockBuilders, record, call);
        }
        return result.build();
    }

    @Override
    public Set<JavaConstructorCall> createConstructorCallsFor(JavaCodeUnit codeUnit, Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlockBuilders) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord record : this.processedConstructorCallRecords.get((Object)codeUnit)) {
            JavaConstructorCall call = this.accessBuilderFrom(new DomainBuilders.JavaConstructorCallBuilder(), record).build();
            result.add(call);
            this.handlePossibleTryBlockAccess(tryCatchBlockBuilders, record, call);
        }
        return result.build();
    }

    @Override
    public Set<JavaMethodReference> createMethodReferencesFor(JavaCodeUnit codeUnit, Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlockBuilders) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord record : this.processedMethodReferenceRecords.get((Object)codeUnit)) {
            JavaMethodReference methodReference = this.accessBuilderFrom(new DomainBuilders.JavaMethodReferenceBuilder(), record).build();
            result.add(methodReference);
            this.handlePossibleTryBlockAccess(tryCatchBlockBuilders, record, methodReference);
        }
        return result.build();
    }

    @Override
    public Set<JavaConstructorReference> createConstructorReferencesFor(JavaCodeUnit codeUnit, Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlockBuilders) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord record : this.processedConstructorReferenceRecords.get((Object)codeUnit)) {
            JavaConstructorReference constructorReference = this.accessBuilderFrom(new DomainBuilders.JavaConstructorReferenceBuilder(), record).build();
            result.add(constructorReference);
            this.handlePossibleTryBlockAccess(tryCatchBlockBuilders, record, constructorReference);
        }
        return result.build();
    }

    private void handlePossibleTryBlockAccess(Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlockBuilders, AccessRecord<?> record, JavaAccess<?> access) {
        tryCatchBlockBuilders.forEach(builder -> builder.addIfContainedInTryBlock(record.getRaw(), access));
    }

    private <T extends AccessTarget, B extends DomainBuilders.JavaAccessBuilder<T, B>> B accessBuilderFrom(B builder, AccessRecord<T> record) {
        return ((DomainBuilders.JavaAccessBuilder)((DomainBuilders.JavaAccessBuilder)((DomainBuilders.JavaAccessBuilder)builder.withOrigin(record.getOrigin())).withTarget(record.getTarget())).withLineNumber(record.getLineNumber())).withDeclaredInLambda(record.isDeclaredInLambda());
    }

    @Override
    public Optional<JavaClass> createSuperclass(JavaClass owner) {
        Optional<String> superclassName = this.importRecord.getSuperclassFor(owner.getName());
        return superclassName.map(this.classes::getOrResolve);
    }

    @Override
    public Optional<JavaType> createGenericSuperclass(JavaClass owner) {
        Optional<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericSuperclassBuilder = this.importRecord.getGenericSuperclassFor(owner);
        return genericSuperclassBuilder.map(javaClassJavaParameterizedTypeBuilder -> javaClassJavaParameterizedTypeBuilder.build(owner, ClassGraphCreator.getTypeParametersInContextOf(owner), this.classes));
    }

    @Override
    public Optional<List<JavaType>> createGenericInterfaces(JavaClass owner) {
        Optional<List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> genericInterfaceBuilders = this.importRecord.getGenericInterfacesFor(owner);
        if (!genericInterfaceBuilders.isPresent()) {
            return Optional.empty();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> builder : genericInterfaceBuilders.get()) {
            result.add(builder.build(owner, ClassGraphCreator.getTypeParametersInContextOf(owner), this.classes));
        }
        return Optional.of(result.build());
    }

    private static Iterable<JavaTypeVariable<?>> getTypeParametersInContextOf(JavaClass javaClass) {
        HashSet<JavaTypeVariable<?>> result = Sets.newHashSet(javaClass.getTypeParameters());
        while (javaClass.getEnclosingClass().isPresent()) {
            javaClass = javaClass.getEnclosingClass().get();
            result.addAll(javaClass.getTypeParameters());
        }
        return result;
    }

    @Override
    public List<JavaClass> createInterfaces(JavaClass owner) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String interfaceName : this.importRecord.getInterfaceNamesFor(owner.getName())) {
            result.add(this.classes.getOrResolve(interfaceName));
        }
        return result.build();
    }

    @Override
    public List<JavaTypeVariable<JavaClass>> createTypeParameters(JavaClass owner) {
        DomainBuilders.JavaClassTypeParametersBuilder typeParametersBuilder = this.importRecord.getTypeParameterBuildersFor(owner.getName());
        return typeParametersBuilder.build(owner, this.classes);
    }

    @Override
    public Set<JavaField> createFields(JavaClass owner) {
        return DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(this.importRecord.getFieldBuildersFor(owner.getName()), owner, this.classes);
    }

    @Override
    public Set<JavaMethod> createMethods(JavaClass owner) {
        Stream<DomainBuilders.JavaMethodBuilder> methodBuilders = this.getNonSyntheticMethodBuildersFor(owner);
        if (owner.isAnnotation()) {
            methodBuilders = methodBuilders.map(methodBuilder -> methodBuilder.withAnnotationDefaultValue(method -> this.importRecord.getAnnotationDefaultValueBuilderFor((JavaMethod)method).flatMap(builder -> builder.build(method, this.classes))));
        }
        return DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(methodBuilders, owner, this.classes);
    }

    private Stream<DomainBuilders.JavaMethodBuilder> getNonSyntheticMethodBuildersFor(JavaClass owner) {
        return this.importRecord.getMethodBuildersFor(owner.getName()).stream().filter(methodBuilder -> !JavaClassDescriptorImporter.isLambdaMethodName(methodBuilder.getName()) && !JavaClassDescriptorImporter.isSyntheticAccessMethodName(methodBuilder.getName()));
    }

    @Override
    public Set<JavaConstructor> createConstructors(JavaClass owner) {
        return DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(this.importRecord.getConstructorBuildersFor(owner.getName()), owner, this.classes);
    }

    @Override
    public Optional<JavaStaticInitializer> createStaticInitializer(JavaClass owner) {
        Optional<DomainBuilders.JavaStaticInitializerBuilder> builder = this.importRecord.getStaticInitializerBuilderFor(owner.getName());
        if (!builder.isPresent()) {
            return Optional.empty();
        }
        JavaStaticInitializer staticInitializer = (JavaStaticInitializer)builder.get().build(owner, this.classes);
        return Optional.of(staticInitializer);
    }

    @Override
    public Map<String, JavaAnnotation<JavaClass>> createAnnotations(JavaClass owner) {
        return this.createAnnotations(owner, this.importRecord.getAnnotationsFor(owner));
    }

    @Override
    public Map<String, JavaAnnotation<JavaMember>> createAnnotations(JavaMember owner) {
        return this.createAnnotations(owner, this.importRecord.getAnnotationsFor(owner));
    }

    private <OWNER extends HasDescription> Map<String, JavaAnnotation<OWNER>> createAnnotations(OWNER owner, Set<DomainBuilders.JavaAnnotationBuilder> annotationBuilders) {
        return DomainBuilders.buildAnnotations(owner, annotationBuilders, this.classes);
    }

    @Override
    public Optional<JavaClass> createEnclosingClass(JavaClass owner) {
        Optional<String> enclosingClassName = this.importRecord.getEnclosingClassFor(owner.getName());
        return enclosingClassName.map(this.classes::getOrResolve);
    }

    @Override
    public Optional<JavaCodeUnit> createEnclosingCodeUnit(JavaClass owner) {
        Optional<RawAccessRecord.CodeUnit> enclosingCodeUnit = this.importRecord.getEnclosingCodeUnitFor(owner.getName());
        if (!enclosingCodeUnit.isPresent()) {
            return Optional.empty();
        }
        RawAccessRecord.CodeUnit codeUnit = enclosingCodeUnit.get();
        JavaClass enclosingClass = this.classes.getOrResolve(codeUnit.getDeclaringClassName());
        return enclosingClass.tryGetCodeUnitWithParameterTypeNames(codeUnit.getName(), codeUnit.getRawParameterTypeNames());
    }

    @Override
    public Set<DomainBuilders.TryCatchBlockBuilder> createTryCatchBlockBuilders(JavaCodeUnit codeUnit) {
        return this.importRecord.getTryCatchBlockBuildersFor(codeUnit);
    }

    @Override
    public JavaClass resolveClass(String fullyQualifiedClassName) {
        return this.classes.getOrResolve(fullyQualifiedClassName);
    }

    private Optional<JavaClass> getMethodReturnType(String declaringClassName, String methodName) {
        for (DomainBuilders.JavaMethodBuilder methodBuilder : this.importRecord.getMethodBuildersFor(declaringClassName)) {
            if (!methodBuilder.getName().equals(methodName) || !methodBuilder.hasNoParameters()) continue;
            return Optional.of(this.classes.getOrResolve(methodBuilder.getReturnTypeName()));
        }
        return Optional.empty();
    }
}

