/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.importer.ClassFileImportRecord;
import com.tngtech.archunit.core.importer.ClassFileLocation;
import com.tngtech.archunit.core.importer.ClassFileSource;
import com.tngtech.archunit.core.importer.ClassGraphCreator;
import com.tngtech.archunit.core.importer.DeclarationHandler;
import com.tngtech.archunit.core.importer.DependencyResolutionProcess;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.JavaClassProcessor;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.core.importer.SourceDescriptor;
import com.tngtech.archunit.core.importer.TryCatchRecorder;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.ClassReader;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Label;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassFileProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ClassFileProcessor.class);
    static final int ASM_API_VERSION = 589824;
    private final boolean md5InClassSourcesEnabled = ArchConfiguration.get().md5InClassSourcesEnabled();
    private final ClassResolver.Factory classResolverFactory = new ClassResolver.Factory();

    ClassFileProcessor() {
    }

    JavaClasses process(ClassFileSource source) {
        ClassFileImportRecord importRecord = new ClassFileImportRecord();
        DependencyResolutionProcess dependencyResolutionProcess = new DependencyResolutionProcess();
        RecordAccessHandler accessHandler = new RecordAccessHandler(importRecord, dependencyResolutionProcess);
        ClassDetailsRecorder classDetailsRecorder = new ClassDetailsRecorder(importRecord, dependencyResolutionProcess);
        for (ClassFileLocation location : source) {
            try {
                InputStream s = location.openStream();
                try {
                    JavaClassProcessor javaClassProcessor = new JavaClassProcessor(new SourceDescriptor(location.getUri(), this.md5InClassSourcesEnabled), classDetailsRecorder, accessHandler);
                    new ClassReader(s).accept(javaClassProcessor, 0);
                    javaClassProcessor.createJavaClass().ifPresent(importRecord::add);
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (Exception e) {
                LOG.warn(String.format("Couldn't import class from %s", location.getUri()), (Throwable)e);
            }
        }
        return new ClassGraphCreator(importRecord, dependencyResolutionProcess, this.getClassResolver(classDetailsRecorder)).complete();
    }

    private ClassResolver getClassResolver(ClassDetailsRecorder classDetailsRecorder) {
        ClassResolver classResolver = this.classResolverFactory.create();
        classResolver.setClassUriImporter(new UriImporterOfProcessor(classDetailsRecorder, this.md5InClassSourcesEnabled));
        return classResolver;
    }

    private static class RecordAccessHandler
    implements JavaClassProcessor.AccessHandler,
    TryCatchRecorder.TryCatchBlocksFinishedListener {
        private static final Logger LOG = LoggerFactory.getLogger(RecordAccessHandler.class);
        private final ClassFileImportRecord importRecord;
        private final DependencyResolutionProcess dependencyResolutionProcess;
        private RawAccessRecord.CodeUnit codeUnit;
        private int lineNumber;
        private final TryCatchRecorder tryCatchRecorder = new TryCatchRecorder(this);

        private RecordAccessHandler(ClassFileImportRecord importRecord, DependencyResolutionProcess dependencyResolutionProcess) {
            this.importRecord = importRecord;
            this.dependencyResolutionProcess = dependencyResolutionProcess;
        }

        @Override
        public void setContext(RawAccessRecord.CodeUnit codeUnit) {
            this.codeUnit = codeUnit;
        }

        @Override
        public void onLineNumber(int lineNumber, Label label) {
            this.lineNumber = lineNumber;
            this.tryCatchRecorder.onEncounteredLabel(label, lineNumber);
        }

        @Override
        public void onLabel(Label label) {
            this.tryCatchRecorder.onEncounteredLabel(label);
        }

        @Override
        public void handleFieldInstruction(int opcode, String owner, String name, String desc) {
            JavaFieldAccess.AccessType accessType = JavaFieldAccess.AccessType.forOpCode(opcode);
            LOG.trace("Found {} access to field {}.{}:{} in line {}", new Object[]{accessType, owner, name, desc, this.lineNumber});
            RawAccessRecord.TargetInfo target = new RawAccessRecord.TargetInfo(owner, name, desc);
            RawAccessRecord.ForField accessRecord = this.filled(new RawAccessRecord.ForField.Builder(), target).withAccessType(accessType).build();
            this.importRecord.registerFieldAccess(accessRecord);
            this.tryCatchRecorder.registerAccess(accessRecord);
            this.dependencyResolutionProcess.registerAccessToType(target.owner.getFullyQualifiedClassName());
        }

        @Override
        public void handleMethodInstruction(String owner, String name, String desc) {
            LOG.trace("Found call of method {}.{}:{} in line {}", new Object[]{owner, name, desc, this.lineNumber});
            RawAccessRecord.TargetInfo target = new RawAccessRecord.TargetInfo(owner, name, desc);
            RawAccessRecord accessRecord = this.filled(new RawAccessRecord.Builder(), target).build();
            if ("<init>".equals(name)) {
                this.importRecord.registerConstructorCall(accessRecord);
            } else {
                this.importRecord.registerMethodCall(accessRecord);
            }
            this.tryCatchRecorder.registerAccess(accessRecord);
            this.dependencyResolutionProcess.registerAccessToType(target.owner.getFullyQualifiedClassName());
        }

        @Override
        public void handleMethodReferenceInstruction(String owner, String name, String desc) {
            LOG.trace("Found method reference {}.{}:{} in line {}", new Object[]{owner, name, desc, this.lineNumber});
            RawAccessRecord.TargetInfo target = new RawAccessRecord.TargetInfo(owner, name, desc);
            RawAccessRecord accessRecord = this.filled(new RawAccessRecord.Builder(), target).build();
            if ("<init>".equals(name)) {
                this.importRecord.registerConstructorReference(accessRecord);
            } else {
                this.importRecord.registerMethodReference(accessRecord);
            }
            this.tryCatchRecorder.registerAccess(accessRecord);
            this.dependencyResolutionProcess.registerAccessToType(target.owner.getFullyQualifiedClassName());
        }

        @Override
        public void handleLambdaInstruction(String owner, String name, String desc) {
            RawAccessRecord.TargetInfo target = new RawAccessRecord.TargetInfo(owner, name, desc);
            this.importRecord.registerLambdaInvocation(this.filled(new RawAccessRecord.Builder(), target).build());
        }

        @Override
        public void handleTryCatchBlock(Label start, Label end, Label handler, JavaClassDescriptor throwableType) {
            LOG.trace("Found try/catch block between {} and {} for throwable {}", new Object[]{start, end, throwableType});
            this.tryCatchRecorder.registerTryCatchBlock(start, end, handler, throwableType);
        }

        @Override
        public void handleTryFinallyBlock(Label start, Label end, Label handler) {
            LOG.trace("Found try/finally block between {} and {}", (Object)start, (Object)end);
            this.tryCatchRecorder.registerTryFinallyBlock(start, end, handler);
        }

        @Override
        public void onMethodEnd() {
            this.tryCatchRecorder.onEncounteredMethodEnd();
        }

        @Override
        public void onTryCatchBlocksFinished(Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlocks) {
            this.importRecord.addTryCatchBlocks(this.codeUnit.getDeclaringClassName(), this.codeUnit.getName(), this.codeUnit.getDescriptor(), tryCatchBlocks);
        }

        private <BUILDER extends RawAccessRecord.BaseBuilder<?, BUILDER>> BUILDER filled(BUILDER builder, RawAccessRecord.TargetInfo target) {
            return ((RawAccessRecord.BaseBuilder)((RawAccessRecord.BaseBuilder)builder.withCaller(this.codeUnit)).withTarget(target)).withLineNumber(this.lineNumber);
        }
    }

    private static class ClassDetailsRecorder
    implements DeclarationHandler {
        private final ClassFileImportRecord importRecord;
        private final DependencyResolutionProcess dependencyResolutionProcess;
        private String ownerName;

        private ClassDetailsRecorder(ClassFileImportRecord importRecord, DependencyResolutionProcess dependencyResolutionProcess) {
            this.importRecord = importRecord;
            this.dependencyResolutionProcess = dependencyResolutionProcess;
        }

        @Override
        public boolean isNew(String className) {
            return !this.importRecord.getClasses().containsKey(className);
        }

        @Override
        public void onNewClass(String className, Optional<String> superclassName, List<String> interfaceNames) {
            this.ownerName = className;
            if (superclassName.isPresent()) {
                this.importRecord.setSuperclass(this.ownerName, superclassName.get());
                this.dependencyResolutionProcess.registerSupertype(superclassName.get());
            }
            this.importRecord.addInterfaces(this.ownerName, interfaceNames);
            this.dependencyResolutionProcess.registerSupertypes(interfaceNames);
        }

        @Override
        public void onDeclaredTypeParameters(DomainBuilders.JavaClassTypeParametersBuilder typeParametersBuilder) {
            this.importRecord.addTypeParameters(this.ownerName, typeParametersBuilder);
        }

        @Override
        public void onGenericSuperclass(DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> genericSuperclassBuilder) {
            this.importRecord.addGenericSuperclass(this.ownerName, genericSuperclassBuilder);
        }

        @Override
        public void onGenericInterfaces(List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericInterfaceBuilders) {
            this.importRecord.addGenericInterfaces(this.ownerName, genericInterfaceBuilders);
        }

        @Override
        public void onDeclaredField(DomainBuilders.JavaFieldBuilder fieldBuilder, String fieldTypeName) {
            this.importRecord.addField(this.ownerName, fieldBuilder);
            this.dependencyResolutionProcess.registerMemberType(fieldTypeName);
        }

        @Override
        public void onDeclaredConstructor(DomainBuilders.JavaConstructorBuilder constructorBuilder, Collection<String> rawParameterTypeNames) {
            this.importRecord.addConstructor(this.ownerName, constructorBuilder);
            this.dependencyResolutionProcess.registerMemberTypes(rawParameterTypeNames);
        }

        @Override
        public void onDeclaredMethod(DomainBuilders.JavaMethodBuilder methodBuilder, Collection<String> rawParameterTypeNames, String rawReturnTypeName) {
            this.importRecord.addMethod(this.ownerName, methodBuilder);
            this.dependencyResolutionProcess.registerMemberTypes(rawParameterTypeNames);
            this.dependencyResolutionProcess.registerMemberType(rawReturnTypeName);
        }

        @Override
        public void onDeclaredStaticInitializer(DomainBuilders.JavaStaticInitializerBuilder staticInitializerBuilder) {
            this.importRecord.setStaticInitializer(this.ownerName, staticInitializerBuilder);
        }

        @Override
        public void onDeclaredClassAnnotations(Set<DomainBuilders.JavaAnnotationBuilder> annotationBuilders) {
            this.importRecord.addClassAnnotations(this.ownerName, annotationBuilders);
            this.registerAnnotationTypesToResolve(annotationBuilders);
        }

        @Override
        public void onDeclaredMemberAnnotations(String memberName, String descriptor, Set<DomainBuilders.JavaAnnotationBuilder> annotationBuilders) {
            this.importRecord.addMemberAnnotations(this.ownerName, memberName, descriptor, annotationBuilders);
            this.registerAnnotationTypesToResolve(annotationBuilders);
        }

        private void registerAnnotationTypesToResolve(Set<DomainBuilders.JavaAnnotationBuilder> annotationBuilders) {
            for (DomainBuilders.JavaAnnotationBuilder annotationBuilder : annotationBuilders) {
                this.dependencyResolutionProcess.registerAnnotationType(annotationBuilder.getFullyQualifiedClassName());
            }
        }

        @Override
        public void onDeclaredAnnotationValueType(String valueTypeName) {
            this.dependencyResolutionProcess.registerAnnotationType(valueTypeName);
        }

        @Override
        public void onDeclaredAnnotationDefaultValue(String methodName, String methodDescriptor, DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
            this.importRecord.addAnnotationDefaultValue(this.ownerName, methodName, methodDescriptor, valueBuilder);
        }

        @Override
        public void registerEnclosingClass(String ownerName, String enclosingClassName) {
            this.importRecord.setEnclosingClass(ownerName, enclosingClassName);
            this.dependencyResolutionProcess.registerEnclosingType(enclosingClassName);
        }

        @Override
        public void registerEnclosingCodeUnit(String ownerName, RawAccessRecord.CodeUnit enclosingCodeUnit) {
            this.importRecord.setEnclosingCodeUnit(ownerName, enclosingCodeUnit);
        }

        @Override
        public void onDeclaredClassObject(String typeName) {
            this.dependencyResolutionProcess.registerAccessToType(typeName);
        }

        @Override
        public void onDeclaredInstanceofCheck(String typeName) {
            this.dependencyResolutionProcess.registerAccessToType(typeName);
        }

        @Override
        public void onDeclaredThrowsClause(Collection<String> exceptionTypeNames) {
            this.dependencyResolutionProcess.registerMemberTypes(exceptionTypeNames);
        }

        @Override
        public void onDeclaredGenericSignatureType(String typeName) {
            this.dependencyResolutionProcess.registerGenericSignatureType(typeName);
        }
    }

    private static class UriImporterOfProcessor
    implements ClassResolver.ClassUriImporter {
        private final DeclarationHandler declarationHandler;
        private final boolean md5InClassSourcesEnabled;

        UriImporterOfProcessor(DeclarationHandler declarationHandler, boolean md5InClassSourcesEnabled) {
            this.declarationHandler = declarationHandler;
            this.md5InClassSourcesEnabled = md5InClassSourcesEnabled;
        }

        @Override
        public Optional<JavaClass> tryImport(URI uri) {
            Optional<JavaClass> optional;
            block8: {
                InputStream inputStream = uri.toURL().openStream();
                try {
                    JavaClassProcessor classProcessor = new JavaClassProcessor(new SourceDescriptor(uri, this.md5InClassSourcesEnabled), this.declarationHandler);
                    new ClassReader(inputStream).accept(classProcessor, 0);
                    optional = classProcessor.createJavaClass();
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Error during import from %s, falling back to simple import", uri), (Throwable)e);
                        return Optional.empty();
                    }
                }
                inputStream.close();
            }
            return optional;
        }
    }
}

