/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ArrayListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassFileImportRecord {
    private static final Logger log = LoggerFactory.getLogger(ClassFileImportRecord.class);
    private static final DomainBuilders.JavaClassTypeParametersBuilder NO_TYPE_PARAMETERS = new DomainBuilders.JavaClassTypeParametersBuilder(Collections.emptyList());
    private final Map<String, JavaClass> classes = new HashMap<String, JavaClass>();
    private final Map<String, String> superclassNamesByOwner = new HashMap<String, String>();
    private final ListMultimap<String, String> interfaceNamesByOwner = ArrayListMultimap.create();
    private final Map<String, DomainBuilders.JavaClassTypeParametersBuilder> typeParametersBuilderByOwner = new HashMap<String, DomainBuilders.JavaClassTypeParametersBuilder>();
    private final Map<String, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericSuperclassBuilderByOwner = new HashMap<String, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>();
    private final Map<String, List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> genericInterfaceBuildersByOwner = new HashMap<String, List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>>();
    private final SetMultimap<String, DomainBuilders.JavaFieldBuilder> fieldBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaMethodBuilder> methodBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaConstructorBuilder> constructorBuildersByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaStaticInitializerBuilder> staticInitializerBuildersByOwner = new HashMap<String, DomainBuilders.JavaStaticInitializerBuilder>();
    private final SetMultimap<String, DomainBuilders.JavaAnnotationBuilder> annotationsByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaAnnotationBuilder.ValueBuilder> annotationDefaultValuesByOwner = new HashMap<String, DomainBuilders.JavaAnnotationBuilder.ValueBuilder>();
    private final EnclosingDeclarationsByInnerClasses enclosingDeclarationsByOwner = new EnclosingDeclarationsByInnerClasses();
    private final SetMultimap<String, DomainBuilders.TryCatchBlockBuilder> tryCatchBlocksByOwner = HashMultimap.create();
    private final Set<RawAccessRecord.ForField> rawFieldAccessRecords = new HashSet<RawAccessRecord.ForField>();
    private final Set<RawAccessRecord> rawMethodCallRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawConstructorCallRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawMethodReferenceRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawConstructorReferenceRecords = new HashSet<RawAccessRecord>();
    private final SyntheticAccessRecorder syntheticLambdaAccessRecorder = ClassFileImportRecord.createSyntheticLambdaAccessRecorder();
    private final SyntheticAccessRecorder syntheticPrivateAccessRecorder = ClassFileImportRecord.createSyntheticPrivateAccessRecorder();
    private static final Function<RawAccessRecord, RawAccessRecord.Builder> COPY_RAW_ACCESS_RECORD = access -> (RawAccessRecord.Builder)((RawAccessRecord.Builder)((RawAccessRecord.Builder)((RawAccessRecord.Builder)new RawAccessRecord.Builder().withCaller(access.caller)).withTarget(access.target)).withLineNumber(access.lineNumber)).withDeclaredInLambda(access.declaredInLambda);
    private static final Function<RawAccessRecord.ForField, RawAccessRecord.ForField.Builder> COPY_RAW_FIELD_ACCESS_RECORD = access -> (RawAccessRecord.ForField.Builder)((RawAccessRecord.ForField.Builder)((RawAccessRecord.ForField.Builder)((RawAccessRecord.ForField.Builder)new RawAccessRecord.ForField.Builder().withCaller(access.caller)).withAccessType(access.accessType).withTarget(access.target)).withLineNumber(access.lineNumber)).withDeclaredInLambda(access.declaredInLambda);

    ClassFileImportRecord() {
    }

    void setSuperclass(String ownerName, String superclassName) {
        Preconditions.checkState(!this.superclassNamesByOwner.containsKey(ownerName), "Attempted to add %s as a second superclass to %s, this is most likely a bug", (Object)superclassName, (Object)ownerName);
        this.superclassNamesByOwner.put(ownerName, superclassName);
    }

    void addInterfaces(String ownerName, List<String> interfaceNames) {
        this.interfaceNamesByOwner.putAll(ownerName, interfaceNames);
    }

    void addTypeParameters(String ownerName, DomainBuilders.JavaClassTypeParametersBuilder builder) {
        this.typeParametersBuilderByOwner.put(ownerName, builder);
    }

    void addGenericSuperclass(String ownerName, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> genericSuperclassBuilder) {
        this.genericSuperclassBuilderByOwner.put(ownerName, genericSuperclassBuilder);
    }

    public void addGenericInterfaces(String ownerName, List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericInterfaceBuilders) {
        this.genericInterfaceBuildersByOwner.put(ownerName, genericInterfaceBuilders);
    }

    void addField(String ownerName, DomainBuilders.JavaFieldBuilder fieldBuilder) {
        this.fieldBuildersByOwner.put(ownerName, fieldBuilder);
    }

    void addMethod(String ownerName, DomainBuilders.JavaMethodBuilder methodBuilder) {
        this.methodBuildersByOwner.put(ownerName, methodBuilder);
    }

    void addConstructor(String ownerName, DomainBuilders.JavaConstructorBuilder constructorBuilder) {
        this.constructorBuildersByOwner.put(ownerName, constructorBuilder);
    }

    void setStaticInitializer(String ownerName, DomainBuilders.JavaStaticInitializerBuilder builder) {
        Preconditions.checkState(!this.staticInitializerBuildersByOwner.containsKey(ownerName), "Tried to add a second static initializer to %s, this is most likely a bug", (Object)ownerName);
        this.staticInitializerBuildersByOwner.put(ownerName, builder);
    }

    void addClassAnnotations(String ownerName, Set<DomainBuilders.JavaAnnotationBuilder> annotations) {
        this.annotationsByOwner.putAll(ownerName, annotations);
    }

    void addMemberAnnotations(String declaringClassName, String memberName, String descriptor, Set<DomainBuilders.JavaAnnotationBuilder> annotations) {
        this.annotationsByOwner.putAll(ClassFileImportRecord.getMemberKey(declaringClassName, memberName, descriptor), annotations);
    }

    void addAnnotationDefaultValue(String declaringClassName, String methodName, String descriptor, DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
        this.annotationDefaultValuesByOwner.put(ClassFileImportRecord.getMemberKey(declaringClassName, methodName, descriptor), valueBuilder);
    }

    void setEnclosingClass(String ownerName, String enclosingClassName) {
        this.enclosingDeclarationsByOwner.registerEnclosingClass(ownerName, enclosingClassName);
    }

    void setEnclosingCodeUnit(String ownerName, RawAccessRecord.CodeUnit enclosingCodeUnit) {
        this.enclosingDeclarationsByOwner.registerEnclosingCodeUnit(ownerName, enclosingCodeUnit);
    }

    void addTryCatchBlocks(String declaringClassName, String methodName, String descriptor, Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlocks) {
        this.tryCatchBlocksByOwner.putAll(ClassFileImportRecord.getMemberKey(declaringClassName, methodName, descriptor), tryCatchBlocks);
    }

    Optional<String> getSuperclassFor(String name) {
        return Optional.ofNullable(this.superclassNamesByOwner.get(name));
    }

    List<String> getInterfaceNamesFor(String ownerName) {
        return this.interfaceNamesByOwner.get((Object)ownerName);
    }

    DomainBuilders.JavaClassTypeParametersBuilder getTypeParameterBuildersFor(String ownerName) {
        if (!this.typeParametersBuilderByOwner.containsKey(ownerName)) {
            return NO_TYPE_PARAMETERS;
        }
        return this.typeParametersBuilderByOwner.get(ownerName);
    }

    Optional<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> getGenericSuperclassFor(JavaClass owner) {
        return Optional.ofNullable(this.genericSuperclassBuilderByOwner.get(owner.getName()));
    }

    Optional<List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> getGenericInterfacesFor(JavaClass owner) {
        return Optional.ofNullable(this.genericInterfaceBuildersByOwner.get(owner.getName()));
    }

    Set<DomainBuilders.JavaFieldBuilder> getFieldBuildersFor(String ownerName) {
        return this.fieldBuildersByOwner.get((Object)ownerName);
    }

    Set<DomainBuilders.JavaMethodBuilder> getMethodBuildersFor(String ownerName) {
        return this.methodBuildersByOwner.get((Object)ownerName);
    }

    Set<DomainBuilders.JavaConstructorBuilder> getConstructorBuildersFor(String ownerName) {
        return this.constructorBuildersByOwner.get((Object)ownerName);
    }

    Optional<DomainBuilders.JavaStaticInitializerBuilder> getStaticInitializerBuilderFor(String ownerName) {
        return Optional.ofNullable(this.staticInitializerBuildersByOwner.get(ownerName));
    }

    Set<DomainBuilders.JavaAnnotationBuilder> getAnnotationsFor(JavaClass owner) {
        return this.annotationsByOwner.get((Object)owner.getName());
    }

    Set<DomainBuilders.JavaAnnotationBuilder> getAnnotationsFor(JavaMember owner) {
        return this.annotationsByOwner.get((Object)ClassFileImportRecord.getMemberKey(owner));
    }

    Optional<DomainBuilders.JavaAnnotationBuilder.ValueBuilder> getAnnotationDefaultValueBuilderFor(JavaMethod method) {
        return Optional.ofNullable(this.annotationDefaultValuesByOwner.get(ClassFileImportRecord.getMemberKey(method)));
    }

    Optional<String> getEnclosingClassFor(String ownerName) {
        return this.enclosingDeclarationsByOwner.getEnclosingClassName(ownerName);
    }

    Optional<RawAccessRecord.CodeUnit> getEnclosingCodeUnitFor(String ownerName) {
        return this.enclosingDeclarationsByOwner.getEnclosingCodeUnit(ownerName);
    }

    Set<DomainBuilders.TryCatchBlockBuilder> getTryCatchBlockBuildersFor(JavaCodeUnit codeUnit) {
        return this.tryCatchBlocksByOwner.get((Object)ClassFileImportRecord.getMemberKey(codeUnit));
    }

    void registerFieldAccess(RawAccessRecord.ForField record) {
        if (!JavaClassDescriptorImporter.isSyntheticEnumSwitchMapFieldName(record.target.name)) {
            this.rawFieldAccessRecords.add(record);
        }
    }

    void registerMethodCall(RawAccessRecord record) {
        if (JavaClassDescriptorImporter.isSyntheticAccessMethodName(record.target.name)) {
            this.syntheticPrivateAccessRecorder.registerSyntheticMethodInvocation(record);
        } else {
            this.rawMethodCallRecords.add(record);
        }
    }

    void registerConstructorCall(RawAccessRecord record) {
        this.rawConstructorCallRecords.add(record);
    }

    void registerMethodReference(RawAccessRecord record) {
        this.rawMethodReferenceRecords.add(record);
    }

    void registerConstructorReference(RawAccessRecord record) {
        this.rawConstructorReferenceRecords.add(record);
    }

    void registerLambdaInvocation(RawAccessRecord record) {
        this.syntheticLambdaAccessRecorder.registerSyntheticMethodInvocation(record);
    }

    void forEachRawFieldAccessRecord(Consumer<RawAccessRecord.ForField> doWithRecord) {
        this.fixSyntheticOrigins(this.rawFieldAccessRecords, COPY_RAW_FIELD_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawMethodCallRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.fixSyntheticOrigins(this.rawMethodCallRecords, COPY_RAW_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawConstructorCallRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.fixSyntheticOrigins(this.rawConstructorCallRecords, COPY_RAW_ACCESS_RECORD, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawMethodReferenceRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.fixSyntheticOrigins(this.rawMethodReferenceRecords, COPY_RAW_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawConstructorReferenceRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.fixSyntheticOrigins(this.rawConstructorReferenceRecords, COPY_RAW_ACCESS_RECORD, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    private <ACCESS extends RawAccessRecord> Stream<ACCESS> fixSyntheticOrigins(Set<ACCESS> rawAccessRecordsIncludingSyntheticAccesses, Function<ACCESS, ? extends RawAccessRecord.BaseBuilder<ACCESS, ?>> createAccessWithNewOrigin, SyntheticAccessRecorder ... syntheticAccessRecorders) {
        Stream<Object> result = rawAccessRecordsIncludingSyntheticAccesses.stream();
        for (SyntheticAccessRecorder syntheticAccessRecorder : syntheticAccessRecorders) {
            result = result.flatMap(access -> syntheticAccessRecorder.fixSyntheticAccess(access, createAccessWithNewOrigin).stream());
        }
        return result;
    }

    void add(JavaClass javaClass) {
        this.classes.put(javaClass.getName(), javaClass);
    }

    Map<String, JavaClass> getClasses() {
        return this.classes;
    }

    private static SyntheticAccessRecorder createSyntheticLambdaAccessRecorder() {
        return new SyntheticAccessRecorder(codeUnit -> JavaClassDescriptorImporter.isLambdaMethodName(codeUnit.getName()), (accessBuilder, newOrigin) -> ((RawAccessRecord.BaseBuilder)accessBuilder.withCaller((RawAccessRecord.CodeUnit)newOrigin)).withDeclaredInLambda(true));
    }

    private static SyntheticAccessRecorder createSyntheticPrivateAccessRecorder() {
        return new SyntheticAccessRecorder(codeUnit -> JavaClassDescriptorImporter.isSyntheticAccessMethodName(codeUnit.getName()), RawAccessRecord.BaseBuilder::withCaller);
    }

    private static String getMemberKey(RawAccessRecord.MemberSignature member) {
        return ClassFileImportRecord.getMemberKey(member.getDeclaringClassName(), member.getName(), member.getDescriptor());
    }

    private static String getMemberKey(JavaMember member) {
        return ClassFileImportRecord.getMemberKey(member.getOwner().getName(), member.getName(), member.getDescriptor());
    }

    private static String getMemberKey(String declaringClassName, String methodName, String descriptor) {
        return declaringClassName + "|" + methodName + "|" + descriptor;
    }

    private static class EnclosingDeclarationsByInnerClasses {
        private final Map<String, String> innerClassNameToEnclosingClassName = new HashMap<String, String>();
        private final Map<String, RawAccessRecord.CodeUnit> innerClassNameToEnclosingCodeUnit = new HashMap<String, RawAccessRecord.CodeUnit>();

        private EnclosingDeclarationsByInnerClasses() {
        }

        void registerEnclosingClass(String innerName, String outerName) {
            Preconditions.checkArgument(!this.innerClassNameToEnclosingClassName.containsKey(innerName) || this.innerClassNameToEnclosingClassName.get(innerName).equals(outerName), "Can't register multiple enclosing classes, this is likely a bug!");
            this.innerClassNameToEnclosingClassName.put(innerName, outerName);
        }

        void registerEnclosingCodeUnit(String innerName, RawAccessRecord.CodeUnit codeUnit) {
            Preconditions.checkArgument(!this.innerClassNameToEnclosingCodeUnit.containsKey(innerName) || this.innerClassNameToEnclosingCodeUnit.get(innerName).equals(codeUnit), "Can't register multiple enclosing code units, this is likely a bug!");
            this.innerClassNameToEnclosingCodeUnit.put(innerName, codeUnit);
        }

        Optional<String> getEnclosingClassName(String ownerName) {
            return Optional.ofNullable(this.innerClassNameToEnclosingClassName.get(ownerName));
        }

        Optional<RawAccessRecord.CodeUnit> getEnclosingCodeUnit(String ownerName) {
            return Optional.ofNullable(this.innerClassNameToEnclosingCodeUnit.get(ownerName));
        }
    }

    private static class SyntheticAccessRecorder {
        private final SetMultimap<String, RawAccessRecord> rawSyntheticMethodInvocationRecordsByTarget = HashMultimap.create();
        private final Predicate<RawAccessRecord.CodeUnit> isSyntheticOrigin;
        private final BiConsumer<RawAccessRecord.BaseBuilder<?, ?>, RawAccessRecord.CodeUnit> fixOrigin;

        SyntheticAccessRecorder(Predicate<RawAccessRecord.CodeUnit> isSyntheticOrigin, BiConsumer<RawAccessRecord.BaseBuilder<?, ?>, RawAccessRecord.CodeUnit> fixOrigin) {
            this.isSyntheticOrigin = isSyntheticOrigin;
            this.fixOrigin = fixOrigin;
        }

        void registerSyntheticMethodInvocation(RawAccessRecord record) {
            this.rawSyntheticMethodInvocationRecordsByTarget.put(ClassFileImportRecord.getMemberKey(record.target), record);
        }

        <ACCESS extends RawAccessRecord> Set<ACCESS> fixSyntheticAccess(ACCESS access, Function<ACCESS, ? extends RawAccessRecord.BaseBuilder<ACCESS, ?>> copyAccess) {
            return this.isSyntheticOrigin.test(access.caller) ? this.replaceOriginByFixedOrigin(access, copyAccess) : Collections.singleton(access);
        }

        private <ACCESS extends RawAccessRecord> Set<ACCESS> replaceOriginByFixedOrigin(ACCESS accessFromSyntheticMethod, Function<ACCESS, ? extends RawAccessRecord.BaseBuilder<ACCESS, ?>> copyAccess) {
            Set result = this.findNonSyntheticOriginOf(accessFromSyntheticMethod).map(accessWithCorrectOrigin -> {
                RawAccessRecord.BaseBuilder copiedBuilder = (RawAccessRecord.BaseBuilder)copyAccess.apply(accessFromSyntheticMethod);
                this.fixOrigin.accept(copiedBuilder, accessWithCorrectOrigin.caller);
                return copiedBuilder.build();
            }).collect(Collectors.toSet());
            if (result.isEmpty()) {
                log.warn("Could not find matching origin for synthetic method {}.{}|{}", new Object[]{accessFromSyntheticMethod.target.getDeclaringClassName(), accessFromSyntheticMethod.target.name, accessFromSyntheticMethod.target.getDescriptor()});
            }
            return result;
        }

        private <ACCESS extends RawAccessRecord> Stream<RawAccessRecord> findNonSyntheticOriginOf(ACCESS access) {
            return this.isSyntheticOrigin.test(access.caller) ? this.rawSyntheticMethodInvocationRecordsByTarget.get((Object)ClassFileImportRecord.getMemberKey(access.caller)).stream().flatMap(this::findNonSyntheticOriginOf) : Stream.of(access);
        }
    }
}

