/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

interface AccessRecord<TARGET extends AccessTarget> {
    public JavaCodeUnit getOrigin();

    public TARGET getTarget();

    public int getLineNumber();

    public boolean isDeclaredInLambda();

    public RawAccessRecord getRaw();

    @Internal
    public static abstract class Factory<RAW_RECORD, PROCESSED_RECORD> {
        private static final AccessTargetFactory<AccessTarget.ConstructorCallTarget> CONSTRUCTOR_CALL_TARGET_FACTORY = new ConstructorAccessTargetFactory<AccessTarget.ConstructorCallTarget>(DomainBuilders::newConstructorCallTargetBuilder);
        private static final AccessTargetFactory<AccessTarget.ConstructorReferenceTarget> CONSTRUCTOR_REFERENCE_TARGET_FACTORY = new ConstructorAccessTargetFactory<AccessTarget.ConstructorReferenceTarget>(DomainBuilders::newConstructorReferenceTargetBuilder);
        private static final AccessTargetFactory<AccessTarget.MethodCallTarget> METHOD_CALL_TARGET_FACTORY = new MethodAccessTargetFactory<AccessTarget.MethodCallTarget>(DomainBuilders::newMethodCallTargetBuilder);
        private static final AccessTargetFactory<AccessTarget.MethodReferenceTarget> METHOD_REFERENCE_TARGET_FACTORY = new MethodAccessTargetFactory<AccessTarget.MethodReferenceTarget>(DomainBuilders::newMethodReferenceTargetBuilder);
        private static final AccessTargetFactory<AccessTarget.FieldAccessTarget> FIELD_ACCESS_TARGET_FACTORY = new FieldAccessTargetFactory();

        abstract PROCESSED_RECORD create(RAW_RECORD var1, ImportedClasses var2);

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorCallTarget>> forConstructorCallRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorCallTarget>>(){

                @Override
                AccessRecord<AccessTarget.ConstructorCallTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawAccessRecordProcessed<AccessTarget.ConstructorCallTarget>(record, classes, CONSTRUCTOR_CALL_TARGET_FACTORY);
                }
            };
        }

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorReferenceTarget>> forConstructorReferenceRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorReferenceTarget>>(){

                @Override
                AccessRecord<AccessTarget.ConstructorReferenceTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawAccessRecordProcessed<AccessTarget.ConstructorReferenceTarget>(record, classes, CONSTRUCTOR_REFERENCE_TARGET_FACTORY);
                }
            };
        }

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodCallTarget>> forMethodCallRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodCallTarget>>(){

                @Override
                AccessRecord<AccessTarget.MethodCallTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawAccessRecordProcessed<AccessTarget.MethodCallTarget>(record, classes, METHOD_CALL_TARGET_FACTORY);
                }
            };
        }

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodReferenceTarget>> forMethodReferenceRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodReferenceTarget>>(){

                @Override
                AccessRecord<AccessTarget.MethodReferenceTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawAccessRecordProcessed<AccessTarget.MethodReferenceTarget>(record, classes, METHOD_REFERENCE_TARGET_FACTORY);
                }
            };
        }

        static Factory<RawAccessRecord.ForField, FieldAccessRecord> forFieldAccessRecord() {
            return new Factory<RawAccessRecord.ForField, FieldAccessRecord>(){

                @Override
                FieldAccessRecord create(RawAccessRecord.ForField record, ImportedClasses classes) {
                    return new RawFieldAccessRecordProcessed(record, classes);
                }
            };
        }

        private static Supplier<JavaCodeUnit> createOriginSupplier(RawAccessRecord.CodeUnit origin, ImportedClasses classes) {
            return Suppliers.memoize(() -> Factory.getOrigin(origin, classes));
        }

        private static JavaCodeUnit getOrigin(RawAccessRecord.CodeUnit rawOrigin, ImportedClasses classes) {
            for (JavaCodeUnit method : classes.getOrResolve(rawOrigin.getDeclaringClassName()).getCodeUnits()) {
                if (!rawOrigin.is(method)) continue;
                return method;
            }
            throw new IllegalStateException("Never found a " + JavaCodeUnit.class.getSimpleName() + " that matches supposed origin " + rawOrigin);
        }

        private static List<JavaClass> getArgumentTypesFrom(String descriptor, ImportedClasses classes) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaClassDescriptor type : JavaClassDescriptorImporter.importAsmMethodArgumentTypes(descriptor)) {
                result.add(classes.getOrResolve(type.getFullyQualifiedClassName()));
            }
            return result.build();
        }

        private static Optional<JavaField> searchTargetField(JavaClass targetOwner, RawAccessRecord.TargetInfo targetInfo) {
            Optional<JavaField> directlyFound = targetOwner.tryGetField(targetInfo.name);
            if (directlyFound.isPresent()) {
                return directlyFound;
            }
            Optional<JavaField> foundOnInterface = Factory.searchFieldInInterfaces(targetOwner, targetInfo);
            if (foundOnInterface.isPresent()) {
                return foundOnInterface;
            }
            return Factory.searchFieldInSuperClass(targetOwner, targetInfo);
        }

        private static Optional<JavaField> searchFieldInInterfaces(JavaClass targetOwner, RawAccessRecord.TargetInfo targetInfo) {
            for (JavaClass rawInterface : targetOwner.getRawInterfaces()) {
                Optional<JavaField> foundOnInterface = Factory.searchTargetField(rawInterface, targetInfo);
                if (!foundOnInterface.isPresent()) continue;
                return foundOnInterface;
            }
            return Optional.empty();
        }

        private static Optional<JavaField> searchFieldInSuperClass(JavaClass targetOwner, RawAccessRecord.TargetInfo targetInfo) {
            return targetOwner.getRawSuperclass().isPresent() ? Factory.searchTargetField(targetOwner.getRawSuperclass().get(), targetInfo) : Optional.empty();
        }

        private static Optional<JavaMethod> searchTargetMethod(JavaClass targetOwner, RawAccessRecord.TargetInfo targetInfo) {
            MatchingMethods matchingMethods = new MatchingMethods(targetInfo);
            matchingMethods.addMatching(targetOwner.getMethods(), true);
            return matchingMethods.hasMatch() ? matchingMethods.determineMostSpecificMethod() : Factory.searchTargetMethodInHierarchy(targetOwner, matchingMethods);
        }

        private static Optional<JavaMethod> searchTargetMethodInHierarchy(JavaClass targetOwner, MatchingMethods matchingMethods) {
            Optional<JavaClass> superclass = targetOwner.getRawSuperclass();
            if (superclass.isPresent()) {
                matchingMethods.addMatching(superclass.get().getMethods(), true);
                Factory.searchTargetMethodInHierarchy(superclass.get(), matchingMethods);
            }
            for (JavaClass interfaceType : targetOwner.getRawInterfaces()) {
                matchingMethods.addMatching(interfaceType.getMethods(), false);
                Factory.searchTargetMethodInHierarchy(interfaceType, matchingMethods);
            }
            return matchingMethods.determineMostSpecificMethod();
        }

        private static interface AccessTargetFactory<TARGET extends AccessTarget> {
            public TARGET create(JavaClass var1, RawAccessRecord.TargetInfo var2, ImportedClasses var3);
        }

        private static class MatchingMethods {
            private final RawAccessRecord.TargetInfo target;
            private final LinkedHashMultimap<JavaClass, JavaMethod> matchingMethodsByReturnType = LinkedHashMultimap.create();

            private MatchingMethods(RawAccessRecord.TargetInfo target) {
                this.target = target;
            }

            void addMatching(Collection<JavaMethod> methods, boolean includeStatic) {
                for (JavaMethod method : methods) {
                    if (!this.matches(method, includeStatic)) continue;
                    this.matchingMethodsByReturnType.put((Object)method.getRawReturnType(), (Object)method);
                }
            }

            private boolean matches(JavaMethod method, boolean includeStatic) {
                return method.getName().equals(this.target.name) && method.getDescriptor().equals(this.target.desc) && (includeStatic || !method.getModifiers().contains((Object)JavaModifier.STATIC));
            }

            boolean hasMatch() {
                return !this.matchingMethodsByReturnType.isEmpty();
            }

            Optional<JavaMethod> determineMostSpecificMethod() {
                if (!this.hasMatch()) {
                    return Optional.empty();
                }
                if (this.matchingMethodsByReturnType.size() == 1) {
                    return MatchingMethods.determineMostSpecificMethodWithSameReturnType(this.matchingMethodsByReturnType.values());
                }
                Collection<JavaMethod> methodsWithMostSpecificReturnType = MatchingMethods.determineMethodsWithMostSpecificReturnType(this.matchingMethodsByReturnType);
                return MatchingMethods.determineMostSpecificMethodWithSameReturnType(methodsWithMostSpecificReturnType);
            }

            private static Optional<JavaMethod> determineMostSpecificMethodWithSameReturnType(Collection<JavaMethod> methods) {
                JavaMethod result = null;
                for (JavaMethod method : methods) {
                    if (result != null && !method.getOwner().isAssignableTo(result.getOwner().getName())) continue;
                    result = method;
                }
                return Optional.ofNullable(result);
            }

            private static Collection<JavaMethod> determineMethodsWithMostSpecificReturnType(LinkedHashMultimap<JavaClass, JavaMethod> matchingMethodsByReturnType) {
                Map.Entry result = null;
                for (Map.Entry entry : matchingMethodsByReturnType.asMap().entrySet()) {
                    if (result != null && !((JavaClass)entry.getKey()).isAssignableTo(((JavaClass)result.getKey()).getName())) continue;
                    result = entry;
                }
                return result != null ? (Collection)result.getValue() : Collections.emptySet();
            }
        }

        private static class ConstructorAccessTargetFactory<TARGET extends AccessTarget.CodeUnitAccessTarget>
        implements AccessTargetFactory<TARGET> {
            private final Supplier<DomainBuilders.CodeUnitAccessTargetBuilder<JavaConstructor, TARGET>> targetBuilderSupplier;

            private ConstructorAccessTargetFactory(Supplier<DomainBuilders.CodeUnitAccessTargetBuilder<JavaConstructor, TARGET>> targetBuilderSupplier) {
                this.targetBuilderSupplier = targetBuilderSupplier;
            }

            @Override
            public TARGET create(JavaClass targetOwner, RawAccessRecord.TargetInfo target, ImportedClasses classes) {
                ConstructorSupplier memberSupplier = new ConstructorSupplier(targetOwner, target);
                List paramTypes = Factory.getArgumentTypesFrom(target.desc, classes);
                JavaClass returnType = classes.getOrResolve(Void.TYPE.getName());
                return (TARGET)((AccessTarget.CodeUnitAccessTarget)((DomainBuilders.CodeUnitAccessTargetBuilder)((DomainBuilders.CodeUnitAccessTargetBuilder)this.targetBuilderSupplier.get().withOwner(targetOwner)).withParameters(paramTypes).withReturnType(returnType).withMember(memberSupplier)).build());
            }

            private static class ConstructorSupplier
            implements Supplier<Optional<JavaConstructor>> {
                private final JavaClass targetOwner;
                private final RawAccessRecord.TargetInfo target;

                ConstructorSupplier(JavaClass targetOwner, RawAccessRecord.TargetInfo target) {
                    this.targetOwner = targetOwner;
                    this.target = target;
                }

                @Override
                public Optional<JavaConstructor> get() {
                    for (JavaConstructor constructor : this.targetOwner.getConstructors()) {
                        if (!constructor.getDescriptor().equals(this.target.desc)) continue;
                        return Optional.of(constructor);
                    }
                    return Optional.empty();
                }
            }
        }

        private static class MethodAccessTargetFactory<TARGET extends AccessTarget.CodeUnitAccessTarget>
        implements AccessTargetFactory<TARGET> {
            private final Supplier<DomainBuilders.CodeUnitAccessTargetBuilder<JavaMethod, TARGET>> targetBuilderSupplier;

            private MethodAccessTargetFactory(Supplier<DomainBuilders.CodeUnitAccessTargetBuilder<JavaMethod, TARGET>> targetBuilderSupplier) {
                this.targetBuilderSupplier = targetBuilderSupplier;
            }

            @Override
            public TARGET create(JavaClass targetOwner, RawAccessRecord.TargetInfo target, ImportedClasses classes) {
                MethodSupplier methodsSupplier = new MethodSupplier(targetOwner, target);
                List parameters = Factory.getArgumentTypesFrom(target.desc, classes);
                JavaClass returnType = classes.getOrResolve(JavaClassDescriptorImporter.importAsmMethodReturnType(target.desc).getFullyQualifiedClassName());
                return (TARGET)((AccessTarget.CodeUnitAccessTarget)((DomainBuilders.CodeUnitAccessTargetBuilder)((DomainBuilders.CodeUnitAccessTargetBuilder)((DomainBuilders.CodeUnitAccessTargetBuilder)this.targetBuilderSupplier.get().withOwner(targetOwner)).withName(target.name)).withParameters(parameters).withReturnType(returnType).withMember(methodsSupplier)).build());
            }

            private static class MethodSupplier
            implements Supplier<Optional<JavaMethod>> {
                private final JavaClass targetOwner;
                private final RawAccessRecord.TargetInfo target;

                MethodSupplier(JavaClass targetOwner, RawAccessRecord.TargetInfo target) {
                    this.targetOwner = targetOwner;
                    this.target = target;
                }

                @Override
                public Optional<JavaMethod> get() {
                    return Factory.searchTargetMethod(this.targetOwner, this.target);
                }
            }
        }

        private static class FieldAccessTargetFactory
        implements AccessTargetFactory<AccessTarget.FieldAccessTarget> {
            private FieldAccessTargetFactory() {
            }

            @Override
            public AccessTarget.FieldAccessTarget create(JavaClass targetOwner, RawAccessRecord.TargetInfo target, ImportedClasses classes) {
                FieldSupplier fieldSupplier = new FieldSupplier(targetOwner, target);
                JavaClass fieldType = classes.getOrResolve(JavaClassDescriptorImporter.importAsmTypeFromDescriptor(target.desc).getFullyQualifiedClassName());
                return (AccessTarget.FieldAccessTarget)((DomainBuilders.FieldAccessTargetBuilder)((DomainBuilders.FieldAccessTargetBuilder)((DomainBuilders.FieldAccessTargetBuilder)new DomainBuilders.FieldAccessTargetBuilder().withOwner(targetOwner)).withName(target.name)).withType(fieldType).withMember(fieldSupplier)).build();
            }

            private static class FieldSupplier
            implements Supplier<Optional<JavaField>> {
                private final JavaClass targetOwner;
                private final RawAccessRecord.TargetInfo target;

                FieldSupplier(JavaClass targetOwner, RawAccessRecord.TargetInfo target) {
                    this.targetOwner = targetOwner;
                    this.target = target;
                }

                @Override
                public Optional<JavaField> get() {
                    return Factory.searchTargetField(this.targetOwner, this.target);
                }
            }
        }

        private static class RawFieldAccessRecordProcessed
        extends RawAccessRecordProcessed<AccessTarget.FieldAccessTarget>
        implements FieldAccessRecord {
            private final JavaFieldAccess.AccessType accessType;

            RawFieldAccessRecordProcessed(RawAccessRecord.ForField record, ImportedClasses classes) {
                super(record, classes, FIELD_ACCESS_TARGET_FACTORY);
                this.accessType = record.accessType;
            }

            @Override
            public JavaFieldAccess.AccessType getAccessType() {
                return this.accessType;
            }
        }

        private static class RawAccessRecordProcessed<TARGET extends AccessTarget>
        implements AccessRecord<TARGET> {
            private final RawAccessRecord record;
            private final ImportedClasses classes;
            private final JavaClass targetOwner;
            private final AccessTargetFactory<TARGET> accessTargetFactory;
            private final Supplier<JavaCodeUnit> originSupplier;

            RawAccessRecordProcessed(RawAccessRecord record, ImportedClasses classes, AccessTargetFactory<TARGET> accessTargetFactory) {
                this.record = record;
                this.classes = classes;
                this.targetOwner = this.classes.getOrResolve(record.target.owner.getFullyQualifiedClassName());
                this.accessTargetFactory = accessTargetFactory;
                this.originSupplier = Factory.createOriginSupplier(record.caller, classes);
            }

            @Override
            public JavaCodeUnit getOrigin() {
                return this.originSupplier.get();
            }

            @Override
            public TARGET getTarget() {
                return this.accessTargetFactory.create(this.targetOwner, this.record.target, this.classes);
            }

            @Override
            public int getLineNumber() {
                return this.record.lineNumber;
            }

            @Override
            public boolean isDeclaredInLambda() {
                return this.record.declaredInLambda;
            }

            @Override
            public RawAccessRecord getRaw() {
                return this.record;
            }
        }
    }

    @Internal
    public static interface FieldAccessRecord
    extends AccessRecord<AccessTarget.FieldAccessTarget> {
        public JavaFieldAccess.AccessType getAccessType();
    }
}

