/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.ForwardingList;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ResolvesTypesViaReflection;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.InstanceofCheck;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnitReference;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaConstructorReference;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaMethodReference;
import com.tngtech.archunit.core.domain.JavaParameter;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.ReferencedClassObject;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.TryCatchBlock;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasTypeParameters;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public abstract class JavaCodeUnit
extends JavaMember
implements HasParameterTypes,
HasReturnType,
HasTypeParameters<JavaCodeUnit>,
HasThrowsClause<JavaCodeUnit> {
    private final ReturnType returnType;
    private final Parameters parameters;
    private final String fullName;
    private final List<JavaTypeVariable<JavaCodeUnit>> typeParameters;
    private final Set<ReferencedClassObject> referencedClassObjects;
    private final Set<InstanceofCheck> instanceofChecks;
    private Set<JavaFieldAccess> fieldAccesses = Collections.emptySet();
    private Set<JavaMethodCall> methodCalls = Collections.emptySet();
    private Set<JavaConstructorCall> constructorCalls = Collections.emptySet();
    private Set<JavaMethodReference> methodReferences = Collections.emptySet();
    private Set<JavaConstructorReference> constructorReferences = Collections.emptySet();
    private Set<TryCatchBlock> tryCatchBlocks = Collections.emptySet();

    JavaCodeUnit(DomainBuilders.JavaCodeUnitBuilder<?, ?> builder) {
        super(builder);
        this.typeParameters = builder.getTypeParameters(this);
        this.returnType = new ReturnType(this, builder);
        this.parameters = new Parameters(this, builder);
        this.fullName = Formatters.formatMethod(this.getOwner().getName(), this.getName(), HasName.Utils.namesOf(this.getRawParameterTypes()));
        this.referencedClassObjects = ImmutableSet.copyOf(builder.getReferencedClassObjects(this));
        this.instanceofChecks = ImmutableSet.copyOf(builder.getInstanceofChecks(this));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getRawParameterTypes() {
        return this.parameters.getRawParameterTypes();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaType> getParameterTypes() {
        return this.parameters.getParameterTypes();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaParameter> getParameters() {
        return this.parameters;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract ThrowsClause<? extends JavaCodeUnit> getThrowsClause();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getExceptionTypes() {
        return this.getThrowsClause().getTypes();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaType getReturnType() {
        return this.returnType.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawReturnType() {
        return this.returnType.getRaw();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaFieldAccess> getFieldAccesses() {
        return this.fieldAccesses;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Set<? extends JavaCall<?>> getCallsOfSelf();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getMethodCallsFromSelf() {
        return this.methodCalls;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorCall> getConstructorCallsFromSelf() {
        return this.constructorCalls;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodReference> getMethodReferencesFromSelf() {
        return this.methodReferences;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorReference> getConstructorReferencesFromSelf() {
        return this.constructorReferences;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<ReferencedClassObject> getReferencedClassObjects() {
        return this.referencedClassObjects;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<InstanceofCheck> getInstanceofChecks() {
        return this.instanceofChecks;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<TryCatchBlock> getTryCatchBlocks() {
        return this.tryCatchBlocks;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCall<?>> getCallsFromSelf() {
        return Sets.union(this.getMethodCallsFromSelf(), this.getConstructorCallsFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnitReference<?>> getCodeUnitReferencesFromSelf() {
        return Sets.union(this.getMethodReferencesFromSelf(), this.getConstructorReferencesFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAccessesFromSelf() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getCallsFromSelf())).addAll(this.getFieldAccesses())).addAll(this.getCodeUnitReferencesFromSelf())).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isConstructor() {
        return false;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMethod() {
        return false;
    }

    @Override
    public Set<? extends JavaAnnotation<? extends JavaCodeUnit>> getAnnotations() {
        return super.getAnnotations();
    }

    @Override
    public JavaAnnotation<? extends JavaCodeUnit> getAnnotationOfType(String typeName) {
        return super.getAnnotationOfType(typeName);
    }

    @Override
    public Optional<? extends JavaAnnotation<? extends JavaCodeUnit>> tryGetAnnotationOfType(String typeName) {
        return super.tryGetAnnotationOfType(typeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<? extends JavaTypeVariable<? extends JavaCodeUnit>> getTypeParameters() {
        return this.typeParameters;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<Set<JavaAnnotation<JavaParameter>>> getParameterAnnotations() {
        return this.parameters.getAnnotations();
    }

    void completeAccessesFrom(ImportContext context) {
        Set<DomainBuilders.TryCatchBlockBuilder> tryCatchBlockBuilders = context.createTryCatchBlockBuilders(this);
        this.fieldAccesses = context.createFieldAccessesFor(this, tryCatchBlockBuilders);
        this.methodCalls = context.createMethodCallsFor(this, tryCatchBlockBuilders);
        this.constructorCalls = context.createConstructorCallsFor(this, tryCatchBlockBuilders);
        this.methodReferences = context.createMethodReferencesFor(this, tryCatchBlockBuilders);
        this.constructorReferences = context.createConstructorReferencesFor(this, tryCatchBlockBuilders);
        this.tryCatchBlocks = tryCatchBlockBuilders.stream().map(builder -> builder.build(this, context)).collect(ImmutableSet.toImmutableSet());
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="Just part of a bigger resolution process")
    static Class<?>[] reflect(List<JavaClass> parameters) {
        return (Class[])parameters.stream().map(JavaClass::reflect).toArray(Class[]::new);
    }

    private static class ReturnType {
        private final JavaClass rawReturnType;
        private final JavaType returnType;

        ReturnType(JavaCodeUnit owner, DomainBuilders.JavaCodeUnitBuilder<?, ?> builder) {
            this.rawReturnType = builder.getRawReturnType();
            this.returnType = builder.getGenericReturnType(owner);
        }

        JavaClass getRaw() {
            return this.rawReturnType;
        }

        JavaType get() {
            return this.returnType;
        }
    }

    private static class Parameters
    extends ForwardingList<JavaParameter> {
        private final List<JavaClass> rawParameterTypes;
        private final List<JavaType> parameterTypes;
        private final List<Set<JavaAnnotation<JavaParameter>>> parameterAnnotations;
        private final List<JavaParameter> parameters;

        Parameters(JavaCodeUnit owner, DomainBuilders.JavaCodeUnitBuilder<?, ?> builder) {
            this.rawParameterTypes = builder.getRawParameterTypes();
            this.parameterTypes = this.getParameterTypes(builder.getGenericParameterTypes(owner));
            this.parameters = Parameters.createParameters(owner, builder, this.parameterTypes);
            this.parameterAnnotations = this.annotationsOf(this.parameters);
        }

        private List<Set<JavaAnnotation<JavaParameter>>> annotationsOf(List<JavaParameter> parameters) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaParameter parameter : parameters) {
                result.add(parameter.getAnnotations());
            }
            return result.build();
        }

        private static List<JavaParameter> createParameters(JavaCodeUnit owner, DomainBuilders.JavaCodeUnitBuilder<?, ?> builder, List<JavaType> parameterTypes) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (int i = 0; i < parameterTypes.size(); ++i) {
                result.add(new JavaParameter(owner, builder.getParameterAnnotationsBuilder(i), i, parameterTypes.get(i)));
            }
            return result.build();
        }

        private List<JavaType> getParameterTypes(List<JavaType> genericParameterTypes) {
            return genericParameterTypes.isEmpty() ? this.rawParameterTypes : genericParameterTypes;
        }

        List<JavaClass> getRawParameterTypes() {
            return this.rawParameterTypes;
        }

        List<JavaType> getParameterTypes() {
            return this.parameterTypes;
        }

        List<Set<JavaAnnotation<JavaParameter>>> getAnnotations() {
            return this.parameterAnnotations;
        }

        @Override
        protected List<JavaParameter> delegate() {
            return this.parameters;
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        private Functions() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Get {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<JavaCodeUnit, Set<? extends JavaCall<?>>> GET_CALLS_OF_SELF = new ChainableFunction<JavaCodeUnit, Set<? extends JavaCall<?>>>(){

                @Override
                public Set<? extends JavaCall<?>> apply(JavaCodeUnit input) {
                    return input.getCallsOfSelf();
                }
            };

            private Get() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static <T extends JavaCodeUnit> ChainableFunction<T, ThrowsClause<T>> throwsClause() {
                return new ChainableFunction<T, ThrowsClause<T>>(){

                    @Override
                    public ThrowsClause<T> apply(T input) {
                        return ((JavaCodeUnit)input).getThrowsClause();
                    }
                };
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaCodeUnit> constructor() {
            return new DescribedPredicate<JavaCodeUnit>("constructor", new Object[0]){

                @Override
                public boolean test(JavaCodeUnit input) {
                    return input.isConstructor();
                }
            };
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaCodeUnit> method() {
            return new DescribedPredicate<JavaCodeUnit>("method", new Object[0]){

                @Override
                public boolean test(JavaCodeUnit input) {
                    return input.isMethod();
                }
            };
        }
    }
}

