/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StateController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.SQLException;

public class StatementController
extends StateController
implements RowFetchController {
    private String query;
    private TDStatement statement;
    private byte mode = (byte)66;
    private int resultTypeExpected;
    private TDParcelState historicalState;
    private TDParcelState historicalReturnState;
    protected boolean clearStatementStateLock = false;
    private int currentRequestNumber;
    private SQLException storedException;
    private byte lobSelect = (byte)83;
    private int currentStatementNumber;
    private SQLException m_batchExceptions;
    private int m_failedStatementNumber;
    private String m_sRequestOrigin = "application";
    public static final int UPDATE_EXPECTED = 1;
    public static final int RS_EXPECTED = 2;
    public static final int RS_OR_UPDATE = 3;
    public static final int NO_RS_OR_UPDATE = 4;
    public static final int BATCH_UPDATE_EXPECTED = 5;

    public StatementController(TDStatement tDStatement, TDSession tDSession) throws SQLException {
        super(tDSession);
        this.statement = tDStatement;
        if (tDSession.isJavaSPDefaultConnection()) {
            this.lobSelect = (byte)67;
        }
    }

    public StatementController(TDStatement tDStatement, TDSession tDSession, String string) throws SQLException {
        this(tDStatement, tDSession);
        this.query = string;
    }

    public void setRequestOrigin(String string) {
        this.m_sRequestOrigin = string;
    }

    public String getRequestOrigin() {
        return this.m_sRequestOrigin;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getQuery() {
        return this.query;
    }

    public TDStatement getStatement() {
        return this.statement;
    }

    public void run() throws SQLException {
        TDParcelState tDParcelState = null;
        this.storedException = null;
        if (this.historicalState == null) {
            tDParcelState = new StatementSendState(this);
            this.clearStatementStateLock = false;
        } else {
            tDParcelState = this.historicalState;
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementController.run setting hist state to null; it was=" + this.historicalState + " this=" + this);
            }
            this.historicalState = null;
        }
        this.runBody(tDParcelState);
    }

    public void runBody(TDParcelState tDParcelState) throws SQLException {
        SQLException sQLException = null;
        while (tDParcelState != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("StatementController.runBody invoking action for state=" + tDParcelState + " this=" + this);
                }
                tDParcelState = tDParcelState.action();
            }
            catch (SQLException sQLException2) {
                SQLException sQLException3;
                if (this.clearStatementStateLock) {
                    this.statement.releaseStatementStateLock();
                    this.clearStatementStateLock = false;
                }
                tDParcelState = this.handleRunException(sQLException2);
                SQLException sQLException4 = sQLException3 = this.getBatchExceptions() == null ? sQLException2 : this.getAndRemoveBatchExceptions();
                if (sQLException == null) {
                    sQLException = sQLException3;
                    continue;
                }
                sQLException.setNextException(sQLException3);
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementController.runBody completed while loop with null state, this=" + this);
        }
        if (this.clearStatementStateLock) {
            this.statement.releaseStatementStateLock();
            this.clearStatementStateLock = false;
        }
        if (this.storedException != null) {
            this.handleRunException(ErrorFactory.cloneJDBCException(this.storedException, 1));
            this.storedException = this.getBatchExceptions() == null ? this.storedException : this.getAndRemoveBatchExceptions();
            throw this.storedException;
        }
    }

    protected TDParcelState handleRunException(SQLException sQLException) throws SQLException {
        return null;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getResultTypeExpected() {
        return this.resultTypeExpected;
    }

    public void setResultTypeExpected(int n) {
        this.resultTypeExpected = n;
    }

    public void setHistoricalState(TDParcelState tDParcelState) {
        this.historicalState = tDParcelState;
    }

    public TDParcelState getHistoricalState() {
        return this.historicalState;
    }

    public void setHistoricalReturnState(TDParcelState tDParcelState) {
        this.historicalReturnState = tDParcelState;
    }

    public TDParcelState getHistoricalReturnState() {
        return this.historicalReturnState;
    }

    public int getCurrentRequestNumber() {
        return this.currentRequestNumber;
    }

    public void setCurrentRequestNumber(int n) {
        this.currentRequestNumber = n;
    }

    public void setStoredException(SQLException sQLException) {
        this.storedException = sQLException;
    }

    public SQLException getStoredException() {
        return this.storedException;
    }

    public byte getLobSelect() {
        return this.lobSelect;
    }

    public void setLobSelect(byte by) {
        this.lobSelect = by;
    }

    public boolean usePositioning() {
        if (this.mode == 83 || this.mode == 80) {
            return false;
        }
        switch (this.statement.getResultSetType()) {
            case 1004: 
            case 1005: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String string = String.valueOf(this.query).replaceAll("\\s", "");
        string = string.substring(0, Math.min(string.length(), 20));
        return super.toString() + "(sql=" + string + " stmt=" + this.statement + ")";
    }

    public void setCurrentStatementNumber(int n) {
        this.currentStatementNumber = n;
    }

    public int getCurrentStatementNumber() {
        return this.currentStatementNumber;
    }

    public StatementController(StatementController statementController) throws SQLException {
        this(statementController.statement, statementController.session, statementController.query);
        this.mode = statementController.mode;
        this.resultTypeExpected = statementController.resultTypeExpected;
        this.historicalState = statementController.historicalState;
        this.clearStatementStateLock = statementController.clearStatementStateLock;
        this.currentRequestNumber = statementController.currentRequestNumber;
        this.storedException = statementController.storedException;
        this.lobSelect = statementController.lobSelect;
        this.currentStatementNumber = statementController.currentStatementNumber;
        this.historicalReturnState = null;
        if (!(this.historicalState instanceof StatementContinueState)) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", this.historicalState.toString());
        }
        StatementContinueState statementContinueState = (StatementContinueState)this.historicalState;
        int n = statementContinueState.getReceiveState().getRequestNum();
        StatementReceiveState statementReceiveState = new StatementReceiveState(this);
        statementReceiveState.setRequestNum(n);
        StatementContinueState statementContinueState2 = new StatementContinueState(this, statementReceiveState);
        this.historicalState = statementContinueState2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchRows(TDResultSet tDResultSet, int n, int n2, long l, long l2) throws SQLException {
        this.session.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            boolean bl;
            if (tDResultSet.isClosed()) {
                throw ErrorFactory.makeDriverJDBCException("TJ598");
            }
            boolean bl2 = bl = this.session.isStatementPositioningSupported() && this.statement.getResultSetType() == 1004;
            if (l == l2 && !bl) {
                this.log.debug("StatementController.fetchRows fetching sequentially");
            } else {
                TeraResultSetMetaData teraResultSetMetaData = (TeraResultSetMetaData)((Object)tDResultSet.getMetaData());
                StatementReceiveState statementReceiveState = new StatementReceiveState(this);
                statementReceiveState.setHistoricalState(new ReceiveRecordSubState(statementReceiveState, null));
                statementReceiveState.setRequestNum(n);
                statementReceiveState.setActivityType((short)teraResultSetMetaData.getActivityType());
                statementReceiveState.setActivityCount(false, tDResultSet.getActivityCount());
                statementReceiveState.setPrepInfo(teraResultSetMetaData.getPrepInfoParcel());
                statementReceiveState.setCurrentResultSet(tDResultSet);
                StatementContinueState statementContinueState = new StatementContinueState(this, statementReceiveState);
                statementContinueState.setDesiredStatementNumber(n2);
                statementContinueState.setDesiredRowNumber(l);
                this.historicalState = statementContinueState;
            }
            if (this.historicalState instanceof StatementContinueState) {
                ((StatementContinueState)this.historicalState).setCurrentFetchRowNumber(l);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementController.fetchRows: before StatementController.run: hist state=" + this.historicalState);
            }
            this.statement.changeStatementState(2);
            this.run();
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementController.fetchRows: after StatementController.run: hist state=" + this.historicalState);
            }
        }
        finally {
            if (!this.session.isCleanUpStatementsStarted()) {
                this.statement.changeStatementState(1);
            }
            this.session.releaseSessionLock();
        }
    }

    public void suppressResponseCancel() {
        this.statement.suppressResponseCancel();
    }

    public void closingResultSet(boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = this.resultTypeExpected == 2;
        boolean bl4 = this.statement.getResults().areAllResultSetsClosed();
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementController.closingResultSet: bExecQuery=" + bl3 + " bAllClosed=" + bl4 + ", this=" + this);
        }
        if (bl3 || bl4) {
            this.statement.closeRequest(bl, bl2);
        }
    }

    public Object getCloseMutex() {
        return this.statement;
    }

    public int getRowFetchDirection() {
        return this.statement.getFetchDirection();
    }

    public int getRowFetchSize() {
        return this.statement.getFetchSize();
    }

    public int getMaxFetchRows() {
        return this.statement.getMaxRows();
    }

    public int getMaxFetchFieldSize() {
        return this.statement.getMaxFieldSize();
    }

    public boolean registerStatement() {
        return this.session.registerStatement(this.statement);
    }

    public void unregisterStatement() {
        this.session.unregisterStatement(this.statement);
    }

    public SQLException getAndRemoveBatchExceptions() {
        SQLException sQLException = this.m_batchExceptions;
        this.m_batchExceptions = null;
        return sQLException;
    }

    public SQLException getBatchExceptions() {
        return this.m_batchExceptions;
    }

    public void addBatchException(SQLException sQLException) {
        if (this.m_batchExceptions == null) {
            this.m_batchExceptions = sQLException;
        } else {
            this.m_batchExceptions.setNextException(sQLException);
        }
    }

    public int getFailedStatementNumber() {
        return this.m_failedStatementNumber;
    }

    public void setFailedStatementNumber(int n) {
        this.m_failedStatementNumber = n;
    }

    public boolean getFinalizeAutoClose() {
        return this.session.getURLParameters().getFinalizeAutoClose();
    }
}

