/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.security.Security;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeraDriver
implements Driver {
    protected static Log log = new Log("TeraDriver/" + TeraDriver.class.getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    private static final int FORMAT_TEXT = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_CSV = 3;
    private static Calendar DUMMY_CALENDAR;

    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        String string3;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string4 = "";
        String string5 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string6 = string.substring(string5.length());
        int n = string6.indexOf("/");
        if (n >= 0) {
            string3 = string6.substring(0, n);
            string4 = string6.substring(n + 1);
        } else {
            string3 = string6.trim();
            string4 = "";
        }
        if (string3.startsWith("[") && string3.endsWith("]")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (properties != null && properties.containsKey("username")) {
            boolean bl2;
            string2 = (String)properties.remove("username");
            boolean bl3 = bl2 = !properties.containsKey("user");
            if (bl2) {
                properties.setProperty("user", string2);
            }
        }
        URLParameters uRLParameters = new URLParameters(string4, properties);
        string2 = uRLParameters.getUser();
        String string7 = uRLParameters.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string3, string2, string7, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)((Object)connection);
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    public int getMajorVersion() {
        return 17;
    }

    public int getMinorVersion() {
        return 20;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)((Object)clob);
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)((Object)blob);
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        Object object;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)((Object)currentThreadIO.getConnection())).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (object = (TDResultSet)((Object)resultSetArray[i])) == null || ((TDResultSet)object).isClosed()) continue;
            long l = ((TDResultSet)object).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)object).getRequestNumber() + " stmtnum=" + ((TDResultSet)object).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)object).getStatementNumber(), ((TDResultSet)object).getRequestNumber(), l));
            ((TDResultSet)object).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        object = (TDStatement)((Object)tDSession.createStatement());
        StatementController statementController = new StatementController((TDStatement)object, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
            Object var10_11 = null;
            tDSession.releaseSessionLock();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            tDSession.releaseSessionLock();
            throw throwable;
        }
    }

    private static String quoteText(String string) {
        return "\"" + string.replaceAll("[\r\n]+", " ").replaceAll("\"", "\"\"") + "\"";
    }

    private static String quoteCsvText(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= ' ' && c != ',' && c != '\"') continue;
            return "\"" + string.replaceAll("\"", "\"\"") + "\"";
        }
        return string;
    }

    private static String formatValue(int n, boolean bl, int n2, String string, String string2) {
        if (n == 1) {
            return string + " = " + (string2 == null ? "null" : TeraDriver.quoteText(string2));
        }
        if (n == 2) {
            return (bl ? string + "=" : (n2 > 1 ? " " : "")) + (string2 == null ? "null" : string2.replaceAll("[\r\n]+", "\n"));
        }
        return (n2 > 1 ? "," : "") + (string2 == null ? "" : TeraDriver.quoteCsvText(string2));
    }

    private static void printValue(PrintWriter printWriter, int n, boolean bl, int n2, int n3, String string, String string2) {
        boolean bl2;
        String string3 = TeraDriver.formatValue(n, bl, n2, string, string2);
        boolean bl3 = n == 1 || n == 2 && bl;
        boolean bl4 = bl2 = n2 >= n3;
        if (bl3 || bl2) {
            printWriter.println(string3);
        } else {
            printWriter.print(string3);
        }
    }

    private static void printArray(PrintWriter printWriter, int n, boolean bl, String[][] stringArray) {
        int n2;
        String[] stringArray2 = stringArray[0];
        for (int i = n2 = n == 3 ? 0 : 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            for (int j = 1; j <= stringArray3.length; ++j) {
                TeraDriver.printValue(printWriter, n, bl, j, stringArray3.length, stringArray2[j - 1], stringArray3[j - 1]);
            }
        }
    }

    private static void printNameValue(PrintWriter printWriter, int n, String string, String string2) {
        TeraDriver.printArray(printWriter, n, false, new String[][]{{string}, {string2}});
    }

    private static void printProps(PrintWriter printWriter, int n, Properties properties) {
        Map.Entry[] entryArray = properties == null ? new Map.Entry[]{} : properties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                Comparable comparable = (Comparable)entry.getKey();
                Comparable comparable2 = (Comparable)entry2.getKey();
                return comparable.compareTo(comparable2);
            }
        });
        String[][] stringArray = new String[][]{new String[entryArray.length], new String[entryArray.length]};
        for (int i = 0; i < entryArray.length; ++i) {
            stringArray[0][i] = (String)entryArray[i].getKey();
            stringArray[1][i] = (String)entryArray[i].getValue();
        }
        if (n == 1) {
            printWriter.println("(Properties " + (properties == null ? "null" : "" + entryArray.length) + ")");
        }
        TeraDriver.printArray(printWriter, n, true, stringArray);
    }

    private static String formatCsvHeader(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        return resultSetMetaData.getColumnName(n) + (bl ? " " + resultSetMetaData.getColumnTypeName(n) + (resultSetMetaData.getColumnType(n) == -2 ? "(" + resultSetMetaData.getPrecision(n) + ")" : "") + (resultSetMetaData.getColumnType(n) == 3 ? "(" + resultSetMetaData.getPrecision(n) + (resultSetMetaData.getScale(n) != 0 ? "," + resultSetMetaData.getScale(n) : "") + ")" : "") : "");
    }

    private static String formatAsHexDigits(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string + (string2.length() < 2 ? "0" : "") + string2;
        }
        return string;
    }

    private static byte[] parseHexDigits(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = (string.length() & 1) == 1;
        if (bl) {
            throw new IllegalArgumentException("Odd number of hex digits: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private static void printResultSet(PrintWriter printWriter, int n, boolean bl, String string, ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (n == 3) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), null, TeraDriver.formatCsvHeader(resultSetMetaData, n2, bl));
            }
        }
        while (resultSet.next()) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                Comparable<Calendar> comparable;
                String string2 = (string != null ? string + " " : "") + "Row " + resultSet.getRow() + " Column " + n2 + " " + TeraDriver.quoteText(resultSetMetaData.getColumnName(n2)) + " " + resultSetMetaData.getColumnTypeName(n2) + "(" + resultSetMetaData.getPrecision(n2) + ")";
                String string3 = resultSetMetaData.getColumnType(n2) == 2004 || resultSetMetaData.getColumnType(n2) == -2 || resultSetMetaData.getColumnType(n2) == -3 || resultSetMetaData.getColumnType(n2) == -4 ? TeraDriver.formatAsHexDigits(resultSet.getBytes(n2)) : (resultSetMetaData.getColumnType(n2) == 92 ? ((comparable = resultSet.getTimestamp(n2)) == null ? null : ((Timestamp)comparable).toString().substring("1970-01-01 ".length())) : resultSet.getString(n2));
                if (string3 != null && resultSetMetaData.getColumnTypeName(n2).endsWith(" WITH TIME ZONE")) {
                    comparable = Calendar.getInstance();
                    resultSet.getTimestamp(n2, (Calendar)comparable);
                    string3 = string3 + TDPreparedStatement.formatTimeZone(((Calendar)comparable).getTimeZone());
                }
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), string2, string3);
            }
        }
    }

    private static void printUpdateCounts(PrintWriter printWriter, int n, int[] nArray) {
        if (n == 3) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, null, "Update Counts");
        }
        for (int i = 0; i < nArray.length; ++i) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, "Update count " + (i + 1), "" + nArray[i]);
        }
    }

    private static CsvHeader[] parseCsvHeaders(String[] stringArray) {
        CsvHeader[] csvHeaderArray = new CsvHeader[stringArray.length];
        block0: for (int i = 0; i < csvHeaderArray.length; ++i) {
            CsvHeader csvHeader;
            csvHeaderArray[i] = csvHeader = new CsvHeader();
            csvHeader.sHeader = stringArray[i];
            csvHeader.nType = 1111;
            if (csvHeader.sHeader == null) continue;
            for (int j = 0; j < TypeDesc.types.length; ++j) {
                Matcher matcher = Pattern.compile("(?i).* " + TypeDesc.types[j].sTypeName + "(?:\\(([0-9]+)(?:,([0-9]+))?\\))?").matcher(csvHeader.sHeader);
                if (!matcher.matches()) continue;
                csvHeader.sTypeName = TypeDesc.types[j].sTypeName;
                csvHeader.nType = TypeDesc.types[j].nType;
                csvHeader.bTimeZone = csvHeader.sTypeName.endsWith(" WITH TIME ZONE");
                if (matcher.group(2) != null) {
                    csvHeader.nScale = Integer.parseInt(matcher.group(2));
                    continue block0;
                }
                if (matcher.group(1) == null) continue block0;
                csvHeader.nScale = Integer.parseInt(matcher.group(1));
                continue block0;
            }
        }
        return csvHeaderArray;
    }

    private static String[] readCsvRow(PeekReader peekReader) throws IOException {
        if (peekReader.peek() < 0) {
            return null;
        }
        StringList stringList = new StringList();
        stringList.add(null);
        boolean bl = false;
        int n;
        while ((n = peekReader.read()) >= 0) {
            if (bl) {
                if (n != 34) {
                    stringList.append(n);
                    continue;
                }
                if (peekReader.peek() == 34) {
                    stringList.append(peekReader.read());
                    continue;
                }
                bl = false;
                continue;
            }
            if (n == 44) {
                stringList.add(null);
                continue;
            }
            if (n == 34) {
                bl = true;
                continue;
            }
            if (n == 13) continue;
            if (n == 10) {
                return stringList.toStringArray();
            }
            stringList.append(n);
        }
        return stringList.toStringArray();
    }

    private static void bindValue(PreparedStatement preparedStatement, int n, int n2, CsvHeader csvHeader, String string) {
        try {
            if (csvHeader.nType == -6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setByte(n2, Byte.parseByte(string));
                }
            } else if (csvHeader.nType == 5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setShort(n2, Short.parseShort(string));
                }
            } else if (csvHeader.nType == 4) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setInt(n2, Integer.parseInt(string));
                }
            } else if (csvHeader.nType == -5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setLong(n2, Long.parseLong(string));
                }
            } else if (csvHeader.nType == 6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setDouble(n2, Double.parseDouble(string));
                }
            } else if (csvHeader.nType == 3) {
                preparedStatement.setObject(n2, (Object)(string == null ? null : new BigDecimal(string)), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == 2) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                }
            } else if (csvHeader.nType == 2005) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setCharacterStream(n2, (Reader)new StringReader(string), string.length());
                }
            } else if (csvHeader.nType == 2004) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    byte[] byArray = TeraDriver.parseHexDigits(string);
                    preparedStatement.setBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                }
            } else if (csvHeader.nType == -2) {
                preparedStatement.setObject(n2, (Object)TeraDriver.parseHexDigits(string), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == -3 || csvHeader.nType == -4) {
                preparedStatement.setBytes(n2, TeraDriver.parseHexDigits(string));
            } else if (csvHeader.nType == 91) {
                preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
            } else if (csvHeader.nType == 92) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTime(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else if (csvHeader.nType == 93) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTimestamp(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else {
                preparedStatement.setString(n2, string);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error for CSV line " + n + " column " + n2 + " value: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws IOException, SQLException {
        if (stringArray.length == 0) {
            System.err.println("Arguments: Command...");
            System.err.println("-i turns on interactive mode to prompt for commands from System.in");
            System.err.println("prompt:message sets the prompt to the specified message");
            System.err.println("exit stops reading commands from the current input source");
            System.err.println("# begins a comment");
            System.err.println("version prints the Teradata JDBC Driver version");
            System.err.println("echo:message prints the specified message");
            System.err.println("pause waits for a line from System.in");
            System.err.println("prop:name=value sets the property name to value for DriverManager.getConnection");
            System.err.println("props:null specifies null Properties for DriverManager.getConnection (the default)");
            System.err.println("props:new specifies new empty Properties for DriverManager.getConnection");
            System.err.println("props:list prints the Properties for DriverManager.getConnection");
            System.err.println("props:filename reads Properties from the specified file for DriverManager.getConnection");
            System.err.println("verbose:connection (the default) and verbose:-connection controls printing connection status");
            System.err.println("jdbc: prefix calls DriverManager.getConnection for the command");
            System.err.println("input:stdin reads commands from System.in until EOF (interactive Ctrl+Z on Windows)");
            System.err.println("input:filename reads commands from the specified file until EOF");
            System.err.println("output:stdout sends output to System.out (the default)");
            System.err.println("output:filename sends output to specified file");
            System.err.println("format:text formats output as text (the default)");
            System.err.println("format:raw avoids formatting output");
            System.err.println("format:csv formats output as comma-separated values");
            System.err.println("ignore:all ignores all SQLException");
            System.err.println("ignore:none stops for SQLException (the default)");
            System.err.println("ignore:code,code,... ignores SQLException with one of the specified error codes");
            System.err.println("System.setProperty:name=value sets the System property name to value");
            System.err.println("System.getProperty:name prints the specified System property");
            System.err.println("System.getProperties prints the Properties from System.getProperties");
            System.err.println("Security.setProperty:name=value sets the Security property name to value");
            System.err.println("Security.getProperty:name prints the specified Security property");
            System.err.println("getColumns:schemaPattern,tableNamePattern,columnNamePattern prints the result from DatabaseMetaData.getColumns");
            System.err.println("getDatabaseProductVersion prints the return value from DatabaseMetaData.getDatabaseProductVersion");
            System.err.println("getDriverVersion prints the return value from DatabaseMetaData.getDriverVersion");
            System.err.println("getURL prints the return value from DatabaseMetaData.getURL");
            System.err.println("nativeSQL:command calls Connection.nativeSQL for the command");
            System.err.println("csvline:string appends comma-separated values from the specified string for use by a subsequent parameterized SQL request");
            System.err.println("readcsv:filename reads comma-separated values from the specified UTF8-encoded file for use by a subsequent parameterized SQL request");
            System.err.println("verbose:sql and verbose:-sql (the default) controls printing the SQL request before executing");
            System.err.println("verbose:csvtypes and verbose:-csvtypes (the default) controls printing data types in CSV header");
            System.err.println("verbose:updatecounts and verbose:-updatecounts (the default) controls printing update counts after executing");
            System.err.println("verbose:stack and verbose:-stack (the default) controls printing SQLException stack traces");
            System.err.println("agkr:none (the default) does not use the Auto-Generated Key Retrieval feature");
            System.err.println("agkr:generated returns generated keys");
            System.err.println("agkr:index,index,... returns the inserted column values corresponding to the specific column indexes");
            System.err.println("Otherwise the SQL request is executed, using parameter values if previously specified");
            return;
        }
        int n = 1;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        BufferedReader bufferedReader2 = null;
        try {
            PrintWriter printWriter;
            PrintWriter printWriter2 = printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
            try {
                Connection connection = null;
                try {
                    String string = null;
                    Properties properties = null;
                    int[] nArray = null;
                    Object var10_10 = null;
                    Object object = new Integer(2);
                    boolean bl = true;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    int n2 = 0;
                    block28: while (true) {
                        String[] stringArray2;
                        Object object2;
                        String string2 = "";
                        if (bufferedReader2 != null) {
                            if (bufferedReader2 == bufferedReader && string != null) {
                                printWriter2.print(string);
                                printWriter2.flush();
                            }
                            if ((string2 = bufferedReader2.readLine()) == null) {
                                if (bufferedReader2 != bufferedReader) {
                                    bufferedReader2.close();
                                }
                                bufferedReader2 = null;
                            }
                        }
                        if (bufferedReader2 == null) {
                            if (n2 >= stringArray.length) break;
                            string2 = stringArray[n2++];
                        }
                        try {
                            Object var41_60;
                            Object object3;
                            block119: {
                                Object var35_57;
                                void var10_11;
                                if (string2.equals("-i")) {
                                    if (bufferedReader2 != null && bufferedReader2 != bufferedReader) {
                                        bufferedReader2.close();
                                    }
                                    bufferedReader2 = bufferedReader;
                                    string = ">>> ";
                                    continue;
                                }
                                if (string2.startsWith("prompt:")) {
                                    string = string2.substring("prompt:".length());
                                    continue;
                                }
                                if (string2.equals("exit")) {
                                    if (bufferedReader2 != null && bufferedReader2 != bufferedReader) {
                                        bufferedReader2.close();
                                    }
                                    bufferedReader2 = null;
                                    continue;
                                }
                                if (string2.startsWith("#")) continue;
                                if (string2.equals("version")) {
                                    TeraDriver.printNameValue(printWriter2, n, string2, Const.DRIVER_VERSION);
                                    continue;
                                }
                                if (string2.startsWith("echo:")) {
                                    object3 = string2.substring("echo:".length());
                                    printWriter2.println((String)object3);
                                    continue;
                                }
                                if (string2.equals("pause")) {
                                    printWriter2.println("Paused. Press Enter to continue:");
                                    bufferedReader.readLine();
                                    continue;
                                }
                                if (string2.startsWith("prop:")) {
                                    object3 = Pattern.compile("prop:([^=]+)=(.*)").matcher(string2);
                                    if (!((Matcher)object3).matches()) {
                                        throw new IllegalArgumentException(string2);
                                    }
                                    if (properties == null) {
                                        properties = new Properties();
                                    }
                                    properties.setProperty(((Matcher)object3).group(1), ((Matcher)object3).group(2));
                                    continue;
                                }
                                if (string2.startsWith("props:")) {
                                    object3 = string2.substring("props:".length());
                                    if (((String)object3).equals("null")) {
                                        properties = null;
                                        continue;
                                    }
                                    if (((String)object3).equals("new")) {
                                        properties = new Properties();
                                        continue;
                                    }
                                    if (((String)object3).equals("list")) {
                                        TeraDriver.printProps(printWriter2, n, properties);
                                        continue;
                                    }
                                    properties = new Properties();
                                    FileInputStream fileInputStream = new FileInputStream((String)object3);
                                    try {
                                        properties.load(fileInputStream);
                                        object2 = null;
                                        fileInputStream.close();
                                        continue;
                                    }
                                    catch (Throwable throwable) {
                                        object2 = null;
                                        fileInputStream.close();
                                        throw throwable;
                                    }
                                }
                                if (string2.equals("verbose:connection")) {
                                    bl = true;
                                    continue;
                                }
                                if (string2.equals("verbose:-connection")) {
                                    bl = false;
                                    continue;
                                }
                                if (string2.startsWith("jdbc:")) {
                                    if (connection != null) {
                                        object3 = connection;
                                        connection = null;
                                        object3.close();
                                    }
                                    connection = DriverManager.getConnection(string2, properties);
                                    if (!bl) continue;
                                    TeraDriver.printArray(printWriter2, n, false, new String[][]{{"Status", "Remote", "Version", "Session"}, {connection.isClosed() ? "Closed" : "Connected", connection.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), connection.getMetaData().getDatabaseProductVersion(), connection.isClosed() ? null : connection.nativeSQL("{fn teradata_session_number}")}});
                                    continue;
                                }
                                if (string2.startsWith("input:")) {
                                    object3 = string2.substring("input:".length());
                                    if (bufferedReader2 != null && bufferedReader2 != bufferedReader) {
                                        bufferedReader2.close();
                                    }
                                    bufferedReader2 = null;
                                    if (((String)object3).equals("stdin")) {
                                        bufferedReader2 = bufferedReader;
                                        continue;
                                    }
                                    bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)object3), "UTF-8"));
                                    continue;
                                }
                                if (string2.startsWith("output:")) {
                                    object3 = string2.substring("output:".length());
                                    if (printWriter2 != printWriter) {
                                        printWriter2.close();
                                    }
                                    printWriter2 = printWriter;
                                    if (((String)object3).equals("stdout")) continue;
                                    printWriter2 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((String)object3), "UTF-8"), true);
                                    continue;
                                }
                                if (string2.startsWith("format:")) {
                                    object3 = string2.substring("format:".length());
                                    if (((String)object3).equals("text")) {
                                        n = 1;
                                        continue;
                                    }
                                    if (((String)object3).equals("raw")) {
                                        n = 2;
                                        continue;
                                    }
                                    if (!((String)object3).equals("csv")) throw new IllegalArgumentException("Unknown format " + (String)object3);
                                    n = 3;
                                    continue;
                                }
                                if (string2.equals("ignore:all")) {
                                    nArray = new int[]{};
                                    continue;
                                }
                                if (string2.equals("ignore:none")) {
                                    nArray = null;
                                    continue;
                                }
                                if (string2.startsWith("ignore:")) {
                                    object3 = string2.substring("ignore:".length());
                                    String[] stringArray3 = ((String)object3).split(",");
                                    if (stringArray3.length == 0) {
                                        throw new IllegalArgumentException(string2);
                                    }
                                    nArray = new int[stringArray3.length];
                                    int n3 = 0;
                                    while (true) {
                                        if (n3 >= stringArray3.length) continue block28;
                                        nArray[n3] = Integer.parseInt(stringArray3[n3]);
                                        ++n3;
                                    }
                                }
                                if (string2.startsWith("System.setProperty:")) {
                                    object3 = Pattern.compile("System\\.setProperty:([^=]+)=(.*)").matcher(string2);
                                    if (!((Matcher)object3).matches()) {
                                        throw new IllegalArgumentException(string2);
                                    }
                                    System.setProperty(((Matcher)object3).group(1), ((Matcher)object3).group(2));
                                    continue;
                                }
                                if (string2.startsWith("System.getProperty:")) {
                                    object3 = string2.substring("System.getProperty:".length());
                                    TeraDriver.printNameValue(printWriter2, n, (String)object3, System.getProperty((String)object3));
                                    continue;
                                }
                                if (string2.equals("System.getProperties")) {
                                    TeraDriver.printProps(printWriter2, n, System.getProperties());
                                    continue;
                                }
                                if (string2.startsWith("Security.setProperty:")) {
                                    object3 = Pattern.compile("Security\\.setProperty:([^=]+)=(.*)").matcher(string2);
                                    if (!((Matcher)object3).matches()) {
                                        throw new IllegalArgumentException(string2);
                                    }
                                    Security.setProperty(((Matcher)object3).group(1), ((Matcher)object3).group(2));
                                    continue;
                                }
                                if (string2.startsWith("Security.getProperty:")) {
                                    object3 = string2.substring("Security.getProperty:".length());
                                    TeraDriver.printNameValue(printWriter2, n, (String)object3, Security.getProperty((String)object3));
                                    continue;
                                }
                                if (connection == null) {
                                    throw new IllegalArgumentException("No connection available for " + string2);
                                }
                                if (string2.startsWith("getColumns:")) {
                                    object3 = string2.substring("getColumns:".length()).split(",", -1);
                                    if (((String[])object3).length != 3) {
                                        throw new IllegalArgumentException("Invalid arguments for " + string2);
                                    }
                                    for (int i = 0; i < ((String[])object3).length; ++i) {
                                        if (!"null".equals(object3[i])) continue;
                                        object3[i] = null;
                                    }
                                    ResultSet resultSet = connection.getMetaData().getColumns(null, object3[0], object3[1], object3[2]);
                                    try {
                                        TeraDriver.printResultSet(printWriter2, n, bl3, "getColumns", resultSet);
                                        stringArray2 = null;
                                        resultSet.close();
                                        continue;
                                    }
                                    catch (Throwable throwable) {
                                        stringArray2 = null;
                                        resultSet.close();
                                        throw throwable;
                                    }
                                }
                                if (string2.equals("getDatabaseProductVersion")) {
                                    TeraDriver.printNameValue(printWriter2, n, string2, connection.getMetaData().getDatabaseProductVersion());
                                    continue;
                                }
                                if (string2.equals("getDriverVersion")) {
                                    TeraDriver.printNameValue(printWriter2, n, string2, connection.getMetaData().getDriverVersion());
                                    continue;
                                }
                                if (string2.equals("getURL")) {
                                    TeraDriver.printNameValue(printWriter2, n, string2, connection.getMetaData().getURL());
                                    continue;
                                }
                                if (string2.startsWith("nativeSQL:")) {
                                    TeraDriver.printNameValue(printWriter2, n, "nativeSQL", connection.nativeSQL(string2.substring("nativeSQL:".length())));
                                    continue;
                                }
                                if (string2.startsWith("csvline:")) {
                                    object3 = string2.substring("csvline:".length()) + "\n";
                                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object3).getBytes("UTF-8"));
                                    InputStream inputStream = var10_11 == null ? byteArrayInputStream : new SequenceInputStream((InputStream)var10_11, byteArrayInputStream);
                                    continue;
                                }
                                if (string2.startsWith("readcsv:")) {
                                    object3 = string2.substring("readcsv:".length());
                                    FileInputStream fileInputStream = new FileInputStream((String)object3);
                                    InputStream inputStream = var10_11 == null ? fileInputStream : new SequenceInputStream((InputStream)var10_11, fileInputStream);
                                    continue;
                                }
                                if (string2.equals("verbose:sql")) {
                                    bl2 = true;
                                    continue;
                                }
                                if (string2.equals("verbose:-sql")) {
                                    bl2 = false;
                                    continue;
                                }
                                if (string2.equals("verbose:csvtypes")) {
                                    bl3 = true;
                                    continue;
                                }
                                if (string2.equals("verbose:-csvtypes")) {
                                    bl3 = false;
                                    continue;
                                }
                                if (string2.equals("verbose:updatecounts")) {
                                    bl4 = true;
                                    continue;
                                }
                                if (string2.equals("verbose:-updatecounts")) {
                                    bl4 = false;
                                    continue;
                                }
                                if (string2.equals("verbose:stack")) {
                                    bl5 = true;
                                    continue;
                                }
                                if (string2.equals("verbose:-stack")) {
                                    bl5 = false;
                                    continue;
                                }
                                if (string2.equals("agkr:none")) {
                                    object = new Integer(2);
                                    continue;
                                }
                                if (string2.equals("agkr:generated")) {
                                    object = new Integer(1);
                                    continue;
                                }
                                if (string2.startsWith("agkr:")) {
                                    object3 = string2.substring("agkr:".length());
                                    String[] stringArray4 = ((String)object3).split(",");
                                    if (stringArray4.length == 0) {
                                        throw new IllegalArgumentException(string2);
                                    }
                                    int[] nArray2 = new int[stringArray4.length];
                                    object = nArray2;
                                    int n4 = 0;
                                    while (true) {
                                        if (n4 >= stringArray4.length) continue block28;
                                        nArray2[n4] = Integer.parseInt(stringArray4[n4]);
                                        ++n4;
                                    }
                                }
                                if (var10_11 == null) break block119;
                                try {
                                    Object var33_56;
                                    object3 = new PeekReader(new InputStreamReader((InputStream)var10_11, "UTF-8"));
                                    try {
                                        Object var31_55;
                                        String[] stringArray5 = TeraDriver.readCsvRow((PeekReader)object3);
                                        if (stringArray5 == null) {
                                            throw new IllegalArgumentException("CSV header line is missing and no CSV data lines are available");
                                        }
                                        CsvHeader[] csvHeaderArray = TeraDriver.parseCsvHeaders(stringArray5);
                                        if (bl2) {
                                            printWriter2.println(string2);
                                        }
                                        object2 = object instanceof int[] ? connection.prepareStatement(string2, (int[])object) : connection.prepareStatement(string2, (Integer)object);
                                        try {
                                            Object var29_54;
                                            ResultSet resultSet;
                                            boolean bl6;
                                            block120: {
                                                block118: {
                                                    int n5 = 0;
                                                    while (true) {
                                                        if ((stringArray2 = TeraDriver.readCsvRow((PeekReader)object3)) == null && n5 >= 2 || stringArray2 != null && n5 >= 1) {
                                                            object2.addBatch();
                                                        }
                                                        if (stringArray2 == null) {
                                                            bl6 = false;
                                                            if (n5 >= 2) {
                                                                break;
                                                            }
                                                            break block118;
                                                        }
                                                        if (stringArray2.length != csvHeaderArray.length) {
                                                            throw new IllegalArgumentException("CSV data line " + ((PeekReader)object3).lineNumber + " contains " + stringArray2.length + " values instead of the expected " + csvHeaderArray.length + " values");
                                                        }
                                                        for (int i = 0; i < stringArray2.length; ++i) {
                                                            TeraDriver.bindValue((PreparedStatement)object2, ((PeekReader)object3).lineNumber, i + 1, csvHeaderArray[i], stringArray2[i]);
                                                        }
                                                        ++n5;
                                                    }
                                                    int[] nArray3 = object2.executeBatch();
                                                    if (bl4) {
                                                        TeraDriver.printUpdateCounts(printWriter2, n, nArray3);
                                                    }
                                                    break block120;
                                                }
                                                bl6 = object2.execute();
                                                if (!bl6 && bl4) {
                                                    TeraDriver.printNameValue(printWriter2, n, "Update count", "" + object2.getUpdateCount());
                                                }
                                            }
                                            if (bl6) {
                                                Object var27_53;
                                                resultSet = object2.getResultSet();
                                                try {
                                                    TeraDriver.printResultSet(printWriter2, n, bl3, null, resultSet);
                                                    var27_53 = null;
                                                    resultSet.close();
                                                }
                                                catch (Throwable throwable) {
                                                    var27_53 = null;
                                                    resultSet.close();
                                                    throw throwable;
                                                }
                                            }
                                            resultSet = object2.getGeneratedKeys();
                                            try {
                                                TeraDriver.printResultSet(printWriter2, n, bl3, object instanceof int[] ? "Inserted" : "Generated", resultSet);
                                                var29_54 = null;
                                                resultSet.close();
                                            }
                                            catch (Throwable throwable) {
                                                var29_54 = null;
                                                resultSet.close();
                                                throw throwable;
                                            }
                                            var31_55 = null;
                                            object2.close();
                                        }
                                        catch (Throwable throwable) {
                                            var31_55 = null;
                                            object2.close();
                                            throw throwable;
                                        }
                                        var33_56 = null;
                                        ((PushbackReader)object3).close();
                                    }
                                    catch (Throwable throwable) {
                                        var33_56 = null;
                                        ((PushbackReader)object3).close();
                                        throw throwable;
                                    }
                                    var35_57 = null;
                                    Object var10_14 = null;
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    var35_57 = null;
                                    Object var10_15 = null;
                                    throw throwable;
                                }
                            }
                            object3 = connection.createStatement();
                            try {
                                if (bl2) {
                                    printWriter2.println(string2);
                                }
                                boolean bl7 = object instanceof int[] ? object3.execute(string2, (int[])object) : object3.execute(string2, (Integer)object);
                                while (bl7 || object3.getUpdateCount() != -1) {
                                    Object var39_59;
                                    ResultSet resultSet;
                                    if (bl7) {
                                        Object var37_58;
                                        resultSet = object3.getResultSet();
                                        try {
                                            TeraDriver.printResultSet(printWriter2, n, bl3, null, resultSet);
                                            var37_58 = null;
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable) {
                                            var37_58 = null;
                                            resultSet.close();
                                            throw throwable;
                                        }
                                    }
                                    if (bl4) {
                                        TeraDriver.printNameValue(printWriter2, n, "Update count", "" + object3.getUpdateCount());
                                    }
                                    resultSet = object3.getGeneratedKeys();
                                    try {
                                        TeraDriver.printResultSet(printWriter2, n, bl3, object instanceof int[] ? "Inserted" : "Generated", resultSet);
                                        var39_59 = null;
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable) {
                                        var39_59 = null;
                                        resultSet.close();
                                        throw throwable;
                                    }
                                    bl7 = object3.getMoreResults();
                                }
                                var41_60 = null;
                                object3.close();
                                continue;
                            }
                            catch (Throwable throwable) {
                                var41_60 = null;
                                object3.close();
                                throw throwable;
                            }
                        }
                        catch (SQLException sQLException) {
                            int n6;
                            boolean bl8 = nArray != null && nArray.length == 0;
                            for (n6 = 0; !bl8 && nArray != null && n6 < nArray.length; ++n6) {
                                if (sQLException.getErrorCode() != nArray[n6]) continue;
                                bl8 = true;
                            }
                            if (bl8) {
                                TeraDriver.printNameValue(printWriter2, n, "Ignoring", "" + sQLException);
                                continue;
                            }
                            n6 = 0;
                            for (object2 = sQLException; object2 != null; ++n6, object2 = ((SQLException)object2).getNextException()) {
                            }
                            int n7 = 1;
                            SQLException sQLException2 = sQLException;
                            while (sQLException2 != null) {
                                stringArray2 = new StringWriter();
                                sQLException2.printStackTrace(new PrintWriter((Writer)stringArray2, true));
                                printWriter2.println("SQLException " + n7 + " of " + n6 + ": " + (bl5 ? "" + stringArray2 : "" + sQLException2));
                                ++n7;
                                sQLException2 = sQLException2.getNextException();
                            }
                            throw sQLException;
                        }
                        break;
                    }
                    Object var43_69 = null;
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var43_70 = null;
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                Object var45_72 = null;
                if (printWriter2 != printWriter) {
                    printWriter2.close();
                }
            }
            catch (Throwable throwable) {
                Object var45_73 = null;
                if (printWriter2 == printWriter) throw throwable;
                printWriter2.close();
                throw throwable;
            }
            Object var47_75 = null;
            if (bufferedReader2 == null) return;
            if (bufferedReader2 == bufferedReader) return;
            bufferedReader2.close();
            return;
        }
        catch (Throwable throwable) {
            Object var47_76 = null;
            if (bufferedReader2 == null) throw throwable;
            if (bufferedReader2 == bufferedReader) throw throwable;
            bufferedReader2.close();
            throw throwable;
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
        DUMMY_CALENDAR = Calendar.getInstance();
    }

    private static class StringList
    extends ArrayList {
        public String[] toStringArray() {
            return this.toArray(new String[0]);
        }

        public void append(int n) {
            int n2 = this.size() - 1;
            String string = (String)this.get(n2);
            if (string == null) {
                string = "";
            }
            this.set(n2, string + (char)n);
        }
    }

    private static class PeekReader
    extends PushbackReader {
        public int lineNumber = 0;

        public PeekReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n = super.read();
            if (n == 10) {
                ++this.lineNumber;
            }
            return n;
        }

        public int peek() throws IOException {
            int n = super.read();
            if (n >= 0) {
                this.unread(n);
            }
            return n;
        }
    }

    private static class CsvHeader {
        public String sHeader;
        public int nType;
        public String sTypeName;
        public boolean bTimeZone;
        public int nScale;

        private CsvHeader() {
        }
    }

    private static class TypeDesc {
        public String sTypeName;
        public int nType;
        public static TypeDesc[] types = new TypeDesc[]{new TypeDesc("BYTEINT", -6), new TypeDesc("SMALLINT", 5), new TypeDesc("INTEGER", 4), new TypeDesc("BIGINT", -5), new TypeDesc("FLOAT", 6), new TypeDesc("DECIMAL", 3), new TypeDesc("NUMBER", 2), new TypeDesc("CLOB", 2005), new TypeDesc("CHAR", 1), new TypeDesc("VARCHAR", 12), new TypeDesc("LONGVARCHAR", -1), new TypeDesc("BLOB", 2004), new TypeDesc("BYTE", -2), new TypeDesc("VARBYTE", -3), new TypeDesc("LONGVARBYTE", -4), new TypeDesc("DATE", 91), new TypeDesc("TIME", 92), new TypeDesc("TIME WITH TIME ZONE", 92), new TypeDesc("TIMESTAMP", 93), new TypeDesc("TIMESTAMP WITH TIME ZONE", 93)};

        private TypeDesc(String string, int n) {
            this.sTypeName = string;
            this.nType = n;
        }
    }
}

