/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import com.sap.db.util.BufferUtils;
import java.nio.ByteBuffer;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidFrameException;
import org.java_websocket.framing.ControlFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.util.ByteBufferUtils;
import org.java_websocket.util.Charsetfunctions;

public class CloseFrame
extends ControlFrame {
    public static final int NORMAL = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int PROTOCOL_ERROR = 1002;
    public static final int REFUSE = 1003;
    public static final int NOCODE = 1005;
    public static final int ABNORMAL_CLOSE = 1006;
    public static final int NO_UTF8 = 1007;
    public static final int POLICY_VALIDATION = 1008;
    public static final int TOOBIG = 1009;
    public static final int EXTENSION = 1010;
    public static final int UNEXPECTED_CONDITION = 1011;
    public static final int TLS_ERROR = 1015;
    public static final int NEVER_CONNECTED = -1;
    public static final int BUGGYCLOSE = -2;
    public static final int FLASHPOLICY = -3;
    private int code;
    private String reason;

    public CloseFrame() {
        super(Framedata.Opcode.CLOSING);
        this.setReason("");
        this.setCode(1000);
    }

    public void setCode(int code) {
        this.code = code;
        if (code == 1015) {
            this.code = 1005;
            this.reason = "";
        }
        this.updatePayload();
    }

    public void setReason(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.reason = reason;
        this.updatePayload();
    }

    public int getCloseCode() {
        return this.code;
    }

    public String getMessage() {
        return this.reason;
    }

    @Override
    public String toString() {
        return super.toString() + "code: " + this.code;
    }

    @Override
    public void isValid() throws InvalidDataException {
        super.isValid();
        if (this.code == 1007 && this.reason == null) {
            throw new InvalidDataException(1007);
        }
        if (this.code == 1005 && 0 < this.reason.length()) {
            throw new InvalidDataException(1002, "A close frame must have a closecode if it has a reason");
        }
        if (this.code > 1011 && this.code < 3000 && this.code != 1015) {
            throw new InvalidDataException(1002, "Trying to send an illegal close code!");
        }
        if (this.code == 1006 || this.code == 1015 || this.code == 1005 || this.code > 4999 || this.code < 1000 || this.code == 1004) {
            throw new InvalidFrameException("closecode must not be sent over the wire: " + this.code);
        }
    }

    @Override
    public void setPayload(ByteBuffer payload) {
        this.code = 1005;
        this.reason = "";
        BufferUtils.mark(payload);
        if (payload.remaining() == 0) {
            this.code = 1000;
        } else if (payload.remaining() == 1) {
            this.code = 1002;
        } else {
            if (payload.remaining() >= 2) {
                ByteBuffer bb = ByteBuffer.allocate(4);
                BufferUtils.position(bb, 2);
                bb.putShort(payload.getShort());
                BufferUtils.position(bb, 0);
                this.code = bb.getInt();
            }
            BufferUtils.reset(payload);
            try {
                int mark = payload.position();
                try {
                    BufferUtils.position(payload, payload.position() + 2);
                    this.reason = Charsetfunctions.stringUtf8(payload);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidDataException(1007);
                }
                finally {
                    BufferUtils.position(payload, mark);
                }
            }
            catch (InvalidDataException e) {
                this.code = 1007;
                this.reason = null;
            }
        }
    }

    private void updatePayload() {
        byte[] by = Charsetfunctions.utf8Bytes(this.reason);
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(this.code);
        BufferUtils.position(buf, 2);
        ByteBuffer pay = ByteBuffer.allocate(2 + by.length);
        pay.put(buf);
        pay.put(by);
        BufferUtils.rewind(pay);
        super.setPayload(pay);
    }

    @Override
    public ByteBuffer getPayloadData() {
        if (this.code == 1005) {
            return ByteBufferUtils.getEmptyByteBuffer();
        }
        return super.getPayloadData();
    }
}

