/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaSystem;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class SessionPool {
    private final Tracer _tracer;
    private final Map<SiteTypeVolumeID, Session> _sessions;
    private final AtomicReference<Session> _anchorSession;
    private final AtomicReference<Session> _primarySession;
    private final AtomicReference<HanaSystem> _system;
    private final AtomicReference<Session> _lastExecutedSession;

    public SessionPool(Tracer tracer) {
        this._tracer = tracer;
        this._sessions = new ConcurrentHashMap<SiteTypeVolumeID, Session>();
        this._anchorSession = new AtomicReference();
        this._primarySession = new AtomicReference();
        this._system = new AtomicReference();
        this._lastExecutedSession = new AtomicReference();
    }

    public Map<SiteTypeVolumeID, Session> getSessions() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public Session getSession(SiteTypeVolumeID siteTypeVolumeID) {
        Session session = this._sessions.get(siteTypeVolumeID);
        if (session == null) {
            SiteTypeVolumeID noneSite;
            SiteTypeVolumeID primarySite;
            int volumeID = siteTypeVolumeID.getVolumeID();
            if (this._system.get().getSiteCount() == 1) {
                for (SiteTypeVolumeID aSiteTypeVolumeID : this._sessions.keySet()) {
                    if (aSiteTypeVolumeID.getVolumeID() != volumeID) continue;
                    return this._sessions.get(aSiteTypeVolumeID);
                }
            } else if (this._system.get().getSiteCount() > 1 && (siteTypeVolumeID.getSiteType() == Location.SiteType.NONE ? (session = this._sessions.get(primarySite = new SiteTypeVolumeID(Location.SiteType.PRIMARY, volumeID))) != null : siteTypeVolumeID.getSiteType() == Location.SiteType.PRIMARY && (session = this._sessions.get(noneSite = new SiteTypeVolumeID(Location.SiteType.NONE, volumeID))) != null)) {
                return session;
            }
        }
        return session;
    }

    public Session getAnchorSession() {
        return this._anchorSession.get();
    }

    public Session getPrimarySession() {
        return this._primarySession.get();
    }

    public void setPrimarySession(Session primarySession) {
        Session currentPrimarySession = this._primarySession.get();
        if (currentPrimarySession == null) {
            this._primarySession.set(primarySession);
        } else if (currentPrimarySession != primarySession && !primarySession.isHintRouted()) {
            this._primarySession.set(primarySession);
            this.setSendSessionContextFlag();
            if (this._tracer.on()) {
                this._tracer.printDistribution("Primary session changed to " + this.getDisplayString(primarySession));
            }
        }
    }

    public HanaSystem getSystem() {
        return this._system.get();
    }

    public Session getLastExecutedSession() {
        return this._lastExecutedSession.get();
    }

    public void addSession(Session session) throws SQLException {
        SiteVolumeID siteVolumeID = session.getSiteVolumeID();
        Session currentPrimarySession = this._primarySession.get();
        if (!session.isHintRouted()) {
            if (this._anchorSession.compareAndSet(null, session) && this._tracer.on()) {
                this._tracer.printDistribution("Anchor session changed to " + this.getDisplayString(session));
            }
            if (currentPrimarySession == null) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution("Primary session changed to " + this.getDisplayString(session));
                }
            } else if (currentPrimarySession.getSiteVolumeID().equals(siteVolumeID)) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution("Primary session changed to " + this.getDisplayString(session));
                }
            }
        }
        this._system.compareAndSet(null, session.getSystem());
        this._sessions.put(new SiteTypeVolumeID(this._system.get().getSiteType(siteVolumeID.getSiteID()), siteVolumeID.getVolumeID()), session);
    }

    public void removeSession(ConnectionSapDB connection, SiteTypeVolumeID siteTypeVolumeID) throws SQLException {
        Session session = this._sessions.get(siteTypeVolumeID);
        if (session == null || !session.isConnected()) {
            this._sessions.remove(siteTypeVolumeID);
            return;
        }
        if (connection != null) {
            try {
                HRequestPacket requestPacket = connection.initDisconnect(session);
                connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._sessions.remove(siteTypeVolumeID);
        }
        session.destroy();
    }

    public void setSendSessionContextFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionContextFlag();
        }
    }

    public void setSendSessionVariablesFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionVariablesFlag();
        }
    }

    public void setSendClientInfoFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendClientInfoFlag();
        }
    }

    public void releaseAll(ConnectionSapDB connection) {
        this._releaseSessions(connection, false);
        this._sessions.clear();
        this._anchorSession.set(null);
    }

    public void releaseAllHintRouted(ConnectionSapDB connection) {
        this._releaseSessions(connection, true);
    }

    public void setLastExecutedSession(Session session) {
        this._lastExecutedSession.set(session);
    }

    public String getDisplayString(Session session) {
        return session.toString() + (session == this._anchorSession.get() ? " ANCHOR" : "") + (session == this._primarySession.get() ? " PRIMARY" : "");
    }

    private void _releaseSessions(ConnectionSapDB connection, boolean hintRoutedOnly) {
        HashSet<SiteTypeVolumeID> siteTypeVolumeIDSet = new HashSet<SiteTypeVolumeID>(this._sessions.keySet());
        for (SiteTypeVolumeID siteTypeVolumeID : siteTypeVolumeIDSet) {
            Session session = this._sessions.get(siteTypeVolumeID);
            if (session == null || !session.isConnected()) {
                this._sessions.remove(siteTypeVolumeID);
                continue;
            }
            if (hintRoutedOnly && !session.isHintRouted()) continue;
            try {
                this.removeSession(connection, siteTypeVolumeID);
            }
            catch (SQLException sQLException) {}
        }
    }

    public int getNumberOfLocations() {
        return this._system.get().getNumberOfLocations();
    }
}

