/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.SecureStoreKey;
import com.sap.db.jdbc.SecureStoreLoginInformation;
import com.sap.db.jdbc.SecureStoreRecord;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.DES;
import com.sap.db.util.PlatformUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@Immutable
final class SecureStore {
    private static final char[] DEFAULT_KEY = new char[24];

    private SecureStore() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static String getVirtualHostNameFromIniFile(String iniFilePath) throws SQLException {
        return SecureStore._getVirtualHostNameFromIniFile(iniFilePath);
    }

    static SecureStoreLoginInformation getLoginInformation(Tracer tracer, String key, String virtualHostName) throws SQLException {
        return SecureStore._getLoginInformation(tracer, key, virtualHostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _getVirtualHostNameFromIniFile(String iniFilePath) throws SQLException {
        int index;
        if (PlatformUtils.isWindows()) {
            return "";
        }
        iniFilePath = iniFilePath + "install/installation.ini";
        String last = "";
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(iniFilePath));
            while ((line = br.readLine()) != null) {
                if (!line.contains("Hostname=")) continue;
                last = line;
                break;
            }
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        if ((index = last.indexOf("Hostname=")) == -1) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestoreinvalidinifile", iniFilePath);
        }
        return last.substring(index + 9).trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SecureStoreLoginInformation _getLoginInformation(Tracer tracer, String key, String virtualHostName) throws SQLException {
        String dbName;
        String dbPasswd;
        Map<String, SecureStoreRecord> recordMap = null;
        if (key == null || key.trim().isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.invalidsecurestorekey", key);
        }
        key = key.toUpperCase(Locale.ENGLISH);
        String separator = "/";
        String keyPrefix = "HDB/" + key + separator;
        String user = keyPrefix + "DB_USER";
        String passwd = keyPrefix + "DB_PASSWORD";
        String environment = keyPrefix + "DB_CON_ENV";
        String database = keyPrefix + "DB_DATABASE_NAME";
        String userProfilePath = SecureStore._getUserProfilePath(tracer, virtualHostName);
        String keyFilePath = SecureStore._getKeyFilePath(userProfilePath);
        String dataFilePath = SecureStore._getDataFilePath(userProfilePath);
        if (tracer.on()) {
            tracer.printMessage("The key file is: " + keyFilePath + "\nThe data file is: " + dataFilePath);
        }
        int attemps = 0;
        while (attemps < 5) {
            try {
                recordMap = SecureStore._readDataFile(dataFilePath);
                break;
            }
            catch (IOException e) {
                if (++attemps >= 5) throw SQLExceptionSapDB.newInstance("error.connection.erroropeningsecurestoredatafile", dataFilePath);
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException e1) {
                    throw SQLExceptionSapDB.newInstance((Throwable)e1, "error.connection.interruptedopeningsecurestoredatafile", new String[0]);
                }
            }
        }
        SecureStoreKey secureStoreKey = SecureStore._readKeyFile(tracer, keyFilePath);
        SecureStoreRecord userRecord = recordMap.get(user);
        if (userRecord == null) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestoreusernamenotfound", dataFilePath);
        }
        SecureStoreRecord passwdRecord = recordMap.get(passwd);
        if (passwdRecord == null) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorepasswdnotfound", dataFilePath);
        }
        SecureStoreRecord locationRecord = recordMap.get(environment);
        if (locationRecord == null) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorelocationnotfound", dataFilePath);
        }
        SecureStoreRecord dbNameRecord = recordMap.get(database);
        if (userRecord.isDeleted() == 1) throw SQLExceptionSapDB.newInstance("error.connection.securestoredeletedusername", dataFilePath);
        String dbUsername = String.valueOf(userRecord.getData());
        if (dbUsername == null || dbUsername.trim().isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorenullusername", dataFilePath);
        }
        if (passwdRecord.isDeleted() == 1) throw SQLExceptionSapDB.newInstance("error.connection.securestoredeletedpasswd", dataFilePath);
        try {
            dbPasswd = SecureStore._getPasswd(passwdRecord, secureStoreKey);
        }
        catch (SQLException e) {
            if (tracer.on()) {
                tracer.printThrowable(e, "Caught exception while getting password, trying default key");
            }
            SecureStoreKey defaultSecStoreKey = new SecureStoreKey("", "", "", 1, DEFAULT_KEY);
            try {
                dbPasswd = SecureStore._getPasswd(passwdRecord, defaultSecStoreKey);
            }
            catch (SQLException e1) {
                if (!tracer.on()) throw SQLExceptionSapDB.newInstance((Throwable)e1, "error.connection.securestoredecryptionerror", keyFilePath);
                tracer.printThrowable(e1, "Could not get the password even with the default key");
                throw SQLExceptionSapDB.newInstance((Throwable)e1, "error.connection.securestoredecryptionerror", keyFilePath);
            }
        }
        if (dbPasswd == null || dbPasswd.trim().isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorenullpasswd", dataFilePath);
        }
        if (locationRecord.isDeleted() == 1) throw SQLExceptionSapDB.newInstance("error.connection.securestoredeletedlocation", dataFilePath);
        String dbLocation = String.valueOf(locationRecord.getData());
        if (dbLocation == null || dbLocation.trim().isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorenulllocation", dataFilePath);
        }
        if (dbNameRecord != null) {
            if (dbNameRecord.isDeleted() == 1) throw SQLExceptionSapDB.newInstance("error.connection.securestoredeleteddatabasenname", dataFilePath);
            dbName = String.valueOf(dbNameRecord.getData());
            if (dbName == null || dbName.trim().isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestorenulldatabasenname", dataFilePath);
            }
        } else {
            dbName = "";
        }
        if (!tracer.on()) return new SecureStoreLoginInformation(dbUsername, dbPasswd, dbLocation, dbName);
        tracer.printMessage("The username is: " + dbUsername + "\nThe location is: " + dbLocation + (dbName.isEmpty() ? "" : "\nThe database is: " + dbName));
        return new SecureStoreLoginInformation(dbUsername, dbPasswd, dbLocation, dbName);
    }

    private static String _getUserProfilePath(Tracer tracer, String virtualHostName) throws SQLException {
        String localMachine;
        StringBuilder profilePath = new StringBuilder();
        String hdbUseIdent = System.getenv("HDB_USE_IDENT");
        if (!SecureStore._isIdentValid(hdbUseIdent)) {
            hdbUseIdent = "";
        }
        try {
            localMachine = PlatformUtils.getMachineName();
        }
        catch (UnknownHostException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.securestoreunknownhost", new String[0]);
        }
        if (PlatformUtils.isWindows()) {
            String allUsersDirectory = System.getenv("ALLUSERSPROFILE");
            if (allUsersDirectory == null || allUsersDirectory.trim().isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreallusersprofile", new String[0]);
            }
            profilePath.append(allUsersDirectory);
            profilePath.append(File.separatorChar);
            profilePath.append(".hdb");
            profilePath.append(File.separatorChar);
            if (!hdbUseIdent.isEmpty()) {
                profilePath.append(hdbUseIdent);
            } else {
                profilePath.append(localMachine);
            }
            profilePath.append(File.separatorChar);
            String sid = PlatformUtils.getWindowsSID();
            if (sid == null) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreunknownsid", new String[0]);
            }
            profilePath.append(sid);
        } else {
            if (!virtualHostName.isEmpty() && !hdbUseIdent.isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreidenterror", virtualHostName, hdbUseIdent);
            }
            String homeDirectory = System.getenv("HOME");
            if (homeDirectory == null || homeDirectory.trim().isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestorehomedirectory", new String[0]);
            }
            profilePath.append(homeDirectory);
            profilePath.append(File.separatorChar);
            profilePath.append(".hdb");
            profilePath.append(File.separatorChar);
            if (!hdbUseIdent.isEmpty()) {
                profilePath.append(hdbUseIdent);
            } else if (!virtualHostName.isEmpty()) {
                profilePath.append(virtualHostName);
            } else {
                profilePath.append(localMachine);
            }
        }
        if (tracer.on()) {
            tracer.printMessage("The Profile Path is " + profilePath.toString());
        }
        return profilePath.toString();
    }

    private static boolean _isIdentValid(String hdbUseIdent) {
        if (hdbUseIdent == null || hdbUseIdent.trim().isEmpty()) {
            return false;
        }
        for (int i = 0; i < hdbUseIdent.length(); ++i) {
            char ch = hdbUseIdent.charAt(i);
            if (Character.isDigit(ch) || Character.isLetter(ch) || ch == '-' || ch == '_') continue;
            return false;
        }
        return true;
    }

    private static String _getKeyFilePath(String userProfilePath) {
        return userProfilePath + File.separatorChar + "SSFS_HDB.KEY";
    }

    private static String _getDataFilePath(String userProfilePath) {
        return userProfilePath + File.separatorChar + "SSFS_HDB.DAT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecureStoreKey _readKeyFile(Tracer tracer, String keyFilePath) throws SQLException {
        String hostname;
        String username;
        String preamble;
        byte[] buffer;
        File keyFile = new File(keyFilePath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(keyFile);
            buffer = new byte[(int)keyFile.length()];
            if (fis.read(buffer) == -1) {
                SecureStoreKey secStoreKey;
                if (tracer.on()) {
                    tracer.printMessage("Unable to read the Secure Store key file: " + keyFilePath + " ,will use default key");
                }
                SecureStoreKey secureStoreKey = secStoreKey = new SecureStoreKey("", "", "", 1, DEFAULT_KEY);
                return secureStoreKey;
            }
        }
        catch (IOException e) {
            SecureStoreKey secStoreKey;
            if (tracer.on()) {
                tracer.printMessage("Unable to read the Secure Store key file: " + keyFilePath + " ,will use default key");
            }
            SecureStoreKey secureStoreKey = secStoreKey = new SecureStoreKey("", "", "", 1, DEFAULT_KEY);
            return secureStoreKey;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (buffer.length != 92) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptkeyfilelength", keyFilePath);
        }
        char[] key = new char[24];
        try {
            preamble = new String(buffer, 0, 11, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SecureStoreKey secStoreKey = new SecureStoreKey("", "", "", 1, DEFAULT_KEY);
            if (tracer.on()) {
                tracer.printMessage("Unable to use the Secure Store key since UTF-8 encoding isn't supported, will use default key");
            }
            return secStoreKey;
        }
        byte keyType = buffer[11];
        if (!SecureStore._checkKeyFile(preamble, keyType)) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptkeyfile", keyFilePath);
        }
        int i = 0;
        int j = 12;
        while (i < 24) {
            key[i] = (char)buffer[j];
            ++i;
            ++j;
        }
        try {
            username = new String(buffer, 44, 24, "UTF-8").trim();
            hostname = new String(buffer, 67, 24, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException e) {
            SecureStoreKey secStoreKey = new SecureStoreKey("", "", "", 1, DEFAULT_KEY);
            if (tracer.on()) {
                tracer.printMessage("Unable to use the Secure Store key since UTF-8 encoding isn't supported, will use default key");
            }
            return secStoreKey;
        }
        SecureStoreKey secStoreKey = new SecureStoreKey(preamble, username, hostname, keyType, key);
        return secStoreKey;
    }

    private static boolean _checkKeyFile(String preamble, int keyType) {
        return preamble.equals("RSecSSFsKey") && keyType == 1;
    }

    private static Map<String, SecureStoreRecord> _readDataFile(String dataFilePath) throws IOException, SQLException {
        File dataFile = new File(dataFilePath);
        byte[] buffer = new byte[(int)dataFile.length()];
        if (!dataFile.exists()) {
            throw new FileNotFoundException("Secure Store data file not found: " + dataFilePath);
        }
        HashMap<String, SecureStoreRecord> recordMap = new HashMap<String, SecureStoreRecord>();
        RandomAccessFile ran = new RandomAccessFile(dataFile, "r");
        try {
            if (ran.read(buffer) == -1) {
                throw new IOException("Cannot read the Secure Store data file: " + dataFilePath);
            }
        }
        catch (IOException e) {
            throw new IOException("Cannot read the Secure Store data file: " + dataFilePath);
        }
        finally {
            try {
                if (ran != null) {
                    ran.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (buffer.length < 176) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptdatafilelength", dataFilePath);
        }
        int bufPosition = 0;
        int remaining = buffer.length;
        char[] lengthValues = new char[4];
        while (bufPosition < buffer.length) {
            String hostname;
            String username;
            String recordIdentifier;
            int i;
            String preamble;
            if (remaining < 176) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptdatafilerecordlength", dataFilePath);
            }
            try {
                preamble = new String(buffer, bufPosition, 12, "UTF-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.securestorenoutf8", dataFilePath);
            }
            for (i = 0; i < 4; ++i) {
                lengthValues[i] = (char)buffer[bufPosition + i + 12];
            }
            byte recordType = buffer[bufPosition + 16];
            int recordLength = SecureStore._getRecordLength(lengthValues);
            if (!SecureStore._checkDataFile(preamble, recordType, recordLength)) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptdatafile", dataFilePath);
            }
            try {
                recordIdentifier = new String(buffer, bufPosition + 24, 64, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.securestorenoutf8", dataFilePath);
            }
            byte[] timestamp = new byte[8];
            for (i = 0; i < 8; ++i) {
                timestamp[i] = buffer[bufPosition + i + 88];
            }
            try {
                username = new String(buffer, bufPosition + 96, 24, "UTF-8");
                hostname = new String(buffer, bufPosition + 120, 24, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.securestorenoutf8", dataFilePath);
            }
            byte isDeleted = buffer[bufPosition + 144];
            byte isPlainText = buffer[bufPosition + 145];
            byte isBinary = buffer[bufPosition + 146];
            byte[] hmac = new byte[20];
            System.arraycopy(buffer, bufPosition + 156, hmac, 0, hmac.length);
            if (isDeleted != 1) {
                char[] data;
                if (isPlainText == 1 || isBinary == 1) {
                    try {
                        data = new String(buffer, bufPosition + 176, recordLength - 176, "UTF-8").toCharArray();
                    }
                    catch (UnsupportedEncodingException e) {
                        throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.securestorenoutf8", dataFilePath);
                    }
                } else {
                    data = new char[recordLength - 176];
                    int encryptedLength = recordLength - 176;
                    if (encryptedLength % 128 != 0) {
                        throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptdatafileencryptedlength", dataFilePath);
                    }
                    i = 0;
                    while (encryptedLength > 0) {
                        data[i] = (char)buffer[bufPosition + 176 + i];
                        --encryptedLength;
                        ++i;
                    }
                }
                if (!SecureStore._checkHmac(hmac, buffer, bufPosition, data)) {
                    throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptdatafilehmac", dataFilePath);
                }
                int payloadLength = recordLength - 176;
                SecureStoreRecord secStoreRecord = new SecureStoreRecord(preamble, timestamp, username, hostname, recordType, recordLength, recordIdentifier, isDeleted, isPlainText, isBinary, hmac, payloadLength, data);
                recordMap.put(recordIdentifier.trim(), secStoreRecord);
            }
            bufPosition += recordLength;
            remaining -= recordLength;
        }
        return recordMap;
    }

    private static boolean _checkDataFile(String preamble, int recordType, int recordLength) {
        return preamble.equals("RSecSSFsData") && recordType == 1 && recordLength >= 176 && recordLength <= 98640;
    }

    private static boolean _checkHmac(byte[] hmac, byte[] buffer, int bufPosition, char[] data) throws SQLException {
        Mac mac;
        int i;
        char[] hmacKey = new char[]{'\u0003', 'A', '\u0005', 'W', '\u0017', '\u00c4', '\u0017', 'A', ',', '`', '[', 'z', '\u00d5', '\u0005', '\u00f3', '\u0003'};
        byte[] byteKey = new byte[hmacKey.length];
        byte[] input = new byte[132 + data.length];
        System.arraycopy(buffer, bufPosition + 24, input, 0, 132);
        for (i = 0; i < data.length; ++i) {
            input[132 + i] = (byte)data[i];
        }
        DES.rsecedv1_encode_default_v1(hmacKey, hmacKey.length);
        for (i = 0; i < hmacKey.length; ++i) {
            byteKey[i] = (byte)hmacKey[i];
        }
        SecretKeySpec keySpec = new SecretKeySpec(byteKey, "HmacSHA1");
        try {
            mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorenohmac", new String[0]);
        }
        try {
            mac.init(keySpec);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.wrongsecurestorekey", new String[0]);
        }
        byte[] result = mac.doFinal(input);
        for (i = 0; i < result.length; ++i) {
            if (result[i] == hmac[i]) continue;
            return false;
        }
        return true;
    }

    private static String _getPasswd(SecureStoreRecord passwdRecord, SecureStoreKey secureStoreKey) throws SQLException {
        char[] key = secureStoreKey.getKey();
        char[] buffer = passwdRecord.getData();
        DES.RSecPDecrypt(key, buffer, buffer.length);
        if (buffer.length == 0 || buffer.length % 128 != 0) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorepasswdlength", new String[0]);
        }
        if (!SecureStore._checkSha1EncryptedRecord(buffer)) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorecorruptdatafilesha1", new String[0]);
        }
        char[] lengthValues = new char[4];
        for (int i = 0; i < 4; ++i) {
            lengthValues[i] = buffer[i + 8];
        }
        int passwdLength = SecureStore._getRecordLength(lengthValues);
        String passwd = new String(buffer, 32, passwdLength);
        return passwd;
    }

    private static boolean _checkSha1EncryptedRecord(char[] buffer) throws SQLException {
        MessageDigest md;
        int i;
        byte[] byteData = new byte[buffer.length];
        for (i = 0; i < byteData.length; ++i) {
            byteData[i] = (byte)buffer[i];
        }
        byte[] input = new byte[buffer.length - 20];
        System.arraycopy(byteData, 0, input, 0, 12);
        System.arraycopy(byteData, 32, input, 12, 96);
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorenosha1", new String[0]);
        }
        byte[] result = md.digest(input);
        for (i = 0; i < 20; ++i) {
            if (result[i] == byteData[i + 12]) continue;
            return false;
        }
        return true;
    }

    private static int _getRecordLength(char[] record) {
        return record[0] << 24 | (record[1] & 0xFF) << 16 | (record[2] & 0xFF) << 8 | record[3] & 0xFF;
    }

    static SecureStoreKey readKeyFile(Tracer tracer, String keyFilePath) throws SQLException {
        return SecureStore._readKeyFile(tracer, keyFilePath);
    }

    static Map<String, SecureStoreRecord> readDataFile(String dataFilePath) throws IOException, SQLException {
        return SecureStore._readDataFile(dataFilePath);
    }

    static String getPasswd(SecureStoreRecord passwdRecord, SecureStoreKey secureStoreKey) throws SQLException {
        return SecureStore._getPasswd(passwdRecord, secureStoreKey);
    }
}

