/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.LatencySession;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;

@NotThreadSafe
public class BasicSession
extends Session {
    static final SessionFactory SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session newInstance(Tracer tracer, Location location, ConnectionProperties connectionProperties, boolean doConnectExchange) throws RTEException {
            BasicSession initialSession = connectionProperties.hasProperty(ConnectionProperty.LATENCY) ? new LatencySession(tracer, location, connectionProperties) : new BasicSession(tracer, location, connectionProperties);
            initialSession._doInfoExchange();
            Session returnedSession = doConnectExchange ? initialSession._doConnectExchange(SESSION_FACTORY, connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME)) : initialSession;
            return returnedSession;
        }
    };
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final Socket _socket;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final HanaWebSocket _webSocket;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final InputStream _inputStream;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final OutputStream _outputStream;

    BasicSession(Tracer tracer, Location location, ConnectionProperties connectionProperties) throws RTEException {
        super(tracer, location, connectionProperties);
        String hostName = location.getHostName();
        int portNumber = location.getPortNumber();
        HanaWebSocket[] webSocketOutputParm = new HanaWebSocket[1];
        try {
            this._socket = this._openSocket(tracer, hostName, portNumber, connectionProperties, webSocketOutputParm);
            this._webSocket = webSocketOutputParm[0];
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException e) {
            this.destroy();
            throw new RTEException(tracer, MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
    }

    @Override
    protected Socket _getSocket() {
        return this._socket;
    }

    @Override
    protected HanaWebSocket _getWebSocket() {
        return this._webSocket;
    }

    @Override
    protected InputStream _getInputStream() {
        return this._inputStream;
    }

    @Override
    protected OutputStream _getOutputStream() {
        return this._outputStream;
    }

    private Socket _openSocket(Tracer tracer, String hostName, int portNumber, ConnectionProperties connectionProperties, HanaWebSocket[] webSocketOutputParm) throws RTEException {
        Socket socket = null;
        HanaWebSocket webSocket = null;
        String webSocketUrl = connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
        boolean isWebSocket = !webSocketUrl.isEmpty();
        String proxyHostName = connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
        if (tracer.on()) {
            tracer.printMessage("HOSTLIST: [" + hostName + ":" + portNumber + "]");
        }
        if (hostName.equals(Driver.getComputerName()) || hostName.equals(Driver.getFullComputerName())) {
            hostName = "localhost";
        }
        try {
            if (!proxyHostName.isEmpty()) {
                String proxyUserName;
                int proxyPort = connectionProperties.getIntProperty(ConnectionProperty.PROXY_PORT);
                char[] proxyPassword = connectionProperties.getProperty(ConnectionProperty.PROXY_PASSWD).toCharArray();
                String proxyScpAccount = connectionProperties.getProperty(ConnectionProperty.PROXY_SCP_ACCOUNT);
                if (!proxyScpAccount.isEmpty()) {
                    int idx = proxyScpAccount.indexOf(46);
                    if (idx != -1) {
                        byte[] leftPart = proxyScpAccount.substring(0, idx - 1).getBytes(CharsetUtils.US_ASCII);
                        byte[] rightPart = proxyScpAccount.substring(idx + 1).getBytes(CharsetUtils.US_ASCII);
                        proxyUserName = "1." + Base64Utils.encodeToString(leftPart) + '.' + Base64Utils.encodeToString(rightPart);
                    } else {
                        proxyUserName = "1." + Base64Utils.encodeToString(proxyScpAccount.getBytes(CharsetUtils.UTF_8));
                    }
                } else {
                    proxyUserName = connectionProperties.getProperty(ConnectionProperty.PROXY_USER_NAME);
                }
                final String f_proxyUserName = proxyUserName;
                final char[] f_proxyPassword = proxyPassword;
                Authenticator authenticator = new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(f_proxyUserName, f_proxyPassword);
                    }
                };
                if (isWebSocket) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostName, proxyPort));
                    webSocket = new HanaWebSocket(tracer, this._getWebSocketUri(hostName, portNumber, webSocketUrl), proxy, authenticator, this._getConnectTimeout(), false, null, connectionProperties.getIntProperty(ConnectionProperty.WEB_SOCKET_PING_TIMEOUT));
                    socket = webSocket.getSocket();
                } else {
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHostName, proxyPort));
                    socket = new Socket(proxy);
                    Authenticator.setDefault(authenticator);
                    socket.connect(new InetSocketAddress(hostName, portNumber), this._getConnectTimeout());
                }
            } else if (isWebSocket) {
                webSocket = new HanaWebSocket(tracer, this._getWebSocketUri(hostName, portNumber, webSocketUrl), null, null, this._getConnectTimeout(), false, null, connectionProperties.getIntProperty(ConnectionProperty.WEB_SOCKET_PING_TIMEOUT));
                socket = webSocket.getSocket();
            } else {
                socket = new Socket();
                socket.connect(new InetSocketAddress(hostName, portNumber), this._getConnectTimeout());
            }
            this._setSocketOptions(socket);
            if (isWebSocket) {
                this._setWebSocketDefaults(connectionProperties);
            }
        }
        catch (UnknownHostException e) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        webSocketOutputParm[0] = webSocket;
        return socket;
    }
}

