/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Page<T> {
    private T[] items;
    @JsonProperty(value="filtered_count")
    private int filteredCount;
    @JsonProperty(value="item_count")
    private int itemCount;
    private int page;
    @JsonProperty(value="page_count")
    private int pageCount;
    @JsonProperty(value="page_size")
    private int pageSize;
    @JsonProperty(value="total_count")
    private int totalCount;

    public Page() {
    }

    public Page(T[] items) {
        int totalItems = items != null ? items.length : 0;
        this.items = items;
        this.itemCount = totalItems;
        this.totalCount = totalItems;
        this.pageCount = 1;
        this.page = 1;
        this.pageSize = totalItems;
        this.filteredCount = totalItems;
    }

    public T[] getItems() {
        return this.items;
    }

    public void setItems(T[] items) {
        this.items = items;
    }

    public List<T> getItemsAsList() {
        return this.items != null ? Arrays.asList(this.items) : Collections.emptyList();
    }

    public int getFilteredCount() {
        return this.filteredCount;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalCount() {
        return this.totalCount;
    }
}

