/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.substratevm;

import com.oracle.svm.core.OS;
import com.oracle.svm.driver.NativeImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;

@Mojo(name="native-image", defaultPhase=LifecyclePhase.PACKAGE)
public class NativeImageMojo
extends AbstractMojo {
    private static final String svmGroupId = "com.oracle.substratevm";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(property="mainClass")
    private String mainClass;
    @Parameter(property="imageName")
    private String imageName;
    @Parameter(property="buildArgs")
    private String buildArgs;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    private Logger tarGzLogger = new AbstractLogger(2, "NativeImageMojo.tarGzLogger"){

        public void debug(String message, Throwable throwable) {
            if (this.isDebugEnabled()) {
                NativeImageMojo.this.getLog().debug((CharSequence)message, throwable);
            }
        }

        public void info(String message, Throwable throwable) {
            if (this.isInfoEnabled()) {
                NativeImageMojo.this.getLog().info((CharSequence)message, throwable);
            }
        }

        public void warn(String message, Throwable throwable) {
            if (this.isWarnEnabled()) {
                NativeImageMojo.this.getLog().warn((CharSequence)message, throwable);
            }
        }

        public void error(String message, Throwable throwable) {
            if (this.isErrorEnabled()) {
                NativeImageMojo.this.getLog().error((CharSequence)message, throwable);
            }
        }

        public void fatalError(String message, Throwable throwable) {
            if (this.isFatalErrorEnabled()) {
                NativeImageMojo.this.getLog().error((CharSequence)message, throwable);
            }
        }

        public Logger getChildLogger(String name) {
            return this;
        }
    };
    private final TarGZipUnArchiver tarGzExtract = new TarGZipUnArchiver();
    private final List<Path> classpath = new ArrayList<Path>();

    NativeImageMojo() {
        this.tarGzExtract.enableLogging(this.tarGzLogger);
    }

    private Stream<Artifact> getSelectedArtifactsStream(String groupId, String ... artifactIds) {
        return this.plugin.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(groupId)).filter(artifact -> {
            List<String> artifactIdsList = Arrays.asList(artifactIds);
            if (artifactIdsList.isEmpty()) {
                return true;
            }
            return artifactIdsList.contains(artifact.getArtifactId());
        });
    }

    public void execute() throws MojoExecutionException {
        block33: {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping native-image generation (parameter 'skip' is true).");
                return;
            }
            this.classpath.clear();
            List<String> imageClasspathScopes = Arrays.asList("compile", "runtime");
            this.project.setArtifactFilter(artifact -> imageClasspathScopes.contains(artifact.getScope()));
            for (Artifact dependency : this.project.getArtifacts()) {
                this.addClasspath(dependency);
            }
            this.addClasspath(this.project.getArtifact());
            String classpathStr = this.classpath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
            Path nativeImageExecutable = NativeImageMojo.getJavaHome().resolve("bin").resolve(this.withExeSuffix("native-image"));
            if (Files.isExecutable(nativeImageExecutable)) {
                ProcessBuilder processBuilder;
                String nativeImageExecutableVersion = "Unknown";
                Process versionCheckProcess = null;
                try {
                    processBuilder = new ProcessBuilder(nativeImageExecutable.toString(), "--version");
                    versionCheckProcess = processBuilder.start();
                    try (Scanner scanner = new Scanner(versionCheckProcess.getInputStream());){
                        while (true) {
                            if (scanner.findInLine("GraalVM Version ") != null) {
                                nativeImageExecutableVersion = scanner.next();
                                break;
                            }
                            if (!scanner.hasNextLine()) break;
                            scanner.nextLine();
                        }
                        if (versionCheckProcess.waitFor() != 0) {
                            throw new MojoExecutionException("Execution of " + String.join((CharSequence)" ", processBuilder.command()) + " returned non-zero result");
                        }
                    }
                }
                catch (IOException | InterruptedException e) {
                    throw new MojoExecutionException("Probing version info of native-image executable " + nativeImageExecutable + " failed", e);
                }
                if (!nativeImageExecutableVersion.equals(this.plugin.getVersion())) {
                    this.getLog().warn((CharSequence)("Version mismatch between " + this.plugin.getArtifactId() + " (" + this.plugin.getVersion() + ") and native-image executable (" + nativeImageExecutableVersion + ")"));
                }
                try {
                    processBuilder = new ProcessBuilder(nativeImageExecutable.toString(), "-cp", classpathStr);
                    processBuilder.command().addAll(this.getBuildArgs());
                    processBuilder.directory(this.getWorkingDirectory().toFile());
                    processBuilder.inheritIO();
                    String commandString = String.join((CharSequence)" ", processBuilder.command());
                    this.getLog().info((CharSequence)("Executing: " + commandString));
                    Process imageBuildProcess = processBuilder.start();
                    if (imageBuildProcess.waitFor() != 0) {
                        throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
                    }
                    break block33;
                }
                catch (IOException | InterruptedException e) {
                    throw new MojoExecutionException("Building image with " + nativeImageExecutable + " failed", e);
                }
            }
            Path untarDestDirectory = this.getUntarDestDirectory();
            if (!Files.isDirectory(untarDestDirectory, new LinkOption[0])) {
                try {
                    Files.createDirectories(untarDestDirectory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to create directory " + untarDestDirectory, (Exception)e);
                }
                this.plugin.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(svmGroupId)).filter(artifact -> artifact.getArtifactId().startsWith("svm-hosted-native-")).forEach(artifact -> {
                    if (artifact.getType().equals("tar.gz")) {
                        this.tarGzExtract.setSourceFile(artifact.getFile());
                        this.tarGzExtract.setDestDirectory(untarDestDirectory.toFile());
                        this.tarGzExtract.extract();
                    }
                });
            }
            try {
                MojoBuildConfiguration config = new MojoBuildConfiguration();
                this.getLog().info((CharSequence)("WorkingDirectory: " + config.getWorkingDirectory()));
                this.getLog().info((CharSequence)("ImageClasspath: " + classpathStr));
                this.getLog().info((CharSequence)("BuildArgs: " + config.getBuildArgs()));
                if (config.useJavaModules()) {
                    ServiceLoader<OptionDescriptors> optionDescriptors = ServiceLoader.load(OptionDescriptors.class, OptionDescriptors.class.getClassLoader());
                    for (OptionDescriptors optionDescriptor : optionDescriptors) {
                        for (OptionDescriptor descriptor : optionDescriptor) {
                            this.getLog().debug((CharSequence)("Eager initialization of OptionDescriptor: " + descriptor.getName()));
                        }
                    }
                }
                NativeImage.build((NativeImage.BuildConfiguration)config);
            }
            catch (NativeImage.NativeImageError e) {
                throw new MojoExecutionException("Error creating native image:", (Throwable)e);
            }
        }
    }

    private String withExeSuffix(String basename) {
        if (OS.getCurrent() == OS.WINDOWS) {
            return basename + ".exe";
        }
        return basename;
    }

    private void addClasspath(Artifact artifact) throws MojoExecutionException {
        if (!"jar".equals(artifact.getType())) {
            this.getLog().warn((CharSequence)("Ignoring non-jar type ImageClasspath Entry " + artifact));
            return;
        }
        File artifactFile = artifact.getFile();
        if (artifactFile == null) {
            throw new MojoExecutionException("Missing jar-file for " + artifact + ". Ensure " + this.plugin.getArtifactId() + " runs in package phase.");
        }
        Path jarFilePath = artifactFile.toPath();
        this.getLog().info((CharSequence)("ImageClasspath Entry: " + artifact + " (" + jarFilePath.toUri() + ")"));
        URI jarFileURI = URI.create("jar:" + jarFilePath.toUri());
        try (FileSystem jarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());){
            Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
            if (Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) {
                List nativeImageProperties = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]).filter(p -> p.endsWith("native-image.properties")).collect(Collectors.toList());
                for (Path nativeImageProperty : nativeImageProperties) {
                    Path relativeSubDir = nativeImageMetaInfBase.relativize(nativeImageProperty).getParent();
                    boolean valid = relativeSubDir != null && relativeSubDir.getNameCount() == 2;
                    valid = valid && relativeSubDir.getName(0).toString().equals(artifact.getGroupId());
                    if (valid = valid && relativeSubDir.getName(1).toString().equals(artifact.getArtifactId())) continue;
                    String example = "META-INF/native-image/${groupId}/${artifactId}/native-image.properties";
                    this.getLog().warn((CharSequence)(nativeImageProperty.toUri() + " does not match recommended " + example + " layout."));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Artifact " + artifact + "cannot be added to image classpath", (Exception)e);
        }
        this.classpath.add(jarFilePath);
    }

    private static Path getJavaHome() {
        return Paths.get(System.getProperty("java.home"), new String[0]);
    }

    private Path getWorkingDirectory() {
        return this.outputDirectory.toPath();
    }

    private String consumeConfigurationNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        return this.getConfigurationNodeValue((ConfigurationContainer)selectedPlugin, nodeNames);
    }

    private String consumeExecutionsNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        for (PluginExecution execution : selectedPlugin.getExecutions()) {
            String value = this.getConfigurationNodeValue((ConfigurationContainer)execution, nodeNames);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getConfigurationNodeValue(ConfigurationContainer container, String ... nodeNames) {
        if (container != null && container.getConfiguration() instanceof Xpp3Dom) {
            Xpp3Dom node = (Xpp3Dom)container.getConfiguration();
            for (String nodeName : nodeNames) {
                if ((node = node.getChild(nodeName)) != null) continue;
                return null;
            }
            return node.getValue();
        }
        return null;
    }

    private List<String> getBuildArgs() {
        if (this.mainClass == null) {
            this.mainClass = this.consumeExecutionsNodeValue("org.apache.maven.plugins:maven-shade-plugin", "transformers", "transformer", "mainClass");
        }
        if (this.mainClass == null) {
            this.mainClass = this.consumeConfigurationNodeValue("org.apache.maven.plugins:maven-assembly-plugin", "archive", "manifest", "mainClass");
        }
        if (this.mainClass == null) {
            this.mainClass = this.consumeConfigurationNodeValue("org.apache.maven.plugins:maven-jar-plugin", "archive", "manifest", "mainClass");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.buildArgs != null && !this.buildArgs.isEmpty()) {
            list.addAll(Arrays.asList(this.buildArgs.split("\\s+")));
        }
        if (this.mainClass != null && !this.mainClass.equals(".")) {
            list.add("-H:Class=" + this.mainClass);
        }
        if (this.imageName != null) {
            list.add("-H:Name=" + this.imageName);
        }
        return list;
    }

    private Path getUntarDestDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.plugin.getArtifactId()).resolve(this.plugin.getVersion());
    }

    private final class MojoBuildConfiguration
    implements NativeImage.BuildConfiguration {
        private final List<Path> jvmciJars;

        MojoBuildConfiguration() throws MojoExecutionException {
            if (this.useJavaModules()) {
                this.jvmciJars = Collections.emptyList();
            } else {
                try {
                    this.jvmciJars = Files.list(NativeImageMojo.getJavaHome().resolve("lib/jvmci")).collect(Collectors.toList());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("JVM in " + NativeImageMojo.getJavaHome() + " does not support JVMCI interface", (Exception)e);
                }
            }
        }

        public Path getWorkingDirectory() {
            return NativeImageMojo.this.getWorkingDirectory();
        }

        public Path getJavaExecutable() {
            return NativeImageMojo.getJavaHome().resolve("bin").resolve(NativeImageMojo.this.withExeSuffix("java"));
        }

        private List<Path> getSelectedArtifactPaths(String groupId, String ... artifactIds) {
            return NativeImageMojo.this.getSelectedArtifactsStream(groupId, artifactIds).map(Artifact::getFile).map(File::toPath).collect(Collectors.toList());
        }

        public List<Path> getBuilderClasspath() {
            ArrayList<Path> paths = new ArrayList<Path>();
            if (this.useJavaModules()) {
                paths.addAll(this.getSelectedArtifactPaths("org.graalvm.sdk", "graal-sdk"));
                paths.addAll(this.getSelectedArtifactPaths("org.graalvm.compiler", "compiler"));
            }
            paths.addAll(this.getSelectedArtifactPaths(NativeImageMojo.svmGroupId, "svm", "objectfile", "pointsto"));
            return paths;
        }

        public List<Path> getBuilderCLibrariesPaths() {
            return Collections.singletonList(NativeImageMojo.this.getUntarDestDirectory());
        }

        public Path getBuilderInspectServerPath() {
            return null;
        }

        public List<Path> getImageProvidedClasspath() {
            return this.getSelectedArtifactPaths(NativeImageMojo.svmGroupId, "library-support");
        }

        public List<Path> getBuilderJVMCIClasspath() {
            ArrayList<Path> paths = new ArrayList<Path>();
            paths.addAll(this.jvmciJars);
            paths.addAll(this.getBuilderJVMCIClasspathAppend());
            return paths;
        }

        public List<Path> getBuilderJVMCIClasspathAppend() {
            return this.getSelectedArtifactPaths("org.graalvm.compiler", "compiler");
        }

        public List<Path> getBuilderBootClasspath() {
            return this.getSelectedArtifactPaths("org.graalvm.sdk", "graal-sdk");
        }

        public List<Path> getBuilderModulePath() {
            ArrayList<Path> paths = new ArrayList<Path>();
            paths.addAll(this.getSelectedArtifactPaths("org.graalvm.sdk", "graal-sdk"));
            paths.addAll(this.getSelectedArtifactPaths("org.graalvm.truffle", "truffle-api"));
            return paths;
        }

        public List<Path> getBuilderUpgradeModulePath() {
            return this.getSelectedArtifactPaths("org.graalvm.compiler", "compiler");
        }

        public List<Path> getImageClasspath() {
            return NativeImageMojo.this.classpath;
        }

        public List<String> getBuildArgs() {
            return NativeImageMojo.this.getBuildArgs();
        }
    }
}

