/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.transformer;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SamplingEventTransformer<K, V>
extends ExternalizableHelper
implements MapEventTransformer<K, V, V>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="samplingInterval")
    protected int m_nSamplingInterval;
    protected transient long m_nLastSentTime;

    public SamplingEventTransformer() {
    }

    public SamplingEventTransformer(int nSamplingInterval) {
        this.m_nSamplingInterval = nSamplingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapEvent<K, V> transform(MapEvent<K, V> event) {
        long nCurrentTime = Base.getSafeTimeMillis();
        SamplingEventTransformer samplingEventTransformer = this;
        synchronized (samplingEventTransformer) {
            if (nCurrentTime - this.m_nLastSentTime >= (long)this.m_nSamplingInterval) {
                this.m_nLastSentTime = nCurrentTime;
                return event;
            }
        }
        return null;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nSamplingInterval = SamplingEventTransformer.readInt(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nSamplingInterval);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nSamplingInterval = in.readInt(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nSamplingInterval);
    }
}

