/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.transformer;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExtractorEventTransformer<K, V, E>
extends ExternalizableHelper
implements MapEventTransformer<K, V, E>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="extractorOld")
    private ValueExtractor<? super V, ? extends E> m_extractorOld;
    @JsonbProperty(value="extractorNew")
    private ValueExtractor<? super V, ? extends E> m_extractorNew;

    public ExtractorEventTransformer() {
    }

    public ExtractorEventTransformer(ValueExtractor<? super V, ? extends E> extractor) {
        this(extractor, extractor);
    }

    public ExtractorEventTransformer(String sMethod) {
        this(sMethod.indexOf(44) < 0 ? (sMethod.indexOf(46) < 0 ? new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod)) : new MultiExtractor(sMethod));
    }

    public ExtractorEventTransformer(ValueExtractor<? super V, ? extends E> extractorOld, ValueExtractor<? super V, ? extends E> extractorNew) {
        this.m_extractorOld = extractorOld;
        this.m_extractorNew = extractorNew;
    }

    public ValueExtractor getOldValueExtractor() {
        return this.m_extractorOld;
    }

    public ValueExtractor getNewValueExtractor() {
        return this.m_extractorNew;
    }

    @Override
    public MapEvent<K, E> transform(MapEvent<K, V> event) {
        ValueExtractor extractorOld = this.getOldValueExtractor();
        ValueExtractor extractorNew = this.getNewValueExtractor();
        return new MapEvent<K, Object>(event.getMap(), event.getId(), event.getKey(), (extractorOld == null ? null : (Object)extractorOld.extract(event.getOldValue())), (extractorNew == null ? null : (Object)extractorNew.extract(event.getNewValue())));
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        boolean fSame = in.readBoolean();
        this.m_extractorOld = (ValueExtractor)ExternalizableHelper.readObject(in);
        this.m_extractorNew = fSame ? this.m_extractorOld : (ValueExtractor)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ValueExtractor<? super V, ? extends E> extractorOld = this.m_extractorOld;
        ValueExtractor<? super V, ? extends E> extractorNew = this.m_extractorNew;
        if (ExtractorEventTransformer.equals(extractorOld, extractorNew)) {
            out.writeBoolean(true);
            ExternalizableHelper.writeObject(out, extractorOld);
        } else {
            out.writeBoolean(false);
            ExternalizableHelper.writeObject(out, extractorOld);
            ExternalizableHelper.writeObject(out, extractorNew);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        boolean fSame = in.readBoolean(0);
        this.m_extractorOld = (ValueExtractor)in.readObject(1);
        this.m_extractorNew = fSame ? this.m_extractorOld : (ValueExtractor)in.readObject(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        ValueExtractor<? super V, ? extends E> extractorOld = this.m_extractorOld;
        ValueExtractor<? super V, ? extends E> extractorNew = this.m_extractorNew;
        if (ExtractorEventTransformer.equals(extractorOld, extractorNew)) {
            out.writeBoolean(0, true);
            out.writeObject(1, extractorNew);
        } else {
            out.writeBoolean(0, false);
            out.writeObject(1, extractorOld);
            out.writeObject(2, extractorNew);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ExtractorEventTransformer) {
            ExtractorEventTransformer that = (ExtractorEventTransformer)o;
            return ExtractorEventTransformer.equals(this.m_extractorOld, that.m_extractorOld) && ExtractorEventTransformer.equals(this.m_extractorNew, that.m_extractorNew);
        }
        return false;
    }

    public int hashCode() {
        ValueExtractor<V, E> extractorOld = this.m_extractorOld;
        ValueExtractor<V, E> extractorNew = this.m_extractorNew;
        return (extractorOld == null ? 0 : extractorOld.hashCode()) + (extractorNew == null ? 0 : extractorNew.hashCode());
    }

    public String toString() {
        ValueExtractor extractorOld = this.getOldValueExtractor();
        ValueExtractor extractorNew = this.getNewValueExtractor();
        StringBuilder sb = new StringBuilder(ClassHelper.getSimpleName(this.getClass()));
        sb.append('{');
        if (ExtractorEventTransformer.equals(extractorOld, extractorNew)) {
            sb.append("extractors=").append(extractorOld);
        } else {
            sb.append("extractor old=").append(extractorOld).append(", extractor new=").append(extractorNew);
        }
        sb.append('}');
        return sb.toString();
    }
}

