/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.stream;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.internal.util.stream.StreamSupport;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Filters;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.ExtractorComparator;
import com.tangosol.util.comparator.InverseComparator;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.BaseRemoteStream;
import com.tangosol.util.stream.RemoteCollector;
import com.tangosol.util.stream.RemoteCollectors;
import com.tangosol.util.stream.RemoteDoubleStream;
import com.tangosol.util.stream.RemoteIntStream;
import com.tangosol.util.stream.RemoteLongStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface RemoteStream<T>
extends Stream<T>,
BaseRemoteStream<T, Stream<T>> {
    public static <K, V> RemoteStream<InvocableMap.Entry<K, V>> entrySet(InvocableMap<K, V> map) {
        return StreamSupport.entryStream(map, true, null, Filters.always());
    }

    public static <K, V> RemoteStream<K> keySet(InvocableMap<K, V> map) {
        return StreamSupport.entryStream(map, true, null, Filters.always()).map(InvocableMap.Entry::getKey);
    }

    public static <K, V> RemoteStream<V> values(InvocableMap<K, V> map) {
        return StreamSupport.entryStream(map, true, null, Filters.always()).map(InvocableMap.Entry::getValue);
    }

    @Override
    public RemoteStream<T> sequential();

    @Override
    public RemoteStream<T> parallel();

    @Override
    public RemoteStream<T> unordered();

    @Override
    public RemoteStream<T> filter(Predicate<? super T> var1);

    @Override
    default public RemoteStream<T> filter(Remote.Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    public <R> RemoteStream<R> map(Function<? super T, ? extends R> var1);

    @Override
    default public <R> RemoteStream<R> map(Remote.Function<? super T, ? extends R> mapper) {
        return this.map((Function)mapper);
    }

    @Override
    default public <R> RemoteStream<R> map(ValueExtractor<? super T, ? extends R> mapper) {
        return this.map((Function)Lambdas.ensureRemotable(mapper));
    }

    @Override
    public RemoteIntStream mapToInt(ToIntFunction<? super T> var1);

    default public RemoteIntStream mapToInt(Remote.ToIntFunction<? super T> mapper) {
        return this.mapToInt((ToIntFunction)mapper);
    }

    default public RemoteIntStream mapToInt(ValueExtractor<? super T, ? extends Number> mapper) {
        return this.mapToInt((ToIntFunction)Lambdas.ensureRemotable(mapper));
    }

    @Override
    public RemoteLongStream mapToLong(ToLongFunction<? super T> var1);

    default public RemoteLongStream mapToLong(Remote.ToLongFunction<? super T> mapper) {
        return this.mapToLong((ToLongFunction)mapper);
    }

    default public RemoteLongStream mapToLong(ValueExtractor<? super T, ? extends Number> mapper) {
        return this.mapToLong((ToLongFunction)Lambdas.ensureRemotable(mapper));
    }

    @Override
    public RemoteDoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    default public RemoteDoubleStream mapToDouble(Remote.ToDoubleFunction<? super T> mapper) {
        return this.mapToDouble((ToDoubleFunction)mapper);
    }

    default public RemoteDoubleStream mapToDouble(ValueExtractor<? super T, ? extends Number> mapper) {
        return this.mapToDouble((ToDoubleFunction)Lambdas.ensureRemotable(mapper));
    }

    @Override
    public <R> RemoteStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    default public <R> RemoteStream<R> flatMap(Remote.Function<? super T, ? extends Stream<? extends R>> mapper) {
        Remote.Function safeMapper = Remote.function(t -> t == null ? null : (Stream)mapper.apply(t));
        return this.flatMap((Function)safeMapper);
    }

    @Override
    public RemoteIntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    default public RemoteIntStream flatMapToInt(Remote.Function<? super T, ? extends IntStream> mapper) {
        Remote.Function safeMapper = Remote.function(t -> t == null ? null : (IntStream)mapper.apply(t));
        return this.flatMapToInt((Function)safeMapper);
    }

    @Override
    public RemoteLongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    default public RemoteLongStream flatMapToLong(Remote.Function<? super T, ? extends LongStream> mapper) {
        Remote.Function safeMapper = Remote.function(t -> t == null ? null : (LongStream)mapper.apply(t));
        return this.flatMapToLong((Function)safeMapper);
    }

    @Override
    public RemoteDoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    default public RemoteDoubleStream flatMapToDouble(Remote.Function<? super T, ? extends DoubleStream> mapper) {
        Remote.Function safeMapper = Remote.function(t -> t == null ? null : (DoubleStream)mapper.apply(t));
        return this.flatMapToDouble((Function)safeMapper);
    }

    @Override
    public <R> RemoteStream<R> mapMulti(BiConsumer<? super T, ? super Consumer<R>> var1);

    @Override
    default public <R> RemoteStream<R> mapMulti(Remote.BiConsumer<? super T, ? super Consumer<R>> mapper) {
        return this.mapMulti((BiConsumer)mapper);
    }

    @Override
    public RemoteIntStream mapMultiToInt(BiConsumer<? super T, ? super IntConsumer> var1);

    default public RemoteIntStream mapMultiToInt(Remote.BiConsumer<? super T, ? super IntConsumer> mapper) {
        return this.mapMultiToInt((BiConsumer)mapper);
    }

    @Override
    public RemoteLongStream mapMultiToLong(BiConsumer<? super T, ? super LongConsumer> var1);

    default public RemoteLongStream mapMultiToLong(Remote.BiConsumer<? super T, ? super LongConsumer> mapper) {
        return this.mapMultiToLong((BiConsumer)mapper);
    }

    @Override
    public RemoteDoubleStream mapMultiToDouble(BiConsumer<? super T, ? super DoubleConsumer> var1);

    default public RemoteDoubleStream mapMultiToDouble(Remote.BiConsumer<? super T, ? super DoubleConsumer> mapper) {
        return this.mapMultiToDouble((BiConsumer)mapper);
    }

    @Override
    public RemoteStream<T> peek(Consumer<? super T> var1);

    @Override
    default public RemoteStream<T> peek(Remote.Consumer<? super T> action) {
        return this.peek((Consumer)action);
    }

    @Override
    public Stream<T> limit(long var1);

    @Override
    public Stream<T> skip(long var1);

    @Override
    default public Stream<T> takeWhile(Predicate<? super T> predicate) {
        return Stream.super.takeWhile(predicate);
    }

    @Override
    default public Stream<T> dropWhile(Predicate<? super T> predicate) {
        return Stream.super.dropWhile(predicate);
    }

    @Override
    public Stream<T> distinct();

    @Override
    public RemoteStream<T> sorted();

    @Override
    public RemoteStream<T> sorted(Comparator<? super T> var1);

    @Override
    default public RemoteStream<T> sorted(Remote.Comparator<? super T> comparator) {
        return this.sorted(comparator, false);
    }

    default public RemoteStream<T> sorted(Remote.Comparator<? super T> comparator, boolean fInverse) {
        InverseComparator c = fInverse ? new InverseComparator(comparator) : comparator;
        return this.sorted((Comparator)c);
    }

    default public <U> RemoteStream<T> sorted(ValueExtractor<? super U, ? extends Comparable> extractor) {
        return this.sorted(extractor, false);
    }

    default public <U> RemoteStream<T> sorted(ValueExtractor<? super U, ? extends Comparable> extractor, boolean fInverse) {
        ExternalizableLite comparator = new ExtractorComparator<U>(extractor);
        if (fInverse) {
            comparator = new InverseComparator<U>(comparator);
        }
        return this.sorted((Comparator)((Object)comparator));
    }

    @Override
    public void forEach(Consumer<? super T> var1);

    @Override
    public void forEachOrdered(Consumer<? super T> var1);

    @Override
    public Object[] toArray();

    @Override
    public <A> A[] toArray(IntFunction<A[]> var1);

    @Override
    public T reduce(T var1, BinaryOperator<T> var2);

    @Override
    default public T reduce(T identity, Remote.BinaryOperator<T> accumulator) {
        return this.reduce(identity, (BinaryOperator<T>)accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> var1);

    @Override
    default public Optional<T> reduce(Remote.BinaryOperator<T> accumulator) {
        return this.reduce((BinaryOperator<T>)accumulator);
    }

    @Override
    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    @Override
    default public <U> U reduce(U identity, Remote.BiFunction<U, ? super T, U> accumulator, Remote.BinaryOperator<U> combiner) {
        return this.reduce(identity, (BiFunction<U, ? super T, U>)accumulator, (BinaryOperator<U>)combiner);
    }

    @Override
    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    @Override
    default public <R> R collect(Remote.Supplier<R> supplier, Remote.BiConsumer<R, ? super T> accumulator, Remote.BiConsumer<R, R> combiner) {
        return this.collect((Supplier<R>)supplier, (BiConsumer<R, ? super T>)accumulator, (BiConsumer<R, R>)combiner);
    }

    @Override
    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        if (collector instanceof RemoteCollector) {
            return this.collect((RemoteCollector)collector);
        }
        throw new UnsupportedOperationException("java.util.stream.Collector is not supported. Please use com.tangosol.util.stream.RemoteCollector instead.");
    }

    @Override
    public <R, A> R collect(RemoteCollector<? super T, A, R> var1);

    @Override
    default public List<T> toList() {
        return Collections.unmodifiableList(this.collect(RemoteCollectors.toList()));
    }

    @Override
    public Optional<T> min(Comparator<? super T> var1);

    @Override
    default public Optional<T> min(Remote.Comparator<? super T> comparator) {
        return this.min((Comparator<? super T>)comparator);
    }

    default public <U> Optional<T> min(ValueExtractor<? super U, ? extends Comparable> extractor) {
        return this.min(new ExtractorComparator<U>(extractor));
    }

    @Override
    public Optional<T> max(Comparator<? super T> var1);

    @Override
    default public Optional<T> max(Remote.Comparator<? super T> comparator) {
        return this.max((Comparator<? super T>)comparator);
    }

    default public <U> Optional<T> max(ValueExtractor<? super U, ? extends Comparable> extractor) {
        return this.max(new ExtractorComparator<U>(extractor));
    }

    @Override
    public long count();

    @Override
    public boolean anyMatch(Predicate<? super T> var1);

    @Override
    default public boolean anyMatch(Remote.Predicate<? super T> predicate) {
        return this.anyMatch((Predicate<? super T>)predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> var1);

    @Override
    default public boolean allMatch(Remote.Predicate<? super T> predicate) {
        return this.allMatch((Predicate<? super T>)predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> var1);

    @Override
    default public boolean noneMatch(Remote.Predicate<? super T> predicate) {
        return this.noneMatch((Predicate<? super T>)predicate);
    }

    @Override
    public Optional<T> findFirst();

    @Override
    public Optional<T> findAny();

    public static <T extends Number> RemoteIntStream toIntStream(RemoteStream<T> stream) {
        return stream.mapToInt(Number::intValue);
    }

    public static <T extends Number> RemoteLongStream toLongStream(RemoteStream<T> stream) {
        return stream.mapToLong(Number::longValue);
    }

    public static <T extends Number> RemoteDoubleStream toDoubleStream(RemoteStream<T> stream) {
        return stream.mapToDouble(Number::doubleValue);
    }
}

