/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.CompositeUpdater;
import com.tangosol.util.extractor.ReflectionUpdater;
import com.tangosol.util.processor.AbstractProcessor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UpdaterProcessor<K, V, T>
extends AbstractProcessor<K, V, Boolean>
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="updater")
    protected ValueUpdater<V, T> m_updater;
    @JsonbProperty(value="value")
    protected T m_value;

    public UpdaterProcessor() {
    }

    public UpdaterProcessor(ValueUpdater<V, T> updater, T value) {
        this.m_updater = updater;
        this.m_value = value;
    }

    public UpdaterProcessor(String sMethod, T value) {
        UpdaterProcessor.azzert(sMethod != null && sMethod.length() != 0, "Invalid method name");
        this.m_updater = sMethod.indexOf(46) < 0 ? new ReflectionUpdater(sMethod) : new CompositeUpdater(sMethod);
        this.m_value = value;
    }

    @Override
    public Boolean process(InvocableMap.Entry<K, V> entry) {
        ValueUpdater<V, T> updater = this.m_updater;
        if (updater == null) {
            entry.setValue(this.m_value, false);
        } else if (entry.isPresent()) {
            entry.update(updater, this.m_value);
        } else {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean equals(Object o) {
        if (o instanceof UpdaterProcessor) {
            UpdaterProcessor that = (UpdaterProcessor)o;
            return UpdaterProcessor.equals(this.m_updater, that.m_updater) && UpdaterProcessor.equals(this.m_value, that.m_value);
        }
        return false;
    }

    public int hashCode() {
        return this.m_updater.hashCode();
    }

    public String toString() {
        return "UpdaterProcessor(" + String.valueOf(this.m_updater) + ", " + String.valueOf(this.m_value) + ")";
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_updater = (ValueUpdater)ExternalizableHelper.readObject(in);
        this.m_value = ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_updater);
        ExternalizableHelper.writeObject(out, this.m_value);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_updater = (ValueUpdater)in.readObject(0);
        this.m_value = in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_updater);
        out.writeObject(1, this.m_value);
    }
}

