/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueManipulator;
import com.tangosol.util.processor.NumberIncrementor;
import com.tangosol.util.processor.PropertyProcessor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberMultiplier<K, V, N extends Number>
extends PropertyProcessor<K, V, N> {
    @JsonbProperty(value="multiplier")
    private N m_numFactor;
    @JsonbProperty(value="postMultiplication")
    private boolean m_fPostFactor;

    public NumberMultiplier() {
    }

    public NumberMultiplier(String sName, N numFactor, boolean fPostFactor) {
        super(sName);
        NumberMultiplier.azzert(numFactor != null);
        this.m_numFactor = numFactor;
        this.m_fPostFactor = fPostFactor;
    }

    public NumberMultiplier(ValueManipulator<V, N> manipulator, N numFactor, boolean fPostFactor) {
        super(manipulator);
        NumberMultiplier.azzert(numFactor != null);
        this.m_numFactor = numFactor;
        this.m_fPostFactor = fPostFactor;
    }

    @Override
    public N process(InvocableMap.Entry<K, V> entry) {
        Number numNew;
        if (!entry.isPresent()) {
            return null;
        }
        N numFactor = this.m_numFactor;
        Number numOld = (Number)this.get(entry);
        if (numOld == null) {
            Number number = numFactor instanceof Integer ? (Number)NumberIncrementor.INTEGER_ZERO : (Number)(numFactor instanceof Long ? (Number)NumberIncrementor.LONG_ZERO : (Number)(numFactor instanceof Double ? (Number)NumberIncrementor.DOUBLE_ZERO : (Number)(numFactor instanceof Float ? (Number)NumberIncrementor.FLOAT_ZERO : (Number)(numFactor instanceof BigInteger ? (Number)NumberIncrementor.BIGINTEGER_ZERO : (Number)(numFactor instanceof BigDecimal ? (Number)NumberIncrementor.BIGDECIMAL_ZERO : (Number)(numFactor instanceof Short ? (Number)NumberIncrementor.SHORT_ZERO : (Number)(numOld = numFactor instanceof Byte ? NumberIncrementor.BYTE_ZERO : null)))))));
        }
        if (numOld instanceof Integer) {
            int iNew = numOld.intValue();
            iNew = numFactor instanceof Double || numFactor instanceof Float ? (int)((double)iNew * ((Number)numFactor).doubleValue()) : (iNew *= ((Number)numFactor).intValue());
            numNew = iNew;
        } else if (numOld instanceof Long) {
            long lNew = numOld.longValue();
            lNew = numFactor instanceof Double || numFactor instanceof Float ? (long)((double)lNew * ((Number)numFactor).doubleValue()) : (lNew *= ((Number)numFactor).longValue());
            numNew = lNew;
        } else if (numOld instanceof Double) {
            numNew = numOld.doubleValue() * ((Number)numFactor).doubleValue();
        } else if (numOld instanceof Float) {
            numNew = Float.valueOf(numOld.floatValue() * ((Number)numFactor).floatValue());
        } else if (numOld instanceof BigInteger) {
            numNew = ((BigInteger)numOld).multiply((BigInteger)numFactor);
        } else if (numOld instanceof BigDecimal) {
            numNew = ((BigDecimal)numOld).multiply((BigDecimal)numFactor);
        } else if (numOld instanceof Short) {
            short iNew = numOld.shortValue();
            iNew = numFactor instanceof Double || numFactor instanceof Float ? (short)((double)iNew * ((Number)numFactor).doubleValue()) : (short)(iNew * ((Number)numFactor).shortValue());
            numNew = iNew;
        } else if (numOld instanceof Byte) {
            byte bNew = numOld.byteValue();
            bNew = numFactor instanceof Double || numFactor instanceof Float ? (byte)((double)bNew * ((Number)numFactor).doubleValue()) : (byte)(bNew * ((Number)numFactor).byteValue());
            numNew = bNew;
        } else {
            throw new RuntimeException("Unsupported type:" + (numOld == null ? numFactor.getClass().getName() : numOld.getClass().getName()));
        }
        if (!((Object)numNew).equals(numOld)) {
            this.set(entry, numNew);
        }
        return (N)(this.m_fPostFactor ? (Number)numOld : (Number)numNew);
    }

    @Override
    protected String getDescription() {
        return (this.m_fPostFactor ? ", post" : ", pre") + "-factor=" + String.valueOf(this.m_numFactor);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_numFactor = (Number)ExternalizableHelper.readObject(in);
        this.m_fPostFactor = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeObject(out, this.m_numFactor);
        out.writeBoolean(this.m_fPostFactor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_numFactor = (Number)in.readObject(1);
        this.m_fPostFactor = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeObject(1, this.m_numFactor);
        out.writeBoolean(2, this.m_fPostFactor);
    }

    public N getNumFactor() {
        return this.m_numFactor;
    }

    public boolean getPostFactor() {
        return this.m_fPostFactor;
    }
}

