/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueManipulator;
import com.tangosol.util.processor.PropertyProcessor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberIncrementor<K, V, N extends Number>
extends PropertyProcessor<K, V, N> {
    static final Number INTEGER_ZERO = 0;
    static final Number LONG_ZERO = 0L;
    static final Number DOUBLE_ZERO = 0.0;
    static final Number FLOAT_ZERO = Float.valueOf(0.0f);
    static final Number BIGDECIMAL_ZERO = new BigDecimal(BigInteger.ZERO);
    static final Number BIGINTEGER_ZERO = BigInteger.ZERO;
    static final Number SHORT_ZERO = (short)0;
    static final Number BYTE_ZERO = (byte)0;
    @JsonbProperty(value="increment")
    private N m_numInc;
    @JsonbProperty(value="postInc")
    private boolean m_fPostInc;

    public NumberIncrementor() {
    }

    public NumberIncrementor(String sName, N numInc, boolean fPostIncrement) {
        super(sName);
        NumberIncrementor.azzert(numInc != null);
        this.m_numInc = numInc;
        this.m_fPostInc = fPostIncrement;
    }

    public NumberIncrementor(ValueManipulator manipulator, N numInc, boolean fPostIncrement) {
        super(manipulator);
        NumberIncrementor.azzert(numInc != null);
        this.m_numInc = numInc;
        this.m_fPostInc = fPostIncrement;
    }

    @Override
    public N process(InvocableMap.Entry<K, V> entry) {
        Number numNew;
        if (!entry.isPresent()) {
            return null;
        }
        N numInc = this.m_numInc;
        if (numInc == null) {
            throw new IllegalArgumentException("Incorrectly constructed NumberIncrementor");
        }
        Number numOld = (Number)this.get(entry);
        if (numOld == null) {
            Number number = numInc instanceof Integer ? (Number)INTEGER_ZERO : (Number)(numInc instanceof Long ? (Number)LONG_ZERO : (Number)(numInc instanceof Double ? (Number)DOUBLE_ZERO : (Number)(numInc instanceof Float ? (Number)FLOAT_ZERO : (Number)(numInc instanceof BigInteger ? (Number)BIGINTEGER_ZERO : (Number)(numInc instanceof BigDecimal ? (Number)BIGDECIMAL_ZERO : (Number)(numInc instanceof Short ? (Number)SHORT_ZERO : (Number)(numOld = numInc instanceof Byte ? BYTE_ZERO : null)))))));
        }
        if (numOld instanceof Integer) {
            numNew = numOld.intValue() + ((Number)numInc).intValue();
        } else if (numOld instanceof Long) {
            numNew = numOld.longValue() + ((Number)numInc).longValue();
        } else if (numOld instanceof Double) {
            numNew = numOld.doubleValue() + ((Number)numInc).doubleValue();
        } else if (numOld instanceof Float) {
            numNew = Float.valueOf(numOld.floatValue() + ((Number)numInc).floatValue());
        } else if (numOld instanceof BigInteger) {
            numNew = ((BigInteger)numOld).add((BigInteger)numInc);
        } else if (numOld instanceof BigDecimal) {
            numNew = ((BigDecimal)numOld).add((BigDecimal)numInc);
        } else if (numOld instanceof Short) {
            numNew = (short)(numOld.shortValue() + ((Number)numInc).shortValue());
        } else if (numOld instanceof Byte) {
            numNew = (byte)(numOld.byteValue() + ((Number)numInc).byteValue());
        } else {
            throw new RuntimeException("Unsupported type:" + (numOld == null ? numInc.getClass().getName() : numOld.getClass().getName()));
        }
        this.set(entry, numNew);
        return (N)(this.m_fPostInc ? (Number)numOld : (Number)numNew);
    }

    public N getNumInc() {
        return this.m_numInc;
    }

    public boolean getPostInc() {
        return this.m_fPostInc;
    }

    @Override
    protected String getDescription() {
        return (this.m_fPostInc ? ", post" : ", pre") + "-increment=" + String.valueOf(this.m_numInc);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_numInc = (Number)ExternalizableHelper.readObject(in);
        this.m_fPostInc = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeObject(out, this.m_numInc);
        out.writeBoolean(this.m_fPostInc);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_numInc = (Number)in.readObject(1);
        this.m_fPostInc = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeObject(1, this.m_numInc);
        out.writeBoolean(2, this.m_fPostInc);
    }
}

