/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.processor.AbstractProcessor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class ConditionalProcessor<K, V, T>
extends AbstractProcessor<K, V, T>
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filter")
    protected Filter<V> m_filter;
    @JsonbProperty(value="processor")
    protected InvocableMap.EntryProcessor<K, V, T> m_processor;

    public ConditionalProcessor() {
    }

    public ConditionalProcessor(Filter<V> filter, InvocableMap.EntryProcessor<K, V, T> processor) {
        ConditionalProcessor.azzert(filter != null && processor != null, "Both filter and processor must be specified");
        this.m_filter = filter;
        this.m_processor = processor;
    }

    @Override
    public T process(InvocableMap.Entry<K, V> entry) {
        return InvocableMapHelper.evaluateEntry(this.m_filter, entry) ? (T)this.m_processor.process(entry) : null;
    }

    @Override
    public Map<K, T> processAll(Set<? extends InvocableMap.Entry<K, V>> setEntries) {
        LiteMap<K, T> mapResult = new LiteMap<K, T>();
        Filter<V> filter = this.m_filter;
        InvocableMap.EntryProcessor<K, V, T> processor = this.m_processor;
        for (InvocableMap.Entry<K, V> entry : setEntries) {
            if (!InvocableMapHelper.evaluateEntry(filter, entry)) continue;
            mapResult.put(entry.getKey(), processor.process(entry));
        }
        return mapResult;
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalProcessor) {
            ConditionalProcessor that = (ConditionalProcessor)o;
            return ConditionalProcessor.equals(this.m_filter, that.m_filter) && ConditionalProcessor.equals(this.m_processor, that.m_processor);
        }
        return false;
    }

    public int hashCode() {
        return this.m_filter.hashCode() + this.m_processor.hashCode();
    }

    public String toString() {
        return "ConditionalProcessor(" + String.valueOf(this.m_filter) + ", " + String.valueOf(this.m_processor) + ")";
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_processor = (InvocableMap.EntryProcessor)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_filter);
        ExternalizableHelper.writeObject(out, this.m_processor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_processor = (InvocableMap.EntryProcessor)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_processor);
    }
}

