/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.util.EntrySetMap;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractAsynchronousProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AsynchronousProcessor<K, V, R>
extends AbstractAsynchronousProcessor<K, V, R, Map<K, R>> {
    protected volatile Throwable m_eReason;
    protected List<Map.Entry<K, R>> m_listResultEntries;

    public AsynchronousProcessor(InvocableMap.EntryProcessor<K, V, R> processor) {
        this(processor, Thread.currentThread().hashCode(), null);
    }

    public AsynchronousProcessor(InvocableMap.EntryProcessor<K, V, R> processor, Executor executor) {
        this(processor, Thread.currentThread().hashCode(), executor);
    }

    public AsynchronousProcessor(InvocableMap.EntryProcessor<K, V, R> processor, int iUnitOrderId) {
        this(processor, iUnitOrderId, null);
    }

    public AsynchronousProcessor(InvocableMap.EntryProcessor<K, V, R> processor, int iUnitOrderId, Executor executor) {
        super(processor, iUnitOrderId, executor);
    }

    @Override
    public void onResult(Map.Entry<K, R> entry) {
        List<Map.Entry<K, R>> list = this.m_listResultEntries;
        if (list == null) {
            this.m_listResultEntries = new ArrayList<Map.Entry<K, R>>();
            list = this.m_listResultEntries;
        }
        list.add(entry);
    }

    @Override
    public void onException(Throwable eReason) {
        this.m_eReason = eReason;
    }

    @Override
    public void onComplete() {
        Throwable eReason = this.m_eReason;
        if (eReason == null) {
            List list = this.m_listResultEntries;
            this.complete(() -> list == null ? Collections.emptyMap() : new EntrySetMap(new ImmutableArrayList(list).getSet()));
        } else {
            this.completeExceptionally(eReason);
        }
    }
}

