/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.listener;

import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import java.util.function.Consumer;

public class SimpleMapListener<K, V>
implements MapListener<K, V> {
    protected Consumer<MapEvent<? extends K, ? extends V>> m_onInsert;
    protected Consumer<MapEvent<? extends K, ? extends V>> m_onUpdate;
    protected Consumer<MapEvent<? extends K, ? extends V>> m_onDelete;
    protected int m_nCharacteristics = 0;

    public SimpleMapListener<K, V> addInsertHandler(Consumer<? super MapEvent<? extends K, ? extends V>> onInsert) {
        this.m_onInsert = this.addHandler(this.m_onInsert, onInsert);
        return this;
    }

    public SimpleMapListener<K, V> addUpdateHandler(Consumer<? super MapEvent<? extends K, ? extends V>> onUpdate) {
        this.m_onUpdate = this.addHandler(this.m_onUpdate, onUpdate);
        return this;
    }

    public SimpleMapListener<K, V> addDeleteHandler(Consumer<? super MapEvent<? extends K, ? extends V>> onDelete) {
        this.m_onDelete = this.addHandler(this.m_onDelete, onDelete);
        return this;
    }

    public SimpleMapListener<K, V> addEventHandler(Consumer<? super MapEvent<? extends K, ? extends V>> onEvent) {
        return this.addInsertHandler(onEvent).addUpdateHandler(onEvent).addDeleteHandler(onEvent);
    }

    public SimpleMapListener<K, V> versioned() {
        this.m_nCharacteristics |= 2;
        return this;
    }

    @Override
    public SimpleMapListener<K, V> synchronous() {
        this.m_nCharacteristics |= 1;
        return this;
    }

    public SimpleMapListener<K, V> asynchronous() {
        this.m_nCharacteristics &= 0xFFFFFFFE;
        return this;
    }

    @Override
    public void entryInserted(MapEvent<K, V> evt) {
        if (this.m_onInsert != null) {
            this.m_onInsert.accept(evt);
        }
    }

    @Override
    public void entryUpdated(MapEvent<K, V> evt) {
        if (this.m_onUpdate != null) {
            this.m_onUpdate.accept(evt);
        }
    }

    @Override
    public void entryDeleted(MapEvent<K, V> evt) {
        if (this.m_onDelete != null) {
            this.m_onDelete.accept(evt);
        }
    }

    @Override
    public int characteristics() {
        return this.m_nCharacteristics;
    }

    public boolean equals(Object oThat) {
        return oThat != null && super.equals(MapListenerSupport.unwrap((MapListener)oThat));
    }

    protected Consumer<MapEvent<? extends K, ? extends V>> addHandler(Consumer<MapEvent<? extends K, ? extends V>> handlerChain, Consumer<MapEvent<? extends K, ? extends V>> handler) {
        return handlerChain == null ? handler : handlerChain.andThen(handler);
    }
}

