/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.fsm;

import com.tangosol.util.fsm.TransitionAction;
import java.util.EnumSet;

public class Transition<S extends Enum<S>> {
    private final String m_sName;
    private final EnumSet<S> m_statesFrom;
    private final S m_stateTo;
    private final TransitionAction<S> m_action;

    public Transition(String sName, EnumSet<S> statesFrom, S stateTo) {
        this(sName, statesFrom, (EnumSet<S>)stateTo, (TransitionAction<EnumSet<S>>)null);
    }

    public Transition(String sName, S stateFrom, S stateTo) {
        this(sName, stateFrom, stateTo, null);
    }

    public Transition(String sName, EnumSet<S> statesFrom, S stateTo, TransitionAction<S> action) {
        this.m_sName = sName;
        this.m_statesFrom = statesFrom;
        this.m_stateTo = stateTo;
        this.m_action = action;
    }

    public Transition(String sName, S stateFrom, S stateTo, TransitionAction<S> action) {
        this.m_sName = sName;
        this.m_statesFrom = EnumSet.of(stateFrom);
        this.m_stateTo = stateTo;
        this.m_action = action;
    }

    public String getName() {
        return this.m_sName;
    }

    public boolean isStartingState(S state) {
        return this.m_statesFrom.contains(state);
    }

    public TransitionAction<S> getAction() {
        return this.m_action;
    }

    public S getEndingState() {
        return this.m_stateTo;
    }

    public String toString() {
        return String.format("Transition{name=%s, from=%s, to=%s, action=%s}", this.m_sName, this.m_statesFrom, this.m_stateTo, this.m_action);
    }
}

