/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.fsm;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.fsm.Event;
import com.tangosol.util.fsm.ExecutionContext;
import com.tangosol.util.fsm.FiniteStateMachine;
import com.tangosol.util.fsm.FiniteStateMachineListener;
import com.tangosol.util.fsm.Instruction;
import com.tangosol.util.fsm.LifecycleAwareEvent;
import com.tangosol.util.fsm.Model;
import com.tangosol.util.fsm.RollbackTransitionException;
import com.tangosol.util.fsm.StateEntryAction;
import com.tangosol.util.fsm.StateExitAction;
import com.tangosol.util.fsm.Transition;
import com.tangosol.util.fsm.TransitionAction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class NonBlockingFiniteStateMachine<S extends Enum<S>>
implements FiniteStateMachine<S>,
ExecutionContext {
    private final TaskDependencies f_dependencies;
    private final String f_sName;
    private volatile S m_state;
    private final S m_stateInitial;
    private final EnumMap<S, EnumMap<S, Transition<S>>> f_mapTransitions;
    private final EnumMap<S, StateEntryAction<S>> f_mapEntryActions;
    private final EnumMap<S, StateExitAction<S>> f_mapExitActions;
    private final AtomicLong f_atomicTransitions;
    private volatile boolean m_fAcceptEvents;
    private volatile boolean m_fStarted;
    private volatile boolean m_fAllowTransitions;
    private final AtomicLong f_atomicPendingEvents;
    private final DaemonPool f_daemonPool;
    private final boolean m_fIgnoreExceptions;
    private final Set<FiniteStateMachineListener<S>> m_setListeners;

    public NonBlockingFiniteStateMachine(String sName, Model<S> model, S stateInitial, DaemonPoolDependencies daemonPoolDeps, boolean fIgnoreExceptions, TaskDependencies deps) {
        this.f_sName = sName;
        this.m_stateInitial = stateInitial;
        this.m_fAllowTransitions = true;
        this.f_atomicTransitions = new AtomicLong();
        this.f_atomicPendingEvents = new AtomicLong();
        this.m_fIgnoreExceptions = fIgnoreExceptions;
        this.m_setListeners = new SafeHashSet();
        this.f_dependencies = new DefaultTaskDependencies(deps);
        DefaultDaemonPoolDependencies depsPool = new DefaultDaemonPoolDependencies(daemonPoolDeps);
        depsPool.setThreadCount(1);
        depsPool.setThreadCountMax(1);
        this.f_daemonPool = Daemons.newDaemonPool(depsPool);
        Enum[] states = model.getStates();
        Class<S> clzState = model.getStateClass();
        this.f_mapTransitions = new EnumMap(clzState);
        for (Enum stateFrom : states) {
            this.f_mapTransitions.put(stateFrom, new EnumMap(clzState));
        }
        for (Transition transition : model.getTransitions()) {
            for (Enum stateFrom : states) {
                if (!transition.isStartingState(stateFrom)) continue;
                this.f_mapTransitions.get(stateFrom).put(transition.getEndingState(), transition);
            }
        }
        this.f_mapEntryActions = new EnumMap(clzState);
        this.f_mapExitActions = new EnumMap(clzState);
        for (Enum state : states) {
            this.f_mapEntryActions.put(state, model.getStateEntryActions().get(state));
            this.f_mapExitActions.put(state, model.getStateExitActions().get(state));
        }
        this.m_state = null;
    }

    @Override
    public void addListener(FiniteStateMachineListener<S> listener) {
        this.m_setListeners.add(listener);
    }

    @Override
    public void removeListener(FiniteStateMachineListener<S> listener) {
        this.m_setListeners.remove(listener);
    }

    @Override
    public String getName() {
        return this.f_sName;
    }

    @Override
    public S getState() {
        return this.m_state;
    }

    @Override
    public long getTransitionCount() {
        return this.f_atomicTransitions.get();
    }

    @Override
    public synchronized boolean start() {
        if (!this.m_fAllowTransitions) {
            throw new IllegalStateException("The FiniteStateMachine cannot be started because it was stopped");
        }
        boolean fStarting = false;
        if (!this.m_fStarted) {
            this.f_daemonPool.start();
            this.m_fAcceptEvents = true;
            this.process(new Instruction.TransitionTo<S>(this.m_stateInitial));
            this.m_fStarted = true;
            fStarting = true;
        }
        return fStarting;
    }

    @Override
    public synchronized boolean stop() {
        if (!this.m_fStarted) {
            throw new IllegalStateException("The FiniteStateMachine cannot be stopped because it has never been started");
        }
        boolean fStopping = false;
        if (this.m_fAcceptEvents) {
            this.f_daemonPool.stop();
            this.m_fAcceptEvents = false;
            this.m_fAllowTransitions = false;
            fStopping = true;
        }
        return fStopping;
    }

    public synchronized boolean quiesceThenStop() {
        if (!this.m_fStarted) {
            throw new IllegalStateException("The FiniteStateMachine cannot be stopped because it has never been started");
        }
        boolean fStopped = false;
        if (this.m_fAcceptEvents) {
            this.m_fAcceptEvents = false;
            while (this.f_atomicPendingEvents.get() > 0L) {
                try {
                    Blocking.wait(this, 500L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    Logger.log(String.format("[%s]: Thread interrupted while quiescing; stopping immediately", this.f_sName), 0);
                    Logger.log(this.toString(), 0);
                    break;
                }
            }
            this.m_fAllowTransitions = false;
            this.f_daemonPool.stop();
            fStopped = this.f_atomicPendingEvents.get() == 0L;
        }
        return fStopped;
    }

    public String toString() {
        return "NonBlockingFSM status {name:" + this.f_sName + " isStarted:" + this.m_fStarted + " isAcceptingEvents:" + this.m_fAcceptEvents + " PendingEvents:" + this.f_atomicPendingEvents.get() + "}";
    }

    @Override
    public void process(Event<S> event) {
        this.processLater(event, 0L, TimeUnit.SECONDS);
    }

    public void processLater(Event<S> event) {
        this.processLater(event, 0L, TimeUnit.SECONDS);
    }

    public void processLater(Event<S> event, long duration, TimeUnit timeUnit) {
        Event<S> preparedEvent;
        if (this.m_fAcceptEvents && (preparedEvent = this.prepareEvent(event)) != null) {
            this.f_daemonPool.schedule(new Task(preparedEvent, this.f_dependencies), timeUnit.toMillis(duration));
        }
    }

    private Event<S> prepareEvent(Event<S> event) {
        LifecycleAwareEvent prepared = null;
        if (this.m_fAcceptEvents) {
            LifecycleAwareEvent lifecycleAwareEvent;
            prepared = event instanceof LifecycleAwareEvent ? ((lifecycleAwareEvent = (LifecycleAwareEvent)event).onAccept(this) ? lifecycleAwareEvent : null) : event;
        }
        if (prepared != null) {
            this.f_atomicPendingEvents.incrementAndGet();
        }
        return prepared;
    }

    public boolean hasPendingEvents() {
        return this.m_fAllowTransitions && this.f_atomicPendingEvents.get() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Event<S> event) {
        while (event != null && this.m_fAllowTransitions) {
            if (event instanceof LifecycleAwareEvent) {
                LifecycleAwareEvent lifecycleAwareEvent = (LifecycleAwareEvent)event;
                lifecycleAwareEvent.onProcessing(this);
            }
            S stateCurrent = this.getState();
            S stateDesired = event.getDesiredState(stateCurrent, this);
            boolean fIsInitialState = stateCurrent == null;
            this.f_atomicPendingEvents.decrementAndGet();
            if (stateDesired == null) {
                event = null;
            } else {
                StringWriter writerString;
                Transition<S> transition = null;
                if (!fIsInitialState) {
                    transition = this.f_mapTransitions.get(stateCurrent).get(stateDesired);
                    if (transition == null) {
                        event = null;
                    } else {
                        TransitionAction<S> actionTransition = transition.getAction();
                        if (actionTransition != null) {
                            try {
                                actionTransition.onTransition(transition.getName(), stateCurrent, transition.getEndingState(), event, this);
                            }
                            catch (RollbackTransitionException e) {
                                Logger.log(String.format("[%s]: Transition for event %s from %s to %s has been rolled back due to:\n%s", this.f_sName, event, stateCurrent, stateDesired, e), 0);
                                event = null;
                            }
                            catch (RuntimeException e) {
                                Logger.log(e, 0);
                                if (!this.m_fIgnoreExceptions) {
                                    this.m_fAcceptEvents = false;
                                    this.m_fAllowTransitions = false;
                                    writerString = new StringWriter();
                                    PrintWriter writerPrint = new PrintWriter(writerString);
                                    e.printStackTrace(writerPrint);
                                    writerPrint.close();
                                    Logger.log(String.format("[%s]: Stopping the machine as the Transition Action %s for event %s from %s to %s raised runtime exception %s:\n%s", this.f_sName, actionTransition, event, stateCurrent, stateDesired, e, writerString.toString()), 0);
                                    break;
                                }
                                Logger.finest(String.format("[%s]: Transition Action %s for event %s from %s to %s raised runtime exception (continuing with transition and ignoring the exception):\n%s", this.f_sName, actionTransition, event, stateCurrent, stateDesired, e));
                            }
                        }
                    }
                }
                if (event != null) {
                    Object actionExit;
                    if (event instanceof LifecycleAwareEvent) {
                        LifecycleAwareEvent lifecycleAwareEvent = (LifecycleAwareEvent)event;
                        lifecycleAwareEvent.onProcessed(this);
                    }
                    if (!fIsInitialState && (actionExit = this.f_mapExitActions.get(stateCurrent)) != null) {
                        try {
                            actionExit.onExitState(stateCurrent, event, this);
                        }
                        catch (RuntimeException e) {
                            if (!this.m_fIgnoreExceptions) {
                                this.m_fAcceptEvents = false;
                                this.m_fAllowTransitions = false;
                                writerString = new StringWriter();
                                PrintWriter writerPrint = new PrintWriter(writerString);
                                e.printStackTrace(writerPrint);
                                writerPrint.close();
                                Logger.err(String.format("[%s]: Stopping the machine as the State Exit Action %s for event %s from %s to %s raised runtime exception %s:\n%s", this.f_sName, actionExit, event, stateCurrent, stateDesired, e, writerString.toString()));
                                break;
                            }
                            Logger.warn(String.format("[%s]: State Exit Action %s for event %s from %s to %s raised runtime exception (continuing with transition and ignoring the exception):\n%s", this.f_sName, actionExit, event, stateCurrent, stateDesired, e));
                        }
                    }
                    this.m_state = stateDesired;
                    if (!fIsInitialState) {
                        this.f_atomicTransitions.incrementAndGet();
                    }
                    actionExit = this.m_setListeners.iterator();
                    while (actionExit.hasNext()) {
                        FiniteStateMachineListener listener = (FiniteStateMachineListener)actionExit.next();
                        try {
                            listener.onTransition(stateCurrent, stateDesired);
                        }
                        catch (RuntimeException e) {
                            Logger.warn("Exception occurred in FiniteStateMachineListener", (Throwable)e);
                        }
                    }
                    Instruction instruction = Instruction.NOTHING;
                    StateEntryAction<S> actionEntry = this.f_mapEntryActions.get(stateDesired);
                    if (actionEntry != null) {
                        try {
                            instruction = actionEntry.onEnterState(stateCurrent, stateDesired, event, this);
                        }
                        catch (RuntimeException e) {
                            if (!this.m_fIgnoreExceptions) {
                                this.m_fAcceptEvents = false;
                                this.m_fAllowTransitions = false;
                                StringWriter writerString2 = new StringWriter();
                                PrintWriter writerPrint = new PrintWriter(writerString2);
                                e.printStackTrace(writerPrint);
                                writerPrint.close();
                                Logger.log(String.format("[%s]: Stopping the machine as the State Entry Action %s for event %s from %s to %s raised runtime exception %s:\n%s", this.f_sName, actionEntry, event, stateCurrent, stateDesired, e, writerString2.toString()), 0);
                                break;
                            }
                            Logger.finest(String.format("[%s]: State Entry Action %s for event %s from %s to %s raised runtime exception (continuing and ignoring the exception):\n%s", this.f_sName, actionEntry, event, stateCurrent, stateDesired, e));
                        }
                    }
                    if (instruction == null || instruction == Instruction.NOTHING) {
                        event = null;
                    } else if (instruction == Instruction.STOP) {
                        this.stop();
                    } else if (instruction instanceof Instruction.TransitionTo) {
                        Instruction.TransitionTo eventTransitionTo = (Instruction.TransitionTo)instruction;
                        event = this.prepareEvent(eventTransitionTo);
                    } else if (instruction instanceof DelayedTransitionTo) {
                        DelayedTransitionTo eventDelayedTransitionTo = (DelayedTransitionTo)instruction;
                        this.processLater(eventDelayedTransitionTo, eventDelayedTransitionTo.getDuration(), eventDelayedTransitionTo.getTimeUnit());
                        event = null;
                    } else if (instruction instanceof Instruction.ProcessEvent) {
                        Instruction.ProcessEvent eventDelegating = (Instruction.ProcessEvent)instruction;
                        event = this.prepareEvent(eventDelegating.getEvent());
                    } else if (instruction instanceof ProcessEventLater) {
                        ProcessEventLater eventDelayedInstruction = (ProcessEventLater)instruction;
                        this.processLater(eventDelayedInstruction.getEvent(), eventDelayedInstruction.getDuration(), eventDelayedInstruction.getTimeUnit());
                        event = null;
                    } else {
                        Logger.warn(String.format("[%s]: Ignoring Instruction [%s] returned as part of transition to %s as it an unknown type for this Finite State Machine.", this.f_sName, instruction, stateDesired));
                    }
                }
            }
            GuardSupport.heartbeat();
        }
        if (!this.m_fAcceptEvents && this.f_atomicPendingEvents.get() == 0L) {
            NonBlockingFiniteStateMachine nonBlockingFiniteStateMachine = this;
            synchronized (nonBlockingFiniteStateMachine) {
                this.notifyAll();
            }
        }
    }

    public static class DefaultTaskDependencies
    implements TaskDependencies {
        private long m_cExecutionTimeout = 5000L;
        private Object m_oAssociatedKey = "FSM-Task";

        public DefaultTaskDependencies() {
        }

        public DefaultTaskDependencies(TaskDependencies deps) {
            if (deps != null) {
                this.m_cExecutionTimeout = deps.getExecutionTimeoutMillis();
                this.m_oAssociatedKey = deps.getAssociatedKey();
            }
        }

        @Override
        public long getExecutionTimeoutMillis() {
            return this.m_cExecutionTimeout;
        }

        public DefaultTaskDependencies setExecutionTimeoutMillis(long timeout) {
            this.m_cExecutionTimeout = timeout;
            return this;
        }

        @Override
        public Object getAssociatedKey() {
            return this.m_oAssociatedKey;
        }

        public DefaultTaskDependencies setAssociatedKey(Object key) {
            this.m_oAssociatedKey = key;
            return this;
        }
    }

    public static interface TaskDependencies {
        public long getExecutionTimeoutMillis();

        public Object getAssociatedKey();
    }

    protected class Task
    implements Runnable,
    PriorityTask,
    KeyAssociation {
        private final Event<S> f_event;
        private final TaskDependencies f_dependencies;

        public Task(Event<S> event, TaskDependencies deps) {
            this.f_event = event;
            this.f_dependencies = deps;
        }

        @Override
        public Object getAssociatedKey() {
            return this.f_dependencies.getAssociatedKey();
        }

        @Override
        public void run() {
            NonBlockingFiniteStateMachine.this.processEvent(this.f_event);
        }

        @Override
        public int getSchedulingPriority() {
            return 0;
        }

        @Override
        public long getExecutionTimeoutMillis() {
            return this.f_dependencies.getExecutionTimeoutMillis();
        }

        @Override
        public long getRequestTimeoutMillis() {
            return 0L;
        }

        @Override
        public void runCanceled(boolean fAbandoned) {
        }
    }

    public static class DelayedTransitionTo<S extends Enum<S>>
    implements Instruction,
    Event<S> {
        private S m_desiredState;
        private long m_lDuration;
        private TimeUnit m_timeUnit;

        public DelayedTransitionTo(S desiredState) {
            this(desiredState, 0L, TimeUnit.MILLISECONDS);
        }

        public DelayedTransitionTo(S desiredState, long lDuration, TimeUnit timeUnit) {
            this.m_desiredState = desiredState;
            this.m_lDuration = lDuration;
            this.m_timeUnit = timeUnit;
        }

        @Override
        public S getDesiredState(S currentState, ExecutionContext context) {
            return this.m_desiredState;
        }

        public long getDuration() {
            return this.m_lDuration;
        }

        public TimeUnit getTimeUnit() {
            return this.m_timeUnit;
        }
    }

    public static class ProcessEventLater<S extends Enum<S>>
    implements Instruction {
        private Event<S> m_event;
        private long m_lDuration;
        private TimeUnit m_timeUnit;

        public ProcessEventLater(Event<S> event) {
            this(event, 0L, TimeUnit.MILLISECONDS);
        }

        public ProcessEventLater(Event<S> event, long duration, TimeUnit timeUnit) {
            this.m_event = event;
            this.m_lDuration = duration;
            this.m_timeUnit = timeUnit;
        }

        public Event<S> getEvent() {
            return this.m_event;
        }

        public long getDuration() {
            return this.m_lDuration;
        }

        public TimeUnit getTimeUnit() {
            return this.m_timeUnit;
        }
    }

    public static class SubsequentEvent<S extends Enum<S>>
    implements LifecycleAwareEvent<S> {
        private long m_cTransitions = -1L;
        private Event<S> m_event;

        public SubsequentEvent(Event<S> event) {
            this.m_event = event;
        }

        @Override
        public boolean onAccept(ExecutionContext context) {
            this.m_cTransitions = context.getTransitionCount();
            return this.m_event instanceof LifecycleAwareEvent ? ((LifecycleAwareEvent)this.m_event).onAccept(context) : true;
        }

        @Override
        public void onProcessed(ExecutionContext context) {
            if (this.m_event instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.m_event).onProcessed(context);
            }
        }

        @Override
        public void onProcessing(ExecutionContext context) {
            if (this.m_event instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.m_event).onProcessing(context);
            }
        }

        @Override
        public S getDesiredState(S currentState, ExecutionContext context) {
            if (context.getTransitionCount() == this.m_cTransitions) {
                return this.m_event.getDesiredState(currentState, context);
            }
            return null;
        }

        public String toString() {
            return String.format("SubsequentEvent{%s, @Transition #%d}", this.m_event, this.m_cTransitions + 1L);
        }
    }

    public static class CoalescedEvent<S extends Enum<S>>
    implements LifecycleAwareEvent<S> {
        private static ConcurrentHashMap<Discriminator, Event<?>> s_mapEventsByDiscriminator = new ConcurrentHashMap();
        private Object m_oDiscriminator;
        private Event<S> m_event;
        private Process m_mode;
        private Event<S> m_eventChosen;

        public CoalescedEvent(Event<S> event) {
            this(event, Process.FIRST, event.getClass());
        }

        public CoalescedEvent(Event<S> event, Process mode) {
            this(event, mode, event.getClass());
        }

        public CoalescedEvent(Event<S> event, Process mode, Object discriminator) {
            this.m_oDiscriminator = discriminator == null ? Void.class : discriminator;
            this.m_event = event;
            this.m_mode = mode;
            this.m_eventChosen = null;
        }

        @Override
        public S getDesiredState(S state, ExecutionContext context) {
            return this.m_eventChosen.getDesiredState(state, context);
        }

        @Override
        public boolean onAccept(ExecutionContext context) {
            Event<S> event = this.m_event;
            if (context instanceof NonBlockingFiniteStateMachine) {
                boolean fIsAccepted = event instanceof LifecycleAwareEvent ? ((LifecycleAwareEvent)event).onAccept(context) : true;
                Discriminator discriminator = new Discriminator((NonBlockingFiniteStateMachine)context, this.m_oDiscriminator);
                this.m_oDiscriminator = discriminator;
                if (fIsAccepted) {
                    fIsAccepted = this.m_mode == Process.FIRST ? s_mapEventsByDiscriminator.putIfAbsent(discriminator, event) == null : s_mapEventsByDiscriminator.put(discriminator, event) == null;
                }
                return fIsAccepted;
            }
            throw new UnsupportedOperationException(String.format("CoalescingEvents may only be used with %s instance", NonBlockingFiniteStateMachine.class.getName()));
        }

        @Override
        public void onProcessed(ExecutionContext context) {
            if (this.m_eventChosen instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.m_eventChosen).onProcessed(context);
            }
        }

        @Override
        public void onProcessing(ExecutionContext context) {
            this.m_eventChosen = s_mapEventsByDiscriminator.remove(this.m_oDiscriminator);
            Event<Object> event = this.m_eventChosen;
            if (event instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)event).onProcessing(context);
            }
        }

        public String toString() {
            return String.format("CoalescedEvent{%s, discriminator=%s, mode=%s}", new Object[]{this.m_event, this.m_oDiscriminator, this.m_mode});
        }

        public static enum Process {
            FIRST,
            MOST_RECENT;

        }

        public static class Discriminator {
            private NonBlockingFiniteStateMachine<?> m_machine;
            private Object m_oDiscriminator;

            public Discriminator(NonBlockingFiniteStateMachine<?> machine, Object oDiscriminator) {
                this.m_machine = machine;
                this.m_oDiscriminator = oDiscriminator;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.m_oDiscriminator == null ? 0 : this.m_oDiscriminator.hashCode());
                result = 31 * result + (this.m_machine == null ? 0 : this.m_machine.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Discriminator other = (Discriminator)obj;
                if (this.m_oDiscriminator == null ? other.m_oDiscriminator != null : !this.m_oDiscriminator.equals(other.m_oDiscriminator)) {
                    return false;
                }
                return !(this.m_machine == null ? other.m_machine != null : !this.m_machine.equals(other.m_machine));
            }
        }
    }
}

