/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import java.util.regex.Pattern;

public class RegexFilter<T, E>
extends ComparisonFilter<T, E, String> {
    private volatile transient Pattern m_pattern;

    public RegexFilter() {
    }

    public RegexFilter(ValueExtractor<? super T, ? extends E> extractor, String sRegex) {
        super(extractor, sRegex);
    }

    public RegexFilter(String sMethod, String sRegex) {
        super(sMethod, sRegex);
    }

    @Override
    protected String getOperator() {
        return "MATCHES";
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        this.ensureInitialized();
        return this.m_pattern.matcher(String.valueOf(extracted)).matches();
    }

    private void ensureInitialized() {
        if (this.m_pattern == null) {
            this.m_pattern = Pattern.compile((String)this.getValue());
        }
    }
}

