/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapEventTransformerFilter<T>
extends ExternalizableHelper
implements Filter<T>,
MapEventTransformer,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filter")
    private Filter<T> m_filter;
    @JsonbProperty(value="transformer")
    private MapEventTransformer m_transformer;

    public MapEventTransformerFilter() {
    }

    public MapEventTransformerFilter(Filter<T> filter, MapEventTransformer transformer) {
        MapEventTransformerFilter.azzert(transformer != null, "null transformer");
        this.m_filter = filter;
        this.m_transformer = transformer;
    }

    @Override
    public boolean evaluate(T o) {
        if (!(o instanceof MapEvent)) {
            throw new IllegalStateException(ClassHelper.getSimpleName(this.getClass()) + " should not be used as a general purpose filter");
        }
        Filter<T> filter = this.m_filter;
        return filter == null || filter.evaluate(o);
    }

    public MapEvent transform(MapEvent event) {
        return this.m_transformer.transform(event);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)MapEventTransformerFilter.readObject(in);
        this.m_transformer = (MapEventTransformer)MapEventTransformerFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        MapEventTransformerFilter.writeObject(out, this.m_filter);
        MapEventTransformerFilter.writeObject(out, this.m_transformer);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_transformer = (MapEventTransformer)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_transformer);
    }

    public boolean equals(Object o) {
        if (o instanceof MapEventTransformerFilter) {
            MapEventTransformerFilter that = (MapEventTransformerFilter)o;
            return MapEventTransformerFilter.equals(this.m_filter, that.m_filter) && MapEventTransformerFilter.equals(this.m_transformer, that.m_transformer);
        }
        return false;
    }

    public int hashCode() {
        Filter<T> filter = this.m_filter;
        return (this.m_filter == null ? 79 : filter.hashCode()) + MapEventTransformerFilter.hashCode(this.m_transformer);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(" + String.valueOf(this.m_filter) + ", " + String.valueOf(this.m_transformer) + ")";
    }
}

