/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapEvent;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapEventFilter<K, V>
extends ExternalizableHelper
implements Filter<MapEvent<K, V>>,
ExternalizableLite,
PortableObject {
    public static final int E_INSERTED = 1;
    public static final int E_UPDATED = 2;
    public static final int E_DELETED = 4;
    public static final int E_UPDATED_ENTERED = 8;
    public static final int E_UPDATED_LEFT = 16;
    public static final int E_UPDATED_WITHIN = 32;
    public static final int E_ALL = 7;
    public static final int E_KEYSET = 29;
    private static final int[] MASK = new int[4];
    @JsonbProperty(value="mask")
    protected int m_nMask;
    @JsonbProperty(value="filter")
    protected Filter<V> m_filter;

    public MapEventFilter() {
    }

    public MapEventFilter(int nMask) {
        this(nMask, null);
    }

    public MapEventFilter(Filter<V> filter) {
        this(29, filter);
    }

    public MapEventFilter(int nMask, Filter<V> filter) {
        if ((nMask & 0x3F) == 0) {
            throw new IllegalArgumentException("At least one E_* type must be specified");
        }
        this.m_nMask = nMask;
        this.m_filter = filter;
    }

    @Override
    public boolean evaluate(MapEvent<K, V> event) {
        int nId = event.getId();
        int nMask = this.getEventMask();
        try {
            if ((MASK[nId] & nMask) == 0) {
                return false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        Filter<V> filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        switch (nId) {
            case 1: {
                return InvocableMapHelper.evaluateEntry(filter, event.getNewEntry());
            }
            case 2: {
                boolean fNew = InvocableMapHelper.evaluateEntry(filter, event.getNewEntry());
                switch (nMask & 0x3A) {
                    case 8: {
                        return fNew && !InvocableMapHelper.evaluateEntry(filter, event.getOldEntry());
                    }
                    case 16: {
                        return !fNew && InvocableMapHelper.evaluateEntry(filter, event.getOldEntry());
                    }
                    case 24: {
                        return fNew != InvocableMapHelper.evaluateEntry(filter, event.getOldEntry());
                    }
                    case 32: {
                        return fNew && InvocableMapHelper.evaluateEntry(filter, event.getOldEntry());
                    }
                    case 40: {
                        return fNew;
                    }
                    case 48: {
                        return InvocableMapHelper.evaluateEntry(filter, event.getOldEntry());
                    }
                }
                return fNew || InvocableMapHelper.evaluateEntry(filter, event.getOldEntry());
            }
            case 3: {
                return InvocableMapHelper.evaluateEntry(filter, event.getOldEntry());
            }
        }
        return false;
    }

    public int getEventMask() {
        return this.m_nMask;
    }

    public Filter<V> getFilter() {
        return this.m_filter;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            MapEventFilter that = (MapEventFilter)o;
            return this.m_nMask == that.m_nMask && MapEventFilter.equals(this.m_filter, that.m_filter);
        }
        return false;
    }

    public int hashCode() {
        int nHash = this.m_nMask;
        Filter<V> filter = this.m_filter;
        if (filter != null) {
            nHash += filter.hashCode();
        }
        return nHash;
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder("mask=");
        int nMask = this.getEventMask();
        if (nMask == 7) {
            sb.append("ALL");
        } else if (nMask == 29) {
            sb.append("KEYSET");
        } else {
            if ((nMask & 1) != 0) {
                sb.append("INSERTED|");
            }
            if ((nMask & 2) != 0) {
                sb.append("UPDATED|");
            }
            if ((nMask & 4) != 0) {
                sb.append("DELETED|");
            }
            if ((nMask & 8) != 0) {
                sb.append("UPDATED_ENTERED|");
            }
            if ((nMask & 0x10) != 0) {
                sb.append("UPDATED_LEFT|");
            }
            if ((nMask & 0x20) != 0) {
                sb.append("UPDATED_WITHIN|");
            }
            sb.setLength(sb.length() - 1);
        }
        Filter<V> filter = this.getFilter();
        if (filter != null) {
            sb.append(", filter=").append(filter);
        }
        return sb.toString();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(" + this.getDescription() + ")";
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nMask = MapEventFilter.readInt(in);
        this.m_filter = (Filter)MapEventFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        MapEventFilter.writeInt(out, this.m_nMask);
        MapEventFilter.writeObject(out, this.m_filter);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nMask = in.readInt(0);
        this.m_filter = (Filter)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nMask);
        out.writeObject(1, this.m_filter);
    }

    static {
        MapEventFilter.MASK[1] = 1;
        MapEventFilter.MASK[2] = 58;
        MapEventFilter.MASK[3] = 4;
    }
}

