/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.filter.AbstractQueryRecorderFilter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LimitFilter<T>
extends AbstractQueryRecorderFilter<T>
implements EntryFilter<Object, T>,
IndexAwareFilter<Object, T>,
ExternalizableLite,
PortableObject,
Cloneable {
    @JsonbProperty(value="filter")
    private Filter<T> m_filter;
    @JsonbProperty(value="pageSize")
    private int m_cPageSize;
    @JsonbProperty(value="page")
    private int m_nPage;
    @JsonbProperty(value="comparator")
    private Comparator m_comparator;
    @JsonbProperty(value="topAnchor")
    private Object m_oAnchorTop;
    @JsonbProperty(value="bottomAnchor")
    private Object m_oAnchorBottom;
    private transient Object m_oCookie;
    private transient int m_cBatch;

    public LimitFilter() {
    }

    public LimitFilter(Filter<T> filter, int cPageSize) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter must be specified");
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("Limit of limit");
        }
        this.m_filter = filter;
        this.setPageSize(cPageSize);
    }

    @Override
    public boolean evaluate(T o) {
        return this.m_filter.evaluate(o);
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        return InvocableMapHelper.evaluateEntry(this.m_filter, entry);
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        Filter<T> filter = this.m_filter;
        return filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : ExtractorFilter.calculateIteratorEffectiveness(setKeys.size());
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Filter<T> filter = this.m_filter;
        if (filter instanceof IndexAwareFilter) {
            return ((IndexAwareFilter)filter).applyIndex(mapIndexes, setKeys);
        }
        return filter;
    }

    public Filter<T> getFilter() {
        return this.m_filter;
    }

    public int getPageSize() {
        return this.m_cPageSize;
    }

    public void setPageSize(int cPageSize) {
        if (cPageSize <= 0) {
            throw new IllegalArgumentException("Invalid page size");
        }
        this.m_cPageSize = cPageSize;
    }

    public int getPage() {
        return this.m_nPage;
    }

    public void setPage(int nPage) {
        if (nPage < 0) {
            throw new IllegalArgumentException("Negative page: " + nPage);
        }
        if (nPage == 0) {
            this.setTopAnchor(null);
            this.setBottomAnchor(null);
            this.setCookie(null);
        } else {
            int nPageCurr = this.m_nPage;
            if (nPage == nPageCurr + 1) {
                this.setTopAnchor(this.getBottomAnchor());
                this.setBottomAnchor(null);
            } else if (nPage == nPageCurr - 1) {
                this.setBottomAnchor(this.getTopAnchor());
                this.setTopAnchor(null);
            } else if (nPage != nPageCurr) {
                this.setTopAnchor(null);
                this.setBottomAnchor(null);
            }
        }
        this.m_nPage = nPage;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public Object getTopAnchor() {
        return this.m_oAnchorTop;
    }

    public void setTopAnchor(Object oAnchor) {
        this.m_oAnchorTop = oAnchor;
    }

    public Object getBottomAnchor() {
        return this.m_oAnchorBottom;
    }

    public void setBottomAnchor(Object oAnchor) {
        this.m_oAnchorBottom = oAnchor;
    }

    public Object getCookie() {
        return this.m_oCookie;
    }

    public void setCookie(Object oCookie) {
        this.m_oCookie = oCookie;
    }

    public int getBatchSize() {
        return this.m_cBatch;
    }

    public int setBatchSize(int cBatch) {
        this.m_cBatch = cBatch;
        return this.m_cBatch;
    }

    public void nextPage() {
        this.setPage(this.getPage() + 1);
    }

    public void previousPage() {
        this.setPage(this.getPage() - 1);
    }

    public Object[] extractPage(Object[] aEntry) {
        int cEntries = aEntry.length;
        int cPageSize = this.getPageSize();
        Comparator comparator = this.getComparator();
        if (comparator != null && cEntries > cPageSize) {
            Object oAnchorTop = this.getTopAnchor();
            Object oAnchorBottom = this.getBottomAnchor();
            if (oAnchorTop != null) {
                int ofFirst;
                int ofAnchor = Arrays.binarySearch(aEntry, new SimpleMapEntry<Object, Object>(null, oAnchorTop), comparator);
                int nShift = oAnchorBottom == null ? 1 : 0;
                int n = ofFirst = ofAnchor >= 0 ? ofAnchor + nShift : -ofAnchor - 1;
                if (ofFirst < cEntries) {
                    return this.extractPage(new SimpleEnumerator<Object>(aEntry, ofFirst, Math.min(cPageSize, cEntries - ofFirst)));
                }
                return new Object[0];
            }
            if (oAnchorBottom != null) {
                int ofAfterLast;
                int ofAnchor = Arrays.binarySearch(aEntry, new SimpleMapEntry<Object, Object>(null, oAnchorBottom), comparator);
                int n = ofAfterLast = ofAnchor >= 0 ? ofAnchor : -ofAnchor - 1;
                if (ofAfterLast > 0) {
                    int ofFirst = Math.max(0, ofAfterLast - cPageSize);
                    return this.extractPage(new SimpleEnumerator<Object>(aEntry, ofFirst, Math.min(cPageSize, ofAfterLast - ofFirst)));
                }
                return new Object[0];
            }
        }
        return this.extractPage(new SimpleEnumerator<Object>(aEntry));
    }

    public Set extractPage(Set set) {
        return new ImmutableArrayList(this.extractPage(set.iterator()));
    }

    public Object[] extractPage(Iterator iter) {
        int cPageSize = this.getPageSize();
        Comparator comparator = this.getComparator();
        Object oAnchorTop = this.getTopAnchor();
        Object oAnchorBottom = this.getBottomAnchor();
        Object[] aoEntry = new Object[cPageSize];
        int iEntry = 0;
        if (comparator == null || oAnchorTop == null && oAnchorBottom == null) {
            int cSkip = this.getPage() * cPageSize;
            if (comparator == null && oAnchorTop instanceof Integer) {
                cSkip = (Integer)oAnchorTop;
            }
            while (iter.hasNext()) {
                Object oEntry = iter.next();
                if (--cSkip >= 0) continue;
                aoEntry[iEntry] = oEntry;
                if (++iEntry != cPageSize) continue;
                break;
            }
            if (iEntry < cPageSize) {
                int cSize = iEntry;
                Object[] ao = new Object[cSize];
                if (cSize > 0) {
                    System.arraycopy(aoEntry, 0, ao, 0, cSize);
                }
                aoEntry = ao;
            }
        } else {
            boolean fHeading = oAnchorTop != null || oAnchorBottom == null;
            boolean fInclusive = oAnchorTop != null && oAnchorBottom != null;
            boolean fSkip = fHeading;
            boolean fWrap = false;
            SimpleMapEntry<Object, Object> entryTop = new SimpleMapEntry<Object, Object>(null, oAnchorTop);
            SimpleMapEntry<Object, Object> entryBottom = new SimpleMapEntry<Object, Object>(null, oAnchorBottom);
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (fSkip) {
                    int nCompare = comparator.compare(entry, entryTop);
                    fSkip = fInclusive ? nCompare < 0 : nCompare <= 0;
                    if (fSkip) continue;
                }
                if (fHeading) {
                    aoEntry[iEntry] = entry;
                    if (++iEntry != cPageSize) continue;
                    break;
                }
                if (comparator.compare(entry, entryBottom) >= 0) break;
                aoEntry[iEntry] = entry;
                if (++iEntry != cPageSize) continue;
                fWrap = true;
                iEntry = 0;
            }
            if (fWrap) {
                Object[] ao = new Object[cPageSize];
                System.arraycopy(aoEntry, iEntry, ao, 0, cPageSize - iEntry);
                System.arraycopy(aoEntry, 0, ao, cPageSize - iEntry, iEntry);
                aoEntry = ao;
            } else if (iEntry < cPageSize) {
                int cSize = iEntry;
                Object[] ao = new Object[cSize];
                if (cSize > 0) {
                    System.arraycopy(aoEntry, 0, ao, 0, cSize);
                }
                aoEntry = ao;
            }
        }
        return aoEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LimitFilter: (");
        sb.append(this.m_filter).append(" [pageSize=").append(this.m_cPageSize).append(", pageNum=").append(this.m_nPage);
        if (this.m_comparator != null) {
            sb.append(", top=").append(this.m_oAnchorTop).append(", bottom=").append(this.m_oAnchorBottom).append(", comparator=").append(this.m_comparator);
        }
        sb.append("])");
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw LimitFilter.ensureRuntimeException(e);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)LimitFilter.readObject(in);
        this.m_cPageSize = LimitFilter.readInt(in);
        this.m_nPage = LimitFilter.readInt(in);
        this.m_comparator = (Comparator)LimitFilter.readObject(in);
        this.m_oAnchorTop = LimitFilter.readObject(in);
        this.m_oAnchorBottom = LimitFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        LimitFilter.writeObject(out, this.m_filter);
        LimitFilter.writeInt(out, this.m_cPageSize);
        LimitFilter.writeInt(out, this.m_nPage);
        LimitFilter.writeObject(out, this.m_comparator);
        LimitFilter.writeObject(out, this.m_oAnchorTop);
        LimitFilter.writeObject(out, this.m_oAnchorBottom);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_cPageSize = in.readInt(1);
        this.m_nPage = in.readInt(2);
        this.m_comparator = (Comparator)in.readObject(3);
        this.m_oAnchorTop = in.readObject(4);
        this.m_oAnchorBottom = in.readObject(5);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeInt(1, this.m_cPageSize);
        out.writeInt(2, this.m_nPage);
        out.writeObject(3, this.m_comparator);
        out.writeObject(4, this.m_oAnchorTop);
        out.writeObject(5, this.m_oAnchorBottom);
    }
}

