/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.ChainedCollection;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;

public class LessFilter<T, E extends Comparable<? super E>>
extends ComparisonFilter<T, E, E>
implements IndexAwareFilter<Object, T> {
    public LessFilter() {
    }

    public LessFilter(ValueExtractor<? super T, ? extends E> extractor, E value) {
        super(extractor, value);
    }

    public LessFilter(String sMethod, E value) {
        super(sMethod, value);
    }

    @Override
    protected String getOperator() {
        return "<";
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        Comparable value = (Comparable)this.getValue();
        return extracted != null && value != null && extracted.compareTo((Comparable)value) < 0;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return -1;
        }
        Map mapContents = index.getIndexContents();
        if (mapContents.isEmpty()) {
            return 0;
        }
        int cMatch = 0;
        if (mapContents instanceof NavigableMap) {
            NavigableMap mapSorted = (NavigableMap)mapContents;
            Integer cAllOrNothing = this.allOrNothing(index, mapSorted, setKeys);
            if (cAllOrNothing != null) {
                return cAllOrNothing;
            }
            NavigableMap subMap = mapSorted.headMap((Comparable)this.getValue(), this.includeEquals());
            for (Set set : subMap.values()) {
                cMatch += LessFilter.ensureSafeSet(set).size();
            }
        } else {
            for (Map.Entry entry : mapContents.entrySet()) {
                if (!this.evaluateExtracted((E)((Comparable)entry.getKey()))) continue;
                cMatch += LessFilter.ensureSafeSet(entry.getValue()).size();
            }
        }
        return cMatch;
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Comparable value = (Comparable)this.getValue();
        if (value == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.getIndexContents().isEmpty()) {
            setKeys.clear();
            return null;
        }
        if (index.isOrdered()) {
            NavigableMap mapContents = (NavigableMap)index.getIndexContents();
            Integer cAllOrNothing = this.allOrNothing(index, mapContents, setKeys);
            if (cAllOrNothing != null) {
                if (cAllOrNothing == 0) {
                    setKeys.clear();
                }
                return null;
            }
            Set setNULL = (Set)mapContents.get(null);
            NavigableMap mapHead = mapContents.headMap(value, this.includeEquals());
            NavigableMap mapTail = mapContents.tailMap(value, !this.includeEquals());
            boolean fHeadHeavy = mapHead.size() > mapContents.size() / 2;
            setKeys.removeAll(LessFilter.ensureSafeSet(setNULL));
            if (fHeadHeavy && !index.isPartial()) {
                for (Object o : mapTail.values()) {
                    Set set = (Set)o;
                    setKeys.removeAll(LessFilter.ensureSafeSet(set));
                }
            } else {
                ArrayList<Set> listLT = new ArrayList<Set>(mapHead.size());
                for (Object o : mapHead.values()) {
                    Set set = (Set)o;
                    listLT.add(LessFilter.ensureSafeSet(set));
                }
                setKeys.retainAll(new ChainedCollection((Collection[])listLT.toArray(Set[]::new)));
            }
        } else {
            Map mapContents = index.getIndexContents();
            if (index.isPartial()) {
                ArrayList<Set> listLT = new ArrayList<Set>(mapContents.size());
                for (Map.Entry entry : mapContents.entrySet()) {
                    if (!this.evaluateExtracted((E)((Comparable)entry.getKey()))) continue;
                    listLT.add(LessFilter.ensureSafeSet(entry.getValue()));
                }
                setKeys.retainAll(new ChainedCollection((Collection[])listLT.toArray(Set[]::new)));
            } else {
                for (Map.Entry entry : mapContents.entrySet()) {
                    if (this.evaluateExtracted((E)((Comparable)entry.getKey()))) continue;
                    setKeys.removeAll(LessFilter.ensureSafeSet(entry.getValue()));
                }
            }
        }
        return null;
    }

    protected boolean includeEquals() {
        return false;
    }

    protected Integer allOrNothing(MapIndex index, NavigableMap<E, Set<?>> mapContents, Set setKeys) {
        if (!index.isPartial()) {
            Map.Entry<E, Set<?>> loEntry = mapContents.firstEntry();
            if (loEntry == null || !this.evaluateExtracted((E)((Comparable)loEntry.getKey()))) {
                return 0;
            }
            Map.Entry<E, Set<?>> hiEntry = mapContents.lastEntry();
            if (hiEntry == null) {
                return 0;
            }
            if (this.evaluateExtracted((E)((Comparable)hiEntry.getKey()))) {
                return setKeys.size();
            }
        }
        return null;
    }
}

