/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Base;
import com.tangosol.util.ChainedCollection;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InFilter<T, E>
extends ComparisonFilter<T, E, Set<? extends E>>
implements IndexAwareFilter<Object, T> {
    public InFilter() {
    }

    public InFilter(ValueExtractor<? super T, ? extends E> extractor, Set<? extends E> setValues) {
        super(extractor, new HashSet<E>(setValues));
    }

    public InFilter(String sMethod, Set<? extends E> setValues) {
        super(sMethod, new HashSet<E>(setValues));
    }

    @Override
    protected String getOperator() {
        return "IN";
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        return ((Set)this.getValue()).contains(extracted);
    }

    @Override
    public String toStringValue() {
        return Base.truncateString((Collection)this.getValue(), 255);
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return -1;
        }
        Set colValues = (Set)this.getValue();
        Map mapContents = index.getIndexContents();
        int cMatch = 0;
        for (Object value : colValues) {
            Set setEQ = mapContents.get(value);
            if (setEQ == null) continue;
            cMatch += setEQ.size();
        }
        return Math.min(cMatch, setKeys.size());
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.getIndexContents().isEmpty()) {
            setKeys.clear();
            return null;
        }
        Map mapContents = index.getIndexContents();
        Set colValues = (Set)this.getValue();
        ArrayList listInverseKeys = new ArrayList(colValues.size());
        for (Object value : colValues) {
            Set setEQ = mapContents.get(value);
            if (setEQ == null || setEQ.isEmpty()) continue;
            listInverseKeys.add(setEQ);
        }
        if (listInverseKeys.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(new ChainedCollection((Collection[])listInverseKeys.toArray(Set[]::new)));
        }
        return null;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_value = in.readCollection(1, new HashSet());
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeCollection(1, (Collection)this.m_value);
    }
}

