/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.ChainedCollection;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;

public class GreaterFilter<T, E extends Comparable<? super E>>
extends ComparisonFilter<T, E, E>
implements IndexAwareFilter<Object, T> {
    public GreaterFilter() {
    }

    public GreaterFilter(ValueExtractor<? super T, ? extends E> extractor, E value) {
        super(extractor, value);
    }

    public GreaterFilter(String sMethod, E value) {
        super(sMethod, value);
    }

    @Override
    protected String getOperator() {
        return ">";
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        Comparable value = (Comparable)this.getValue();
        return extracted != null && value != null && extracted.compareTo((Comparable)value) > 0;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return -1;
        }
        Map mapContents = index.getIndexContents();
        if (mapContents.isEmpty()) {
            return 0;
        }
        int cMatch = 0;
        if (mapContents instanceof NavigableMap) {
            NavigableMap mapSorted = (NavigableMap)mapContents;
            Integer cAllOrNothing = this.allOrNothing(index, mapSorted, setKeys);
            if (cAllOrNothing != null) {
                return cAllOrNothing;
            }
            NavigableMap subMap = mapSorted.tailMap((Comparable)this.getValue(), this.includeEquals());
            for (Set set : subMap.values()) {
                cMatch += GreaterFilter.ensureSafeSet(set).size();
            }
        } else {
            for (Map.Entry entry : mapContents.entrySet()) {
                if (!this.evaluateExtracted((E)((Comparable)entry.getKey()))) continue;
                cMatch += GreaterFilter.ensureSafeSet(entry.getValue()).size();
            }
        }
        return cMatch;
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Comparable value = (Comparable)this.getValue();
        if (value == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.getIndexContents().isEmpty()) {
            setKeys.clear();
            return null;
        }
        if (index.isOrdered()) {
            boolean fHeadHeavy;
            NavigableMap mapContents = (NavigableMap)index.getIndexContents();
            Integer cAllOrNothing = this.allOrNothing(index, mapContents, setKeys);
            if (cAllOrNothing != null) {
                if (cAllOrNothing == 0) {
                    setKeys.clear();
                }
                return null;
            }
            NavigableMap mapHead = mapContents.headMap(value, !this.includeEquals());
            NavigableMap mapTail = mapContents.tailMap(value, this.includeEquals());
            boolean bl = fHeadHeavy = mapHead.size() > mapContents.size() / 2;
            if (fHeadHeavy || index.isPartial()) {
                ArrayList<Set> listGT = new ArrayList<Set>(mapTail.size());
                for (Object o : mapTail.values()) {
                    Set set = (Set)o;
                    listGT.add(GreaterFilter.ensureSafeSet(set));
                }
                setKeys.retainAll(new ChainedCollection((Collection[])listGT.toArray(Set[]::new)));
            } else {
                for (Object o : mapHead.values()) {
                    setKeys.removeAll(GreaterFilter.ensureSafeSet((Set)o));
                }
            }
        } else {
            Map mapContents = index.getIndexContents();
            if (index.isPartial()) {
                ArrayList<Set> listGT = new ArrayList<Set>(mapContents.size());
                for (Map.Entry entry : mapContents.entrySet()) {
                    if (!this.evaluateExtracted((E)((Comparable)entry.getKey()))) continue;
                    listGT.add(GreaterFilter.ensureSafeSet(entry.getValue()));
                }
                setKeys.retainAll(new ChainedCollection((Collection[])listGT.toArray(Set[]::new)));
            } else {
                for (Map.Entry entry : mapContents.entrySet()) {
                    if (this.evaluateExtracted((E)((Comparable)entry.getKey()))) continue;
                    setKeys.removeAll(GreaterFilter.ensureSafeSet(entry.getValue()));
                }
            }
        }
        return null;
    }

    protected boolean includeEquals() {
        return false;
    }

    protected Integer allOrNothing(MapIndex index, NavigableMap<E, Set<?>> mapContents, Set setKeys) {
        if (!index.isPartial()) {
            Map.Entry<E, Set<?>> loEntry = mapContents.firstEntry();
            if (loEntry == null) {
                return 0;
            }
            if (this.evaluateExtracted((E)((Comparable)loEntry.getKey()))) {
                return setKeys.size();
            }
            Map.Entry<E, Set<?>> hiEntry = mapContents.lastEntry();
            if (hiEntry == null || !this.evaluateExtracted((E)((Comparable)hiEntry.getKey()))) {
                return 0;
            }
        }
        return null;
    }
}

