/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ContainsFilter<T, E>
extends ComparisonFilter<T, E, E>
implements IndexAwareFilter<Object, T> {
    public ContainsFilter() {
    }

    public ContainsFilter(ValueExtractor<? super T, ? extends E> extractor, E value) {
        super(extractor, value);
    }

    public ContainsFilter(String sMethod, E value) {
        super(sMethod, value);
    }

    @Override
    protected String getOperator() {
        return "CONTAINS";
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        Object value = this.getValue();
        if (extracted instanceof Collection) {
            return ((Collection)extracted).contains(value);
        }
        if (extracted instanceof Object[]) {
            Object[] aoExtracted = (Object[])extracted;
            int c = aoExtracted.length;
            for (int i = 0; i < c; ++i) {
                if (!ContainsFilter.equals(aoExtracted[i], value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return -1;
        }
        Set setEQ = index.getIndexContents().get(this.getValue());
        return setEQ == null ? 0 : setEQ.size();
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Set setEquals = index.getIndexContents().get(this.getValue());
        if (setEquals == null || setEquals.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(setEquals);
        }
        return null;
    }
}

