/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Base;
import com.tangosol.util.ChainedCollection;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ContainsAnyFilter<T, E>
extends ComparisonFilter<T, E, Set<?>>
implements IndexAwareFilter<Object, T> {
    public ContainsAnyFilter() {
    }

    @JsonbCreator
    public ContainsAnyFilter(@JsonbProperty(value="extractor") ValueExtractor<? super T, ? extends E> extractor, @JsonbProperty(value="value") Set<?> setValues) {
        super(extractor, new HashSet(setValues));
    }

    public ContainsAnyFilter(String sMethod, Set<?> setValues) {
        super(sMethod, new HashSet(setValues));
    }

    @Override
    protected String getOperator() {
        return "CONTAINS ANY";
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        block4: {
            Collection colValues;
            block3: {
                colValues = (Collection)this.getValue();
                if (!(extracted instanceof Collection)) break block3;
                Collection colExtracted = (Collection)extracted;
                for (Object oValue : colValues) {
                    if (!colExtracted.contains(oValue)) continue;
                    return true;
                }
                break block4;
            }
            if (!(extracted instanceof Object[])) break block4;
            Object[] aoExtracted = (Object[])extracted;
            for (Object oValue : colValues) {
                for (Object oExtracted : aoExtracted) {
                    if (!ContainsAnyFilter.equals(oExtracted, oValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String toStringValue() {
        return Base.truncateString((Collection)this.getValue(), 255);
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return -1;
        }
        Collection colValues = (Collection)this.getValue();
        Map mapContents = index.getIndexContents();
        int cMatch = 0;
        for (Object oValue : colValues) {
            Set setEQ = mapContents.get(oValue);
            if (setEQ == null) continue;
            cMatch += setEQ.size();
        }
        return Math.min(cMatch, setKeys.size());
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Collection colValues = (Collection)this.getValue();
        Map mapContents = index.getIndexContents();
        ArrayList listInverseKeys = new ArrayList(colValues.size());
        for (Object oValue : colValues) {
            Set setEQ = mapContents.get(oValue);
            if (setEQ == null) continue;
            listInverseKeys.add(setEQ);
        }
        if (listInverseKeys.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(new ChainedCollection((Collection[])listInverseKeys.toArray(Set[]::new)));
        }
        return null;
    }
}

