/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ExtractorFilter;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class ComparisonFilter<T, E, C>
extends ExtractorFilter<T, E> {
    @JsonbProperty(value="value")
    protected C m_value;

    public ComparisonFilter() {
    }

    public ComparisonFilter(ValueExtractor<? super T, ? extends E> extractor, C value) {
        super(extractor);
        this.m_value = value;
    }

    public ComparisonFilter(String sMethod, C value) {
        super(sMethod);
        this.m_value = value;
    }

    @Override
    public String toExpression() {
        C value = this.getValue();
        String sValue = value instanceof Number || value instanceof Collection || value instanceof Map || value.getClass().isArray() ? this.toStringValue() : "'" + String.valueOf(value) + "'";
        return this.getValueExtractor().getCanonicalName() + " " + this.getOperator() + " " + sValue;
    }

    protected String getOperator() {
        return "?";
    }

    public C getValue() {
        return this.m_value;
    }

    protected String toStringValue() {
        return String.valueOf(this.getValue());
    }

    public boolean equals(Object o) {
        if (o instanceof ComparisonFilter) {
            ComparisonFilter that = (ComparisonFilter)o;
            return this.getClass() == that.getClass() && ComparisonFilter.equals(this.m_extractor, that.m_extractor) && ComparisonFilter.equals(this.m_value, that.m_value);
        }
        return false;
    }

    public int hashCode() {
        return ComparisonFilter.hashCode(this.m_extractor) + ComparisonFilter.hashCode(this.m_value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.getValueExtractor()) + ", " + this.toStringValue() + ")";
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_value = ComparisonFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ComparisonFilter.writeObject(out, this.m_value);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_value = in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeObject(1, this.m_value);
    }
}

