/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.filter.MapEventFilter;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CacheEventFilter<K, V>
extends MapEventFilter<K, V> {
    public static final int E_SYNTHETIC = 1;
    public static final int E_NATURAL = 2;
    @JsonbProperty(value="syntheticMask")
    protected int m_nMaskSynthetic;

    public CacheEventFilter() {
    }

    public CacheEventFilter(int nMask, int nMaskSynthetic) {
        this(nMask, null, nMaskSynthetic);
    }

    public CacheEventFilter(Filter<V> filter, int nMaskSynthetic) {
        this(29, filter, nMaskSynthetic);
    }

    public CacheEventFilter(int nMask, Filter<V> filter, int nMaskSynthetic) {
        super(nMask, filter);
        this.m_nMaskSynthetic = nMaskSynthetic;
    }

    @Override
    public boolean evaluate(MapEvent<K, V> o) {
        if (o instanceof CacheEvent) {
            int nMaskSynthetic = this.m_nMaskSynthetic;
            CacheEvent evt = (CacheEvent)o;
            boolean fSynthetic = evt.isSynthetic();
            return ((nMaskSynthetic & 1) != 0 && fSynthetic || (nMaskSynthetic & 2) != 0 && !fSynthetic) && super.evaluate(o);
        }
        return super.evaluate(o);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CacheEventFilter) {
            CacheEventFilter that = (CacheEventFilter)o;
            return this.m_nMaskSynthetic == that.m_nMaskSynthetic && super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.m_nMaskSynthetic;
    }

    @Override
    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        int nMaskSynth = this.m_nMaskSynthetic;
        sb.append(super.getDescription());
        sb.append(", synthetic-mask=");
        StringBuilder sbMask = new StringBuilder();
        if ((nMaskSynth & 2) != 0) {
            sbMask.append("E_NATURAL|");
        }
        if ((nMaskSynth & 1) != 0) {
            sbMask.append("E_SYNTHETIC|");
        }
        if (sbMask.length() == 0) {
            sb.append("<none>");
        } else {
            sbMask.setLength(sbMask.length() - 1);
            sb.append((CharSequence)sbMask);
        }
        return sb.toString();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_nMaskSynthetic = CacheEventFilter.readInt(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        CacheEventFilter.writeInt(out, this.m_nMaskSynthetic);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_nMaskSynthetic = in.readInt(10);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeInt(10, this.m_nMaskSynthetic);
    }
}

