/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryMap;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AbstractQueryRecorderFilter;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.GreaterEqualsFilter;
import com.tangosol.util.filter.GreaterFilter;
import com.tangosol.util.filter.LessEqualsFilter;
import com.tangosol.util.filter.LessFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;

public class BetweenFilter<T, E extends Comparable<? super E>>
extends AndFilter {
    public BetweenFilter() {
    }

    public BetweenFilter(ValueExtractor<? super T, ? extends E> extractor, E from, E to) {
        this(extractor, (E)from, (E)to, true, true);
    }

    public BetweenFilter(String sMethod, E from, E to) {
        this(sMethod, from, to, true, true);
    }

    public BetweenFilter(String sMethod, E lowerBound, E upperBound, boolean fIncludeLowerBound, boolean fIncludeUpperBound) {
        super(fIncludeLowerBound ? new GreaterEqualsFilter(sMethod, lowerBound) : new GreaterFilter(sMethod, lowerBound), fIncludeUpperBound ? new LessEqualsFilter(sMethod, upperBound) : new LessFilter(sMethod, upperBound));
    }

    public BetweenFilter(ValueExtractor<? super T, ? extends E> extractor, E lowerBound, E upperBound, boolean fIncludeLowerBound, boolean fIncludeUpperBound) {
        super(fIncludeLowerBound ? new GreaterEqualsFilter<T, E>(extractor, lowerBound) : new GreaterFilter<T, E>(extractor, lowerBound), fIncludeUpperBound ? new LessEqualsFilter<T, E>(extractor, upperBound) : new LessFilter<T, E>(extractor, upperBound));
    }

    public ValueExtractor getValueExtractor() {
        return this.getLowerFilter().getValueExtractor();
    }

    public E getLowerBound() {
        return (E)((Comparable)this.getLowerFilter().getValue());
    }

    protected ComparisonFilter<T, E, E> getLowerFilter() {
        return (ComparisonFilter)this.getFilters()[0];
    }

    public E getUpperBound() {
        return (E)((Comparable)this.getUpperFilter().getValue());
    }

    protected ComparisonFilter<T, E, E> getUpperFilter() {
        return (ComparisonFilter)this.getFilters()[1];
    }

    public boolean isLowerBoundInclusive() {
        return this.getLowerFilter() instanceof GreaterEqualsFilter;
    }

    public boolean isUpperBoundInclusive() {
        return this.getUpperFilter() instanceof LessEqualsFilter;
    }

    @Override
    public boolean evaluate(Object oTarget) {
        return this.evaluateExtracted(this.getValueExtractor().extract(oTarget));
    }

    @Override
    public String toExpression() {
        return this.getValueExtractor().getCanonicalName() + " BETWEEN " + (this.isLowerBoundInclusive() ? (char)'[' : '(') + String.valueOf(this.getLowerBound()) + ", " + String.valueOf(this.getUpperBound()) + (this.isUpperBoundInclusive() ? (char)']' : ')');
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        ValueExtractor extractor = this.getValueExtractor();
        return this.evaluateExtracted(entry instanceof QueryMap.Entry ? ((QueryMap.Entry)entry).extract(extractor) : InvocableMapHelper.extractFromEntry(extractor, entry));
    }

    @Override
    protected boolean evaluateEntry(Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        return this.evaluateFilter(this, entry, ctx, step == null ? null : step.ensureStep(this));
    }

    @Override
    protected void optimizeFilterOrder(Map mapIndexes, Set setKeys) {
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        if (this.getLowerBound() == null || this.getUpperBound() == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.getIndexContents().isEmpty()) {
            setKeys.clear();
            return null;
        }
        Map mapInverse = index.getIndexContents();
        if (mapInverse instanceof NavigableMap) {
            this.applySortedIndex(index, setKeys, (NavigableMap)mapInverse);
            return null;
        }
        HashSet setToRetain = new HashSet();
        for (Map.Entry entry : mapInverse.entrySet()) {
            if (!this.evaluateExtracted(entry.getKey())) continue;
            setToRetain.addAll(ExtractorFilter.ensureSafeSet(entry.getValue()));
        }
        setKeys.retainAll(setToRetain);
        return null;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return -1;
        }
        Map mapContents = index.getIndexContents();
        int cMatch = 0;
        if (mapContents instanceof NavigableMap) {
            NavigableMap mapSorted = (NavigableMap)mapContents;
            Integer cAllOrNothing = this.allOrNothing(index, mapSorted, setKeys);
            if (cAllOrNothing != null) {
                return cAllOrNothing;
            }
            NavigableMap subMap = mapSorted.subMap(this.getLowerBound(), this.isLowerBoundInclusive(), this.getUpperBound(), this.isUpperBoundInclusive());
            for (Set set : subMap.values()) {
                cMatch += ExtractorFilter.ensureSafeSet(set).size();
            }
        } else {
            for (Map.Entry entry : mapContents.entrySet()) {
                if (!this.evaluateExtracted(entry.getKey())) continue;
                cMatch += ExtractorFilter.ensureSafeSet(entry.getValue()).size();
            }
        }
        return cMatch;
    }

    @Override
    public void explain(QueryContext ctx, QueryRecord.PartialResult.ExplainStep step, Set setKeys) {
        AbstractQueryRecorderFilter.explain(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step, this.getValueExtractor());
    }

    @Override
    public Filter trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Set setKeys) {
        return AbstractQueryRecorderFilter.trace(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step, this.getValueExtractor());
    }

    @Override
    public boolean trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Map.Entry entry) {
        return AbstractQueryRecorderFilter.trace(this, entry, step);
    }

    @Override
    public String toString() {
        ValueExtractor extractor = this.getValueExtractor();
        return this.getClass().getSimpleName() + "(" + String.valueOf(extractor) + (this.isLowerBoundInclusive() ? " >= " : " > ") + String.valueOf(this.getLowerBound()) + " and " + String.valueOf(extractor) + (this.isUpperBoundInclusive() ? " <= " : " < ") + String.valueOf(this.getUpperBound()) + ")";
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        E oLowerBound = this.getLowerBound();
        E oUpperBound = this.getUpperBound();
        boolean fIncludeLowerBound = this.isLowerBoundInclusive();
        boolean fIncludeUpperBound = this.isUpperBoundInclusive();
        if (oExtracted == null || oLowerBound == null || oUpperBound == null) {
            return false;
        }
        int cl = oLowerBound.compareTo((Object)oExtracted);
        if (fIncludeLowerBound && cl > 0 || !fIncludeLowerBound && cl >= 0) {
            return false;
        }
        int cu = ((Comparable)oExtracted).compareTo(oUpperBound);
        return !(fIncludeUpperBound && cu > 0 || !fIncludeUpperBound && cu >= 0);
    }

    protected void applySortedIndex(MapIndex index, Set setKeys, NavigableMap<E, Set<?>> mapContents) {
        Integer cAllOrNothing = this.allOrNothing(index, mapContents, setKeys);
        if (cAllOrNothing != null) {
            if (cAllOrNothing == 0) {
                setKeys.clear();
            }
            return;
        }
        NavigableMap<E, Set<?>> mapRange = mapContents.subMap(this.getLowerBound(), this.isLowerBoundInclusive(), this.getUpperBound(), this.isUpperBoundInclusive());
        HashSet colKeysToRetain = new HashSet();
        for (Map.Entry entry : mapRange.entrySet()) {
            colKeysToRetain.addAll(ExtractorFilter.ensureSafeSet((Set)entry.getValue()));
        }
        if (colKeysToRetain.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(colKeysToRetain);
        }
    }

    protected Integer allOrNothing(MapIndex index, NavigableMap<E, Set<?>> mapContents, Set setKeys) {
        if (!index.isPartial()) {
            Map.Entry<E, Set<?>> loEntry = mapContents.firstEntry();
            Map.Entry<E, Set<?>> hiEntry = mapContents.lastEntry();
            if (loEntry == null || hiEntry == null) {
                return 0;
            }
            Comparable loValue = (Comparable)loEntry.getKey();
            Comparable hiValue = (Comparable)hiEntry.getKey();
            if (this.evaluateExtracted(loValue) && this.evaluateExtracted(hiValue)) {
                return setKeys.size();
            }
            if (!this.getLowerFilter().evaluateExtracted(hiValue) || loValue != null && !this.getUpperFilter().evaluateExtracted(loValue)) {
                return 0;
            }
        }
        return null;
    }
}

