/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.QueryRecorderFilter;
import com.tangosol.util.filter.WrapperQueryRecorderFilter;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class ArrayFilter
extends ExternalizableHelper
implements EntryFilter,
IndexAwareFilter,
QueryRecorderFilter,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filters")
    private Filter<?>[] m_aFilter;
    @JsonbProperty(value="optimized")
    private volatile boolean m_fOptimized;
    private final transient ThreadLocal<Filter<?>[]> f_aFilterOptimized = new ThreadLocal();

    public ArrayFilter() {
    }

    public ArrayFilter(Filter<?>[] aFilter) {
        Objects.requireNonNull(aFilter);
        int c = aFilter.length;
        for (int i = 0; i < c; ++i) {
            int j = i;
            Objects.requireNonNull(aFilter[i], () -> String.format("Null element %d: %s", j, Arrays.toString(aFilter)));
        }
        this.m_aFilter = this.simplifyFilters(aFilter);
    }

    @Override
    public String toExpression() {
        String sOperator = this.getOperator();
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Filter<?>[] aFilter = this.m_aFilter;
        int c = aFilter.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(' ').append(sOperator).append(' ');
            }
            sb.append(aFilter[i] == null ? null : aFilter[i].toExpression());
        }
        sb.append(')');
        return sb.toString();
    }

    protected String getOperator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        return this.evaluateEntry(entry, null, null);
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        return this.applyIndex(mapIndexes, setKeys, null, null);
    }

    @Override
    public void explain(QueryContext ctx, QueryRecord.PartialResult.ExplainStep step, Set setKeys) {
        Filter<?>[] aFilter;
        this.optimizeFilterOrder(ctx.getBackingMapContext().getIndexMap(), setKeys);
        for (Filter<?> filter : aFilter = this.getFilters()) {
            QueryRecord.PartialResult.ExplainStep subStep = step.ensureStep(filter);
            QueryRecorderFilter<Object> filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter<Object>)filter : new WrapperQueryRecorderFilter(filter);
            filterRecorder.explain(ctx, subStep, setKeys);
        }
    }

    @Override
    public Filter trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Set setKeys) {
        step.recordPreFilterKeys(setKeys.size());
        long ldtStart = System.currentTimeMillis();
        Filter filterRemaining = this.applyIndex(ctx.getBackingMapContext().getIndexMap(), setKeys, ctx, step);
        long ldtEnd = System.currentTimeMillis();
        step.recordPostFilterKeys(setKeys.size());
        step.recordDuration(ldtEnd - ldtStart);
        return filterRemaining;
    }

    @Override
    public boolean trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Map.Entry entry) {
        step.recordPreFilterKeys(1);
        long ldtStart = System.currentTimeMillis();
        boolean fResult = this.evaluateEntry(entry, ctx, step);
        long ldtEnd = System.currentTimeMillis();
        step.recordPostFilterKeys(fResult ? 1 : 0);
        step.recordDuration(ldtEnd - ldtStart);
        return fResult;
    }

    protected abstract Filter applyIndex(Map var1, Set var2, QueryContext var3, QueryRecord.PartialResult.TraceStep var4);

    protected abstract boolean evaluateEntry(Map.Entry var1, QueryContext var2, QueryRecord.PartialResult.TraceStep var3);

    public Filter<?>[] getFilters() {
        Filter<?>[] filters = this.f_aFilterOptimized.get();
        return filters == null ? this.m_aFilter : filters;
    }

    @Deprecated(forRemoval=true)
    public void honorOrder() {
        this.m_fOptimized = true;
    }

    protected void optimizeFilterOrder(Map mapIndexes, Set setKeys) {
        if (this.m_fOptimized) {
            return;
        }
        int cFilters = this.m_aFilter.length;
        Object[] aWeighted = new WeightedFilter[cFilters];
        Filter[] aFilter = new Filter[cFilters];
        int nMax = setKeys.size() * ExtractorFilter.EVAL_COST;
        int nPos = 0;
        for (Filter<?> filter : this.m_aFilter) {
            int nEffect;
            int n = nEffect = filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : nMax;
            if (nEffect < 0) {
                nEffect = nMax;
            }
            aWeighted[nPos++] = new WeightedFilter(filter, nEffect);
        }
        Arrays.sort(aWeighted);
        for (int i = 0; i < cFilters; ++i) {
            aFilter[i] = ((WeightedFilter)aWeighted[i]).getFilter();
        }
        this.f_aFilterOptimized.set(aFilter);
        this.m_fOptimized = true;
    }

    protected Filter<?>[] simplifyFilters(Filter<?>[] aFilters) {
        return aFilters;
    }

    protected Filter applyFilter(Filter filter, int iFilter, Map mapIndexes, Set setKeys, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        if (ctx == null) {
            return ((IndexAwareFilter)filter).applyIndex(mapIndexes, setKeys);
        }
        QueryRecord.PartialResult.TraceStep subStep = step.ensureStep(filter);
        QueryRecorderFilter filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter);
        return filterRecorder.trace(ctx, subStep, setKeys);
    }

    protected boolean evaluateFilter(Filter filter, Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        if (ctx == null) {
            return InvocableMapHelper.evaluateEntry(filter, entry);
        }
        QueryRecorderFilter filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter);
        return filterRecorder.trace(ctx, step, entry);
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayFilter) {
            ArrayFilter that = (ArrayFilter)o;
            return this.getClass() == that.getClass() && ArrayFilter.equalsDeep(this.m_aFilter, that.m_aFilter);
        }
        return false;
    }

    public int hashCode() {
        int iHash = 0;
        for (Filter<?> filter : this.m_aFilter) {
            iHash += filter == null ? 0 : filter.hashCode();
        }
        return iHash;
    }

    public String toString() {
        String sName = this.getName();
        StringBuilder sb = new StringBuilder(sName);
        sb.append('(');
        Filter<?>[] aFilter = this.m_aFilter;
        int c = aFilter.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aFilter[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    protected String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cFilters = ArrayFilter.readInt(in);
        ArrayFilter.azzert(cFilters < 16384, "Unexpected number of filters.");
        Filter[] aFilter = new Filter[cFilters];
        for (int i = 0; i < cFilters; ++i) {
            aFilter[i] = (Filter)ArrayFilter.readObject(in);
        }
        this.m_aFilter = aFilter;
        this.m_fOptimized = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        Filter<?>[] aFilter = this.m_aFilter;
        int cFilters = aFilter.length;
        ArrayFilter.writeInt(out, cFilters);
        for (Filter<?> filter : aFilter) {
            ArrayFilter.writeObject(out, filter);
        }
        out.writeBoolean(this.m_fOptimized);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aFilter = (Filter[])in.readArray(0, Filter[]::new);
        this.m_fOptimized = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aFilter);
        out.writeBoolean(1, this.m_fOptimized);
    }

    protected static class WeightedFilter
    implements Comparable<WeightedFilter> {
        private final Filter m_filter;
        private final int m_nEffect;

        protected WeightedFilter(Filter filter, int nEffect) {
            this.m_filter = filter;
            this.m_nEffect = nEffect;
        }

        @Override
        public int compareTo(WeightedFilter that) {
            return Integer.compare(this.m_nEffect, that.m_nEffect);
        }

        public Filter getFilter() {
            return this.m_filter;
        }
    }
}

