/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.ChainedCollection;
import com.tangosol.util.Filter;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.SubSet;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.ArrayFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.KeyFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnyFilter
extends ArrayFilter {
    public AnyFilter() {
    }

    public AnyFilter(Filter[] afilter) {
        super(afilter);
    }

    @Override
    public boolean evaluate(Object o) {
        Filter<?>[] afilter = this.getFilters();
        int c = afilter.length;
        for (int i = 0; i < c; ++i) {
            if (!afilter[i].evaluate(o)) continue;
            return true;
        }
        return false;
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        this.optimizeFilterOrder(mapIndexes, setKeys);
        Filter<?>[] aFilter = this.getFilters();
        int cFilters = aFilter.length;
        if (cFilters > 0) {
            Filter<?> filterN = aFilter[aFilter.length - 1];
            return filterN instanceof IndexAwareFilter ? ((IndexAwareFilter)filterN).calculateEffectiveness(mapIndexes, setKeys) : setKeys.size() * ExtractorFilter.EVAL_COST;
        }
        return 1;
    }

    @Override
    protected boolean evaluateEntry(Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        for (Filter<?> filter : this.getFilters()) {
            if (!this.evaluateFilter(filter, entry, ctx, step == null ? null : step.ensureStep(filter))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Filter<?>[] simplifyFilters(Filter<?>[] aFilter) {
        LinkedHashSet setFilters = new LinkedHashSet();
        for (Filter<?> filter : aFilter) {
            if (filter instanceof AnyFilter) {
                setFilters.addAll(List.of(((AnyFilter)filter).getFilters()));
                continue;
            }
            setFilters.add(filter);
        }
        return (Filter[])setFilters.toArray(Filter[]::new);
    }

    @Override
    protected Filter applyIndex(Map mapIndexes, Set setKeys, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        this.optimizeFilterOrder(mapIndexes, setKeys);
        Filter<?>[] aFilter = this.getFilters();
        int cFilters = aFilter.length;
        ArrayList<Filter<Object>> listFilter = new ArrayList<Filter<Object>>(cFilters);
        ArrayList listMatch = new ArrayList(cFilters);
        for (int i = cFilters - 1; i >= 0; --i) {
            Filter<?> filter = aFilter[i];
            if (filter instanceof IndexAwareFilter) {
                SubSet setRemain = new SubSet(setKeys);
                Filter filterDefer = this.applyFilter(filter, i, mapIndexes, setRemain, ctx, step);
                Set setRetained = setRemain.getRetained();
                if (filterDefer == null) {
                    if (setRetained.isEmpty()) continue;
                    listMatch.add(setRetained);
                    continue;
                }
                if (!setRemain.getRemoved().isEmpty()) {
                    if (setRemain.isEmpty()) continue;
                    KeyFilter filterKey = new KeyFilter(setRetained);
                    listFilter.add(new AndFilter(filterDefer, filterKey));
                    continue;
                }
                listFilter.add(filterDefer);
                continue;
            }
            if (filter == null) continue;
            listFilter.add(filter);
        }
        HashSet setMatches = new HashSet(new ChainedCollection((Collection[])listMatch.toArray(Set[]::new)));
        cFilters = listFilter.size();
        if (cFilters == 0) {
            if (setMatches.isEmpty()) {
                setKeys.clear();
            } else {
                setKeys.retainAll(setMatches);
            }
            return null;
        }
        if (cFilters == 1 && setMatches.isEmpty()) {
            return (Filter)listFilter.get(0);
        }
        if (!setMatches.isEmpty()) {
            KeyFilter filterKey = new KeyFilter(setMatches);
            listFilter.add(0, filterKey);
            ++cFilters;
        }
        return new AnyFilter(listFilter.toArray(new Filter[cFilters]));
    }

    @Override
    protected String getName() {
        switch (this.getFilters().length) {
            case 1: {
                return this.getFilters()[0].getClass().getSimpleName();
            }
            case 2: {
                return "OrFilter";
            }
        }
        return super.getName();
    }

    @Override
    protected String getOperator() {
        return "OR";
    }
}

