/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.filter.ArrayFilter;
import com.tangosol.util.filter.BetweenFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllFilter
extends ArrayFilter {
    public AllFilter() {
    }

    public AllFilter(Filter[] afilter) {
        super(afilter);
    }

    @Override
    public boolean evaluate(Object o) {
        Filter<?>[] afilter = this.getFilters();
        int c = afilter.length;
        for (int i = 0; i < c; ++i) {
            if (afilter[i].evaluate(o)) continue;
            return false;
        }
        return true;
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        this.optimizeFilterOrder(mapIndexes, setKeys);
        Filter<?>[] aFilter = this.getFilters();
        int cFilters = aFilter.length;
        if (cFilters > 0) {
            Filter<?> filter0 = aFilter[0];
            return filter0 instanceof IndexAwareFilter ? ((IndexAwareFilter)filter0).calculateEffectiveness(mapIndexes, setKeys) : setKeys.size() * ExtractorFilter.EVAL_COST;
        }
        return 1;
    }

    @Override
    protected boolean evaluateEntry(Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        Filter<?>[] aFilter;
        for (Filter<?> filter : aFilter = this.getFilters()) {
            if (this.evaluateFilter(filter, entry, ctx, step == null ? null : step.ensureStep(filter))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Filter<?>[] simplifyFilters(Filter<?>[] aFilter) {
        LinkedHashSet setFilters = new LinkedHashSet();
        for (Filter<?> filter : aFilter) {
            if (filter instanceof AllFilter && !(filter instanceof BetweenFilter)) {
                setFilters.addAll(List.of(((AllFilter)filter).getFilters()));
                continue;
            }
            setFilters.add(filter);
        }
        return (Filter[])setFilters.toArray(Filter[]::new);
    }

    @Override
    protected Filter<?> applyIndex(Map mapIndexes, Set setKeys, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        this.optimizeFilterOrder(mapIndexes, setKeys);
        Filter<?>[] aFilter = this.getFilters();
        int cFilters = aFilter.length;
        ArrayList listFilter = new ArrayList(cFilters);
        for (int i = 0; i < cFilters; ++i) {
            Filter<?> filter = aFilter[i];
            if (filter instanceof IndexAwareFilter) {
                Filter filterNew = this.applyFilter(filter, i, mapIndexes, setKeys, ctx, step);
                if (setKeys.isEmpty()) {
                    return null;
                }
                if (filterNew == null) continue;
                listFilter.add(filterNew);
                continue;
            }
            if (filter == null) continue;
            listFilter.add(filter);
        }
        cFilters = listFilter.size();
        if (cFilters == 0) {
            return null;
        }
        if (cFilters == 1) {
            return (Filter)listFilter.get(0);
        }
        return new AllFilter(listFilter.toArray(new Filter[cFilters]));
    }

    @Override
    protected String getName() {
        switch (this.getFilters().length) {
            case 1: {
                return this.getFilters()[0].getClass().getSimpleName();
            }
            case 2: {
                return "AndFilter";
            }
        }
        return super.getName();
    }

    @Override
    protected String getOperator() {
        return "AND";
    }
}

