/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.QueryRecorderFilter;
import java.util.Map;
import java.util.Set;

public abstract class AbstractQueryRecorderFilter<T>
extends ExternalizableHelper
implements QueryRecorderFilter<T> {
    @Override
    public void explain(QueryContext ctx, QueryRecord.PartialResult.ExplainStep step, Set setKeys) {
        AbstractQueryRecorderFilter.explain(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step);
    }

    @Override
    public Filter trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Set setKeys) {
        return AbstractQueryRecorderFilter.trace(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step);
    }

    @Override
    public boolean trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Map.Entry entry) {
        return AbstractQueryRecorderFilter.trace(this, entry, step);
    }

    protected static <T> void explain(Filter<T> filter, Map mapIndexes, Set setKeys, QueryRecord.PartialResult.ExplainStep step) {
        ValueExtractor extractor = filter instanceof ExtractorFilter ? ((ExtractorFilter)filter).getValueExtractor() : null;
        AbstractQueryRecorderFilter.explain(filter, mapIndexes, setKeys, step, extractor);
    }

    protected static <T> void explain(Filter<T> filter, Map mapIndexes, Set setKeys, QueryRecord.PartialResult.ExplainStep step, ValueExtractor extractor) {
        step.recordPreFilterKeys(setKeys.size());
        if (filter instanceof IndexAwareFilter) {
            int nCost;
            if (extractor != null) {
                step.recordExtractor(extractor);
            }
            step.recordEfficiency((nCost = ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys)) < 0 ? setKeys.size() * ExtractorFilter.EVAL_COST : nCost);
        }
    }

    protected static <T> Filter<T> trace(Filter<T> filter, Map mapIndexes, Set setKeys, QueryRecord.PartialResult.TraceStep step) {
        ValueExtractor extractor = filter instanceof ExtractorFilter ? ((ExtractorFilter)filter).getValueExtractor() : null;
        return AbstractQueryRecorderFilter.trace(filter, mapIndexes, setKeys, step, extractor);
    }

    protected static <T> Filter<T> trace(Filter<T> filter, Map mapIndexes, Set setKeys, QueryRecord.PartialResult.TraceStep step, ValueExtractor extractor) {
        step.recordPreFilterKeys(setKeys.size());
        if (filter instanceof IndexAwareFilter) {
            if (extractor != null) {
                step.recordExtractor(extractor);
            }
            long ldtStart = Base.getSafeTimeMillis();
            filter = ((IndexAwareFilter)filter).applyIndex(mapIndexes, setKeys);
            long ldtEnd = Base.getSafeTimeMillis();
            step.recordDuration(ldtEnd - ldtStart);
        }
        step.recordPostFilterKeys(setKeys.size());
        return filter;
    }

    protected static <T> boolean trace(Filter<T> filter, Map.Entry entry, QueryRecord.PartialResult.TraceStep step) {
        step.recordPreFilterKeys(1);
        long ldtStart = Base.getSafeTimeMillis();
        boolean fResult = InvocableMapHelper.evaluateEntry(filter, entry);
        long ldtEnd = Base.getSafeTimeMillis();
        step.recordDuration(ldtEnd - ldtStart);
        step.recordPostFilterKeys(fResult ? 1 : 0);
        return fResult;
    }
}

