/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.internal.util.graal.ScriptManager;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ResolvingObjectInputStream;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import org.graalvm.polyglot.Value;

public class ScriptValueExtractor<T, E>
extends AbstractExtractor<T, E>
implements ExternalizableLite,
PortableObject {
    private String m_sLanguage;
    private String m_sName;
    private Object[] m_aoArgs;

    public ScriptValueExtractor() {
    }

    public ScriptValueExtractor(String sLanguage, String sName, Object ... aoArgs) {
        this.m_sLanguage = sLanguage;
        this.m_sName = sName;
        this.m_aoArgs = aoArgs;
    }

    @Override
    public E extract(T target) {
        Value value = ScriptManager.getInstance().execute(this.m_sLanguage, this.m_sName, this.m_aoArgs);
        return ((ValueExtractor)value.as(ValueExtractor.class)).extract(target);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sLanguage = in.readUTF();
        this.m_sName = in.readUTF();
        this.m_aoArgs = (Object[])ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sLanguage);
        out.writeUTF(this.m_sName);
        ExternalizableHelper.writeObject(out, this.m_aoArgs);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sLanguage = in.readString(0);
        this.m_sName = in.readString(1);
        this.m_aoArgs = in.readArray(2, Object[]::new);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sLanguage);
        out.writeString(1, this.m_sName);
        out.writeObjectArray(2, this.m_aoArgs);
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        if (!(inputStream instanceof ResolvingObjectInputStream) && !ExternalizableHelper.s_tloInEHDeserialize.get().booleanValue()) {
            throw new NotSerializableException();
        }
        inputStream.defaultReadObject();
    }
}

