/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ResolvingObjectInputStream;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.extractor.AbstractUpdater;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;

public class ReflectionUpdater
extends AbstractUpdater
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="method")
    protected String m_sMethod;
    @JsonbProperty(value="methodPrev")
    private transient Method m_methodPrev;

    public ReflectionUpdater() {
    }

    public ReflectionUpdater(String sMethod) {
        ReflectionUpdater.azzert(sMethod != null);
        this.m_sMethod = sMethod;
    }

    @Override
    public void update(Object oTarget, Object oValue) {
        if (oTarget == null) {
            throw new IllegalArgumentException("Target object is missing for the Updater: " + String.valueOf(this));
        }
        Class<?> clzTarget = oTarget.getClass();
        String sMethod = this.getMethodName();
        try {
            Method method = this.m_methodPrev;
            if (method == null || method.getDeclaringClass() != clzTarget) {
                Class[] aclzParam = new Class[1];
                if (oValue != null) {
                    aclzParam[0] = oValue.getClass();
                }
                if (!ClassHelper.isReflectionAllowed(oTarget)) {
                    throw new IllegalArgumentException("The type, " + clzTarget.getName() + ", is disallowed as a reflection target by the current reflection filter configuration");
                }
                this.m_methodPrev = method = ClassHelper.findMethod(clzTarget, sMethod, aclzParam, false);
            }
            method.invoke(oTarget, oValue);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Missing or inaccessible method: " + clzTarget.getName() + "#" + sMethod);
        }
        catch (Exception e) {
            throw ReflectionUpdater.ensureRuntimeException(e, clzTarget.getName() + "#" + sMethod + "(" + String.valueOf(oTarget) + ")");
        }
    }

    public String getMethodName() {
        return this.m_sMethod;
    }

    public boolean equals(Object o) {
        if (o instanceof ReflectionUpdater) {
            ReflectionUpdater that = (ReflectionUpdater)o;
            return this.m_sMethod.equals(that.m_sMethod);
        }
        return false;
    }

    public int hashCode() {
        return this.m_sMethod.hashCode();
    }

    public String toString() {
        return "&" + this.m_sMethod;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sMethod = in.readUTF();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sMethod);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sMethod = in.readString(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sMethod);
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        if (!(inputStream instanceof ResolvingObjectInputStream) && !ExternalizableHelper.s_tloInEHDeserialize.get().booleanValue()) {
            throw new NotSerializableException();
        }
        inputStream.defaultReadObject();
    }
}

