/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Fragment;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FragmentExtractor<T>
extends AbstractExtractor<T, Fragment<T>>
implements ExternalizableLite,
PortableObject {
    private List<ValueExtractor<? super T, ?>> m_lstExtractors;

    public FragmentExtractor() {
    }

    public FragmentExtractor(ValueExtractor<? super T, ?>[] aExtractors) {
        this.m_lstExtractors = Stream.of(aExtractors).map(ValueExtractor::of).collect(Collectors.toList());
    }

    @Override
    public Fragment<T> extract(T target) {
        int nPos = 0;
        HashMap<String, Object> mapAttr = new HashMap<String, Object>();
        for (ValueExtractor<T, ?> extractor : this.m_lstExtractors) {
            Object sName = extractor.getCanonicalName();
            if (sName == null) {
                sName = "$" + nPos;
                ++nPos;
            }
            mapAttr.put((String)sName, extractor.extract(target));
        }
        return new Fragment(mapAttr);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_lstExtractors = new ArrayList();
        FragmentExtractor.readCollection(in, this.m_lstExtractors, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        FragmentExtractor.writeCollection(out, this.m_lstExtractors);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_lstExtractors = new ArrayList();
        in.readCollection(0, this.m_lstExtractors);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeCollection(0, this.m_lstExtractors);
    }
}

