/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.ForwardOnlyMapIndex;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.IndexAwareExtractor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class DeserializationAccelerator
extends AbstractExtractor
implements IndexAwareExtractor,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="extractor")
    protected ValueExtractor m_extractor;
    @JsonbProperty(value="onDemand")
    protected boolean m_fLazy;

    public DeserializationAccelerator() {
        this(null);
    }

    public DeserializationAccelerator(ValueExtractor extractor) {
        this(extractor, false);
    }

    public DeserializationAccelerator(ValueExtractor extractor, boolean fOnDemand) {
        this.m_extractor = extractor == null ? IdentityExtractor.INSTANCE : extractor;
        this.m_fLazy = fOnDemand;
    }

    public MapIndex createIndex(boolean fOrdered, Comparator comparator, Map mapIndex, BackingMapContext ctx) {
        ValueExtractor extractor = this.m_extractor;
        MapIndex index = (MapIndex)mapIndex.get(extractor);
        if (index != null) {
            if (index.equals(this)) {
                return null;
            }
            throw new IllegalArgumentException("Repetitive addIndex call for " + String.valueOf(this));
        }
        ForwardOnlyMapIndex indexNew = new ForwardOnlyMapIndex(extractor, ctx, this.m_fLazy);
        mapIndex.put(extractor, indexNew);
        return indexNew;
    }

    public MapIndex destroyIndex(Map mapIndex) {
        return (MapIndex)mapIndex.remove(this.m_extractor);
    }

    @Override
    public Object extract(Object oTarget) {
        throw new UnsupportedOperationException("DeserializationAccelerator may not be used as an extractor.");
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)DeserializationAccelerator.readObject(in);
        this.m_fLazy = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        DeserializationAccelerator.writeObject(out, this.m_extractor);
        out.writeBoolean(this.m_fLazy);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_fLazy = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeBoolean(1, this.m_fLazy);
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            DeserializationAccelerator that = (DeserializationAccelerator)o;
            return DeserializationAccelerator.equals(this.m_extractor, that.m_extractor) && this.m_fLazy == that.m_fLazy;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_extractor.hashCode();
    }

    public String toString() {
        return "DeserializationAccelerator(extractor=" + String.valueOf(this.m_extractor) + "; lazy=" + this.m_fLazy + ")";
    }
}

