/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.ConditionalIndex;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.IndexAwareExtractor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class ConditionalExtractor<T, E>
extends AbstractExtractor<T, E>
implements IndexAwareExtractor<T, E>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filter")
    protected Filter m_filter;
    @JsonbProperty(value="extractor")
    protected ValueExtractor<T, E> m_extractor;
    @JsonbProperty(value="forwardIndex")
    protected boolean m_fForwardIndex;
    @JsonbProperty(value="optimizeMV")
    protected boolean m_fOptimizeMV;

    public ConditionalExtractor() {
    }

    public ConditionalExtractor(Filter filter, ValueExtractor<T, E> extractor, boolean fForwardIndex) {
        this(filter, extractor, fForwardIndex, true);
    }

    public ConditionalExtractor(Filter filter, ValueExtractor<T, E> extractor, boolean fForwardIndex, boolean fOptimizeMV) {
        ConditionalExtractor.azzert(filter != null && extractor != null, "Filter and extractor must not be null");
        this.m_filter = filter;
        this.m_extractor = extractor;
        this.m_fForwardIndex = fForwardIndex;
        this.m_fOptimizeMV = fOptimizeMV;
    }

    @Override
    public MapIndex createIndex(boolean fOrdered, Comparator comparator, Map<ValueExtractor<T, E>, MapIndex> mapIndex, BackingMapContext ctx) {
        ValueExtractor<T, E> extractor = this.m_extractor;
        MapIndex index = mapIndex.get(extractor);
        if (index != null) {
            if (index instanceof ConditionalIndex && ConditionalExtractor.equals(((ConditionalIndex)index).getFilter(), this.m_filter)) {
                return null;
            }
            throw new IllegalArgumentException("Repetitive addIndex call for " + String.valueOf(this));
        }
        ConditionalIndex indexNew = new ConditionalIndex(this.m_filter, extractor, fOrdered, comparator, this.m_fForwardIndex, ctx);
        indexNew.setOptimizeMV(this.m_fOptimizeMV);
        mapIndex.put(extractor, indexNew);
        return indexNew;
    }

    @Override
    public MapIndex destroyIndex(Map<ValueExtractor<T, E>, MapIndex> mapIndex) {
        return mapIndex.remove(this.m_extractor);
    }

    public ValueExtractor getExtractor() {
        return this.m_extractor;
    }

    @Override
    public E extract(Object oTarget) {
        throw new UnsupportedOperationException("ConditionalExtractor may not be used as an extractor.");
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ConditionalExtractor.readObject(in);
        this.m_extractor = (ValueExtractor)ConditionalExtractor.readObject(in);
        this.m_fForwardIndex = in.readBoolean();
        this.m_fOptimizeMV = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ConditionalExtractor.writeObject(out, this.m_filter);
        ConditionalExtractor.writeObject(out, this.m_extractor);
        out.writeBoolean(this.m_fForwardIndex);
        out.writeBoolean(this.m_fOptimizeMV);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_extractor = (ValueExtractor)in.readObject(1);
        this.m_fForwardIndex = in.readBoolean(2);
        this.m_fOptimizeMV = in.readBoolean(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_extractor);
        out.writeBoolean(2, this.m_fForwardIndex);
        out.writeBoolean(3, this.m_fOptimizeMV);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ConditionalExtractor) {
            ConditionalExtractor that = (ConditionalExtractor)o;
            return ConditionalExtractor.equals(this.m_filter, that.m_filter) && ConditionalExtractor.equals(this.m_extractor, that.m_extractor) && this.m_fForwardIndex == that.m_fForwardIndex && this.m_fOptimizeMV == that.m_fOptimizeMV;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_filter.hashCode() ^ this.m_extractor.hashCode();
    }

    public String toString() {
        return "ConditionalExtractor(extractor=" + String.valueOf(this.m_extractor) + ", filter=" + String.valueOf(this.m_filter) + ")";
    }
}

