/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionExtractor<T, E>
extends AbstractExtractor<Collection<T>, List<E>>
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="extractor")
    protected ValueExtractor<T, E> m_extractor;

    public CollectionExtractor() {
    }

    public CollectionExtractor(ValueExtractor<T, E> extractor) {
        if (extractor == null) {
            throw new IllegalArgumentException("The CollectionExtractor requires a ValueExtractor to be specified");
        }
        this.m_extractor = extractor;
    }

    @JsonbCreator
    public CollectionExtractor(@JsonbProperty(value="extractor") ValueExtractor<T, E> extractor, @JsonbProperty(value="target") int nTarget) {
        this(extractor);
        CollectionExtractor.azzert(nTarget == 0 || nTarget == 1, String.format("nTarget must be either %s or %s", 0, 1));
        this.m_nTarget = nTarget;
    }

    @Override
    public List<E> extract(Collection<T> target) {
        if (this.m_extractor == null) {
            throw new IllegalStateException("The CollectionExtractor requires a ValueExtractor to be specified");
        }
        ArrayList<E> results = new ArrayList<E>();
        if (target == null || target.isEmpty()) {
            return results;
        }
        for (T res : target) {
            results.add(this.m_extractor.extract(res));
        }
        return results;
    }

    @Override
    public ValueExtractor<Collection<T>, List<E>> fromKey() {
        return new CollectionExtractor<T, E>(this.m_extractor, 1);
    }

    @Override
    public String getCanonicalName() {
        if (this.m_sNameCanon == null) {
            this.m_sNameCanon = this.m_extractor.getCanonicalName();
        }
        return this.m_sNameCanon;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)CollectionExtractor.readObject(in);
        this.m_nTarget = CollectionExtractor.readInt(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        CollectionExtractor.writeObject(out, this.m_extractor);
        CollectionExtractor.writeInt(out, this.m_nTarget);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_nTarget = in.readInt(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeInt(1, this.m_nTarget);
    }
}

