/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.QueryMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.QueryMapComparator;
import com.tangosol.util.comparator.SafeComparator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.Serializable;
import java.util.Map;

public abstract class AbstractExtractor<T, E>
extends ExternalizableHelper
implements ValueExtractor<T, E>,
QueryMapComparator,
Serializable {
    public static final int VALUE = 0;
    public static final int KEY = 1;
    @JsonbProperty(value="target")
    protected int m_nTarget;
    protected transient String m_sNameCanon = null;

    @Override
    public E extract(T oTarget) {
        if (oTarget == null) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTarget() {
        return this.m_nTarget;
    }

    @Override
    public String getCanonicalName() {
        return this.m_sNameCanon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        String sCNameThis = this.getCanonicalName();
        if (sCNameThis != null && o instanceof ValueExtractor) {
            ValueExtractor extractorThat = (ValueExtractor)o;
            String sCNameThat = extractorThat.getCanonicalName();
            return extractorThat.getTarget() == this.getTarget() && Base.equals(sCNameThis, sCNameThat);
        }
        return false;
    }

    @Override
    public int hashCode() {
        String sCName = this.getCanonicalName();
        return sCName == null ? super.hashCode() : sCName.hashCode();
    }

    @Override
    public int compare(Object o1, Object o2) {
        return SafeComparator.compareSafe(null, this.extract(o1), this.extract(o2));
    }

    public int compareEntries(QueryMap.Entry entry1, QueryMap.Entry entry2) {
        return SafeComparator.compareSafe(null, entry1.extract(this), entry2.extract(this));
    }

    public E extractFromEntry(Map.Entry entry) {
        return this.extract(this.m_nTarget == 0 ? entry.getValue() : entry.getKey());
    }

    public E extractOriginalFromEntry(MapTrigger.Entry entry) {
        return (E)(this.m_nTarget == 1 ? this.extract(entry.getKey()) : (entry.isOriginalPresent() ? this.extract(entry.getOriginalValue()) : null));
    }

    protected boolean isCanonicallyEquatable(Object oValue) {
        return this.getCanonicalName() != null || oValue instanceof ValueExtractor && ((ValueExtractor)oValue).getCanonicalName() != null;
    }
}

