/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.comparator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.QueryMap;
import com.tangosol.util.comparator.EntryAwareComparator;
import com.tangosol.util.comparator.QueryMapComparator;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.function.Remote;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;

public class SafeComparator<T>
extends Base
implements Remote.Comparator<T>,
QueryMapComparator<T>,
EntryAwareComparator<T>,
Serializable,
ExternalizableLite,
PortableObject {
    public static final SafeComparator INSTANCE = new SafeComparator();
    @JsonbProperty(value="comparator")
    protected Comparator<? super T> m_comparator;
    @JsonbProperty(value="nullFirst")
    protected boolean m_fNullFirst = true;

    public SafeComparator() {
    }

    public SafeComparator(Comparator<? super T> comparator) {
        this(comparator, true);
    }

    public SafeComparator(Comparator<? super T> comparator, boolean fNullFirst) {
        this.m_comparator = comparator;
        this.m_fNullFirst = fNullFirst;
    }

    public static <V> Comparator<? super V> ensureSafe(Comparator<? super V> comparator) {
        return comparator == null ? SafeComparator.INSTANCE() : (comparator instanceof SafeComparator ? comparator : new SafeComparator<V>(comparator));
    }

    @Override
    public int compare(T o1, T o2) {
        return SafeComparator.compareSafe(this.getComparator(), o1, o2, this.m_fNullFirst);
    }

    @Override
    public int compareEntries(QueryMap.Entry entry1, QueryMap.Entry entry2) {
        Comparator<T> comparator = this.getComparator();
        return comparator instanceof QueryMapComparator ? ((QueryMapComparator)comparator).compareEntries(entry1, entry2) : SafeComparator.compareSafe(comparator, entry1.getValue(), entry2.getValue());
    }

    @Override
    public boolean isKeyComparator() {
        return SafeComparator.isKeyComparator(this.getComparator());
    }

    public static boolean isKeyComparator(Comparator comparator) {
        return comparator instanceof KeyExtractor || comparator instanceof EntryAwareComparator && ((EntryAwareComparator)comparator).isKeyComparator();
    }

    public Comparator<? super T> getComparator() {
        return this.m_comparator;
    }

    public boolean isNullFirst() {
        return this.m_fNullFirst;
    }

    public static <T> int compareSafe(Comparator comparator, Object o1, Object o2) {
        return SafeComparator.compareSafe(comparator, o1, o2, true);
    }

    public static int compareSafe(Comparator comparator, Object o1, Object o2, boolean fNullFirst) {
        if (comparator != null) {
            try {
                return comparator.compare(o1, o2);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (o1 == null) {
            return o2 == null ? 0 : (fNullFirst ? -1 : 1);
        }
        if (o2 == null) {
            return fNullFirst ? 1 : -1;
        }
        return ((Comparable)o1).compareTo(o2);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + " (" + String.valueOf(this.m_comparator) + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SafeComparator && this.m_fNullFirst == ((SafeComparator)o).m_fNullFirst && SafeComparator.equals(this.m_comparator, ((SafeComparator)o).m_comparator);
    }

    public int hashCode() {
        Comparator<T> comparator = this.m_comparator;
        return (comparator == null ? 17 : comparator.hashCode()) + (this.m_fNullFirst ? 1 : 0);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_comparator = (Comparator)ExternalizableHelper.readObject(in);
        try {
            this.m_fNullFirst = in.readBoolean();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_comparator);
        out.writeBoolean(this.m_fNullFirst);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_comparator = (Comparator)in.readObject(0);
        try {
            this.m_fNullFirst = in.readBoolean(1);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_comparator);
        out.writeBoolean(1, this.m_fNullFirst);
    }

    public static <T> SafeComparator<T> INSTANCE() {
        return INSTANCE;
    }
}

